/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.response.body;

import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.parts.VerificationScriptEventHandler;
import com.kms.katalon.composer.webservice.response.body.PrettyEditor;
import com.kms.katalon.composer.webservice.response.body.PreviewEditor;
import com.kms.katalon.composer.webservice.response.body.RawEditor;
import com.kms.katalon.composer.webservice.response.body.ResponseBodyEditor;
import com.kms.katalon.composer.webservice.util.WebServiceUtil;
import com.kms.katalon.core.testobject.ResponseObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;

public class ResponseBodyEditorsComposite
extends Composite {
    protected final String WS_BUNDLE_NAME = FrameworkUtil.getBundle(ResponseBodyEditorsComposite.class).getSymbolicName();
    private Map<EditorMode, ResponseBodyEditor> bodyEditors = new HashMap<EditorMode, ResponseBodyEditor>();
    private Map<EditorMode, Button> bodySelectionButtons = new HashMap<EditorMode, Button>();
    private Button prettyRadio;
    private Button rawRadio;
    private Button previewRadio;
    private Link saveResponseLink;
    private StackLayout slBodyContent;
    private ResponseObject responseObject;
    private EditorMode selectedEditorMode;
    private final String PRETTY_MODE_DEFAULT_CONTENT_TYPE = TextContentType.HTML.getContentType().toString();
    private final String PRETTY_MODE_DEFAULT_INITIAL_MESSAGE = "";

    public ResponseBodyEditorsComposite(Composite parent, int style, VerificationScriptEventHandler editorEventHandler) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Composite bodyTypeComposite = new Composite((Composite)this, 0);
        bodyTypeComposite.setLayoutData((Object)new GridData(768));
        GridLayout glBodyType = new GridLayout(2, false);
        glBodyType.marginHeight = 0;
        glBodyType.marginWidth = 0;
        bodyTypeComposite.setLayout((Layout)glBodyType);
        Composite bodyContentComposite = new Composite((Composite)this, 0);
        bodyContentComposite.setLayoutData((Object)new GridData(1808));
        this.slBodyContent = new StackLayout();
        bodyContentComposite.setLayout((Layout)this.slBodyContent);
        Composite tbBodyType = new Composite(bodyTypeComposite, 0);
        GridLayout tbLayout = new GridLayout(4, false);
        tbBodyType.setLayout((Layout)tbLayout);
        tbBodyType.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.prettyRadio = new Button(tbBodyType, 16);
        this.prettyRadio.setText(EditorMode.PRETTY.toString().toLowerCase());
        this.bodySelectionButtons.put(EditorMode.PRETTY, this.prettyRadio);
        PrettyEditor prettyEditor = new PrettyEditor(bodyContentComposite, 0);
        this.bodyEditors.put(EditorMode.PRETTY, prettyEditor);
        prettyEditor.addHandler(editorEventHandler);
        this.rawRadio = new Button(tbBodyType, 16);
        this.rawRadio.setText(EditorMode.RAW.toString().toLowerCase());
        this.bodySelectionButtons.put(EditorMode.RAW, this.rawRadio);
        RawEditor rawEditor = new RawEditor(bodyContentComposite, 0);
        this.bodyEditors.put(EditorMode.RAW, rawEditor);
        this.previewRadio = new Button(tbBodyType, 16);
        this.previewRadio.setText(EditorMode.PREVIEW.toString().toLowerCase());
        this.bodySelectionButtons.put(EditorMode.PREVIEW, this.previewRadio);
        PreviewEditor previewEditor = new PreviewEditor(bodyContentComposite, 0);
        this.bodyEditors.put(EditorMode.PREVIEW, previewEditor);
        this.saveResponseLink = new Link(tbBodyType, 0);
        this.saveResponseLink.setText("<a>Save Response</a>");
        GridData saveResponseGridData = new GridData(131072, 0x1000000, true, false);
        this.saveResponseLink.setLayoutData((Object)saveResponseGridData);
        this.saveResponseLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceUtil.openDialogAndSaveResponseBody(ResponseBodyEditorsComposite.this.responseObject);
            }
        });
        this.saveResponseLink.setEnabled(false);
        this.handleControlModifyListeners();
        ResponseObject defaultResponseOb = new ResponseObject();
        defaultResponseOb.setContentType(this.PRETTY_MODE_DEFAULT_CONTENT_TYPE);
        defaultResponseOb.setResponseText("");
        this.setInputCore(defaultResponseOb, EditorMode.PRETTY);
        this.setEditorModeRadioButtonsVisible(true);
        this.markRadioButtonSelected(this.selectedEditorMode);
    }

    public void setInput(ResponseObject responseOb) {
        this.setInputCore(responseOb, this.detectEditorMode(responseOb));
    }

    public ResponseObject getResponseObject() {
        return this.responseObject;
    }

    private void setInputCore(ResponseObject responseOb, EditorMode editorMode) {
        try {
            this.responseObject = responseOb.clone();
            this.selectedEditorMode = editorMode;
            if (WebServiceUtil.isDisplaySupportedContent(this.responseObject)) {
                this.setEditorModeRadioButtonsVisible(true);
                this.markRadioButtonSelected(this.selectedEditorMode);
            } else {
                this.setEditorModeRadioButtonsVisible(false);
            }
            for (ResponseBodyEditor childEditor : this.bodyEditors.values()) {
                childEditor.setContentBody(null);
            }
            ResponseBodyEditor selectedEditor = this.bodyEditors.get((Object)this.selectedEditorMode);
            selectedEditor.setContentBody(this.responseObject);
            this.slBodyContent.topControl = (Composite)selectedEditor;
            ((Composite)selectedEditor).getParent().layout();
            boolean shouldEnableSaveResponseLink = this.responseObject != null && this.responseObject.getResponseBodySize() > 0L;
            this.saveResponseLink.setEnabled(shouldEnableSaveResponseLink);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)"There was problem while parsing the response object.", (IStatus)new Status(4, this.WS_BUNDLE_NAME, e.getMessage(), (Throwable)e));
        }
    }

    private EditorMode detectEditorMode(ResponseObject responseObject) {
        if (WebServiceUtil.isDisplaySupportedContent(responseObject)) {
            boolean shouldDisplayPrettyEditor;
            TextContentType type = TextContentType.evaluateContentType((String)responseObject.getContentType());
            boolean bl = shouldDisplayPrettyEditor = type == TextContentType.XML || type == TextContentType.JAVASCRIPT || type == TextContentType.JSON;
            if (shouldDisplayPrettyEditor) {
                return EditorMode.PRETTY;
            }
        }
        return EditorMode.PREVIEW;
    }

    private void handleControlModifyListeners() {
        SelectionAdapter bodyTypeSelectedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    try {
                        ResponseBodyEditorsComposite.this.selectedEditorMode = EditorMode.valueOf(source.getText().toUpperCase());
                        ResponseBodyEditor editorComposite = ResponseBodyEditorsComposite.this.bodyEditors.get((Object)ResponseBodyEditorsComposite.this.selectedEditorMode);
                        editorComposite.switchModeContentBody(ResponseBodyEditorsComposite.this.responseObject);
                        ResponseBodyEditorsComposite.this.slBodyContent.topControl = (Composite)editorComposite;
                        ((Composite)editorComposite).getParent().layout();
                    }
                    catch (Exception ex) {
                        LoggerSingleton.logError((Throwable)ex);
                        ErrorDialog.openError((Shell)ResponseBodyEditorsComposite.this.getShell(), (String)StringConstants.ERROR_TITLE, (String)"There was problem while parsing the response object.", (IStatus)new Status(4, ResponseBodyEditorsComposite.this.WS_BUNDLE_NAME, ex.getMessage(), (Throwable)ex));
                    }
                }
            }
        };
        this.bodySelectionButtons.values().forEach(button -> button.addSelectionListener((SelectionListener)bodyTypeSelectedListener));
        this.bodyEditors.values().forEach(editor -> ((Composite)editor).addListener(24, event -> this.responseObject.setContentType(editor.getContentType())));
    }

    private void setEditorModeRadioButtonsVisible(boolean visible) {
        this.prettyRadio.setVisible(visible);
        this.rawRadio.setVisible(visible);
        this.previewRadio.setVisible(visible);
        this.prettyRadio.getParent().layout();
    }

    private void markRadioButtonSelected(EditorMode selectedEditorMode) {
        this.bodySelectionButtons.entrySet().forEach(e -> ((Button)e.getValue()).setSelection(false));
        Button selectedButton = this.bodySelectionButtons.get((Object)selectedEditorMode);
        selectedButton.setSelection(true);
    }

    private static enum EditorMode {
        PRETTY,
        RAW,
        PREVIEW;

    }
}

