/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.soapui;

import com.kms.katalon.composer.webservice.soapui.SoapUICredential;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SoapUIOAuth1Credential
implements SoapUICredential {
    private static final String AUTH_META_PREFIX = "Authorization:";
    private static final String AUTHORIZATION_TYPE = "Authorization:type";
    private static final String OAUTH_1_0 = "OAuth 1.0";
    private static final String AUTHORIZATION_OAUTH_CONSUMER_KEY = "Authorization:oauth_consumer_key";
    private static final String AUTHORIZATION_OAUTH_CONSUMER_SECRET = "Authorization:oauth_consumer_secret";
    private static final String AUTHORIZATION_OAUTH_SIGNATURE_METHOD = "Authorization:oauth_signature_method";
    private static final String AUTHORIZATION_OAUTH_TOKEN = "Authorization:oauth_token";
    private static final String AUTHORIZATION_OAUTH_TOKEN_SECRET = "Authorization:oauth_token_secret";
    private static final String HMAC_SHA1 = "HMAC-SHA1";
    private String profileName;
    private String consumerKey;
    private String consumerSecret;
    private String token;
    private String tokenSecret;

    public SoapUIOAuth1Credential(String profileName) {
        this.profileName = profileName;
    }

    protected String getProfileName() {
        return this.profileName;
    }

    protected String getConsumerKey() {
        return this.consumerKey;
    }

    protected void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    protected String getConsumerSecret() {
        return this.consumerSecret;
    }

    protected void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    protected String getToken() {
        return this.token;
    }

    protected void setToken(String token) {
        this.token = token;
    }

    protected String getTokenSecret() {
        return this.tokenSecret;
    }

    protected void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    @Override
    public Map<String, String> getAuthHeaders() {
        HashMap<String, String> authHeadersMap = new HashMap<String, String>();
        authHeadersMap.put(AUTHORIZATION_TYPE, OAUTH_1_0);
        authHeadersMap.put(AUTHORIZATION_OAUTH_CONSUMER_KEY, StringUtils.defaultIfBlank((String)this.consumerKey, (String)""));
        authHeadersMap.put(AUTHORIZATION_OAUTH_CONSUMER_SECRET, StringUtils.defaultIfBlank((String)this.consumerSecret, (String)""));
        authHeadersMap.put(AUTHORIZATION_OAUTH_SIGNATURE_METHOD, HMAC_SHA1);
        if (StringUtils.isNotBlank((String)this.token)) {
            authHeadersMap.put(AUTHORIZATION_OAUTH_TOKEN, this.token);
        }
        if (StringUtils.isNotBlank((String)this.tokenSecret)) {
            authHeadersMap.put(AUTHORIZATION_OAUTH_TOKEN_SECRET, this.tokenSecret);
        }
        return authHeadersMap;
    }
}

