/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.importing.model.WebServiceImportNode;
import com.kms.katalon.composer.websesrvice.wsdl.WsdlImportResult;
import com.kms.katalon.composer.websesrvice.wsdl.WsdlImporter;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.core.webservice.helper.WsdlLocatorProvider;
import com.kms.katalon.core.webservice.wsdl.support.wsdl.WsdlDefinitionLocator;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.UrlUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.wsdl.WSDLException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportFromWsdlDialog
extends CustomTitleAreaDialog {
    private String directory = "";
    private FolderEntity parentFolder;

    public ImportFromWsdlDialog(Shell parentShell, FolderEntity parentFolder) {
        super(parentShell);
        this.parentFolder = parentFolder;
        Trackings.trackOpenImportingWsdl();
    }

    private void createWebServiceRequestEntities() throws Exception {
        WsdlDefinitionLocator wsdlLocator = WsdlLocatorProvider.getLocator((String)this.directory);
        WsdlImporter importer = new WsdlImporter(wsdlLocator);
        WsdlImportResult importResult = importer.importWsdl(this.parentFolder);
        this.saveImportedArtifacts(importResult);
        this.getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)importResult.getFileEntity()));
        this.getEventBroker().post("EXPLORER/SET_SELECTED_ITEM", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)importResult.getFileEntity()));
    }

    private void saveImportedArtifacts(WsdlImportResult importResult) throws Exception {
        List importNodes = this.flatten(importResult).collect(Collectors.toList());
        for (WebServiceImportNode importNode : importNodes) {
            FileEntity fileEntity = importNode.getFileEntity();
            if (fileEntity != null && fileEntity instanceof FolderEntity) {
                FolderController.getInstance().saveFolder((FolderEntity)fileEntity);
            }
            if (fileEntity == null || !(fileEntity instanceof WebServiceRequestEntity)) continue;
            ObjectRepositoryController.getInstance().saveNewTestObject((WebElementEntity)((WebServiceRequestEntity)fileEntity));
        }
    }

    private Stream<WebServiceImportNode> flatten(WebServiceImportNode importNode) {
        Stream childImportNodes = importNode.getChildImportNodes().stream().flatMap(n -> this.flatten((WebServiceImportNode)n));
        return Stream.concat(Stream.of(importNode), childImportNodes);
    }

    private IEventBroker getEventBroker() {
        return EventBrokerSingleton.getInstance().getEventBroker();
    }

    protected void okPressed() {
        Button ok = this.getButton(0);
        boolean closeTheDialog = true;
        try {
            try {
                this.createWebServiceRequestEntities();
            }
            catch (Exception ex) {
                closeTheDialog = false;
                this.setMessage(StringConstants.EXC_INVALID_WSDL_FILE, 3);
                if (ex instanceof WSDLException) {
                    LoggerSingleton.logError((String)("Method getOperationNamesByRequestMethod has thrown WSDLException: " + String.valueOf(ex.getCause())));
                } else if (ex instanceof InterruptedException) {
                    LoggerSingleton.logError((String)("Method generateInputSOAPMessageText in runnable thread was interrupted:" + String.valueOf(ex.getCause())));
                } else if (ex instanceof InvocationTargetException) {
                    Throwable cause = ex.getCause();
                    if (cause == null) {
                        throw new IllegalStateException("Got InvocationTargetException, but the cause is null.", ex);
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Exception) {
                        LoggerSingleton.logError((String)("Invocation failed with cause: " + String.valueOf(cause)));
                    } else {
                        LoggerSingleton.logError((String)("Invocation failed with error: " + String.valueOf(cause)));
                    }
                } else {
                    LoggerSingleton.logError((Throwable)ex);
                }
                ok.setEnabled(false);
                if (closeTheDialog) {
                    super.okPressed();
                }
            }
        }
        finally {
            if (closeTheDialog) {
                super.okPressed();
            }
        }
    }

    protected boolean isResizable() {
        return false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.VIEW_DIA_TITLE_WEBSERVICE_REQ_WSDL);
    }

    protected Composite createContentArea(Composite parent) {
        this.setDialogTitle(StringConstants.VIEW_DIA_TITLE_WEBSERVICE_REQ_WSDL);
        this.setMessage(StringConstants.DIA_MSG_IMPORT_WEBSERVICE_REQ_WSDL, 1);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("URL : ");
        final Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        Composite methodComposite = new Composite(composite, 0);
        GridLayout glMethodComposite = new GridLayout();
        methodComposite.setLayout((Layout)glMethodComposite);
        Button button = new Button(methodComposite, 8);
        button.setText(StringConstants.BROWSE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog directoryDialog = new FileDialog(ImportFromWsdlDialog.this.getParentShell());
                String filePath = directoryDialog.open();
                text.setText(filePath);
                ImportFromWsdlDialog.this.directory = UrlUtil.toFileUrl((String)filePath);
            }
        });
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Button ok = ImportFromWsdlDialog.this.getButton(0);
                if (!ok.isEnabled()) {
                    ok.setEnabled(true);
                }
                ImportFromWsdlDialog.this.directory = UrlUtil.toUrl((String)((Text)e.widget).getText());
            }
        };
        text.addModifyListener(listener);
        this.messageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"https://www.w3.org/TR/wsdl/");
            }
        });
        return composite;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x = this.convertWidthInCharsToPixels(75);
        return size;
    }

    public String getWSDLSpecLocation() {
        return this.directory;
    }
}

