/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.settings.WebServicePreferenceStore;
import com.kms.katalon.composer.webservice.util.OpenAPIUtil;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportOpenApiDialog
extends CustomTitleAreaDialog {
    private String directory = "";
    private boolean isAiSelected = false;
    private Button autoGenerateButton;
    private int MB_SIZE = 1000000;
    private int MAX_SIZE = 8;
    private ScopedPreferenceStore store = WebServicePreferenceStore.getStore();
    private static final String JSON = "json";
    private static final String YAML = "yaml";
    private static final String YML = "yml";
    private final String AI_API_GENERATED_TESTCASE = "AI_API_GENERATED_TESTCASE";
    @Inject
    private ISessionController sessionController;
    @Inject
    private IFeatureController featureController;

    @Inject
    public ImportOpenApiDialog(@Named(value="activeShell") Shell parentShell) {
        super(parentShell);
        this.isAiSelected = this.store.getBoolean("AI_API_GENERATED_TESTCASE");
    }

    protected boolean isResizable() {
        return false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ComposerWebserviceMessageConstants.VIEW_DIA_TITLE_WEBSERVICE_REQ_OPENAPI);
    }

    protected Composite createContentArea(Composite parent) {
        this.setDialogTitle(ComposerWebserviceMessageConstants.VIEW_DIA_TITLE_WEBSERVICE_REQ_OPENAPI);
        this.setMessage(ComposerWebserviceMessageConstants.DIA_MSG_IMPORT_WEBSERVICE_REQ_OPENAPI, 1);
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().build();
        ComponentBuilder.label((Composite)container).text(ComposerWebserviceMessageConstants.DIA_MSG_FILE_LOCATION_OR_URL).fillHorizontal().build();
        Composite browseContainer = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).fillHorizontal().build();
        Text text = (Text)ComponentBuilder.text((Composite)browseContainer, (int)2048).fillHorizontal().onChange(event -> {
            Button ok = this.getButton(0);
            if (!ok.isEnabled()) {
                ok.setEnabled(true);
            }
            this.directory = ((Text)event.widget).getText();
        }).build();
        ComponentBuilder.button((Composite)browseContainer, (int)8).text(StringConstants.BROWSE).onSelection(event -> {
            this.getShell().pack();
            FileDialog directoryDialog = new FileDialog(this.getParentShell());
            String filePath = directoryDialog.open();
            if (!StringUtils.isEmpty((CharSequence)filePath)) {
                text.setText(filePath);
                this.directory = filePath;
            }
        }).build();
        Composite checkBoxContainer = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).fillHorizontal().gridHorizontalSpacing(0).build();
        boolean isAiEnabled = AiConfigPolicyType.AI_DISABLED != ApplicationContext.getInstance().getAiConfigPolicy().getAiConfigPolicyType();
        boolean canUseApiAIGeneratedTests = isAiEnabled && this.featureController.canUse(ProductFeature.API_AI_GENERATED_TESTS);
        this.autoGenerateButton = (Button)ComponentBuilder.checkBox((Composite)checkBoxContainer).enable(canUseApiAIGeneratedTests).text(ComposerWebserviceMessageConstants.MSG_AUTO_GENERATE_TEST_CASES_AI_FEATURES).onSelection(event -> {
            this.isAiSelected = this.autoGenerateButton.getSelection();
            this.store.setValue("AI_API_GENERATED_TESTCASE", this.isAiSelected);
        }).build();
        this.autoGenerateButton.setSelection(canUseApiAIGeneratedTests ? this.isAiSelected : false);
        this.isAiSelected = this.autoGenerateButton.getSelection();
        Composite iconAndLinkContainer = (Composite)ComponentBuilder.gridContainer((Composite)checkBoxContainer, (int)2).fillHorizontal().build();
        Composite iconBetaContainer = (Composite)ComponentBuilder.gridContainer((Composite)iconAndLinkContainer, (int)2).marginLeft(0).build();
        ComponentBuilder.label((Composite)iconBetaContainer, (int)0).image("genai/auto_generate_testcase_ai.png").build();
        if (canUseApiAIGeneratedTests) {
            ComponentBuilder.label((Composite)iconBetaContainer).text("(Beta)").enable().build();
        } else {
            ComponentBuilder.text((Composite)iconBetaContainer).text("(Beta)").disable().build();
        }
        Composite linkContainer = (Composite)ComponentBuilder.gridContainer((Composite)iconAndLinkContainer).build();
        ComponentBuilder.link((Composite)linkContainer).linkButtonText("Learn more").onSelection(event -> ComponentUtil.triggerLink((String)ComposerWebserviceMessageConstants.URL_GENERATION_API_TESTS_WITH_AI)).build();
        if (!canUseApiAIGeneratedTests) {
            Composite enableMessage = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).fillHorizontal().build();
            if (!ApplicationInfo.getLoginMethod().equals((Object)LoginMethod.SSO)) {
                ComponentBuilder.label((Composite)enableMessage).text("Not available for on-premise and offline users.").italic().build();
            } else if (!canUseApiAIGeneratedTests) {
                Session session = this.sessionController.getSession();
                Account account = session.getAccount();
                String messageOnDisableKatalonAI = MessageFormat.format("<a href=\"{0}/enable-ai-settings?accountId={1}\">Contact account owner</a> to enable this feature.", ApplicationInfo.getMyServerUrl(), account.getId().toString());
                ComponentBuilder.link((Composite)enableMessage).text(messageOnDisableKatalonAI).italic().build();
            }
        }
        return container;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        return size;
    }

    public String getSwaggerSpecLocation() {
        return this.directory;
    }

    public boolean isAITestCaseGenerateEnable() {
        return this.isAiSelected;
    }

    protected void okPressed() {
        String fileExtension = FilenameUtils.getExtension((String)this.directory);
        if (!(JSON.equalsIgnoreCase(fileExtension) || YAML.equalsIgnoreCase(fileExtension) || YML.equalsIgnoreCase(fileExtension))) {
            this.setMessage(StringConstants.EXC_INVALID_OPENAPI_FILE, 3);
            this.getShell().pack();
            this.getButton(0).setEnabled(false);
            return;
        }
        try {
            String specString = OpenAPIUtil.getSpecificationContent(this.directory);
            int fileSize = specString.getBytes(StandardCharsets.UTF_8).length / this.MB_SIZE;
            if (fileSize > this.MAX_SIZE) {
                this.setMessage(ComposerWebserviceMessageConstants.ERROR_MSG_FILE_EXCEEDS_THE_MAXIMUM_ALLOWED, 3);
            } else {
                this.store.save();
                super.okPressed();
            }
        }
        catch (IOException iOException) {
            this.setMessage(ComposerWebserviceMessageConstants.ERROR_INVALID_FORMAT_OPENAPI, 3);
        }
    }
}

