/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.viewmodel;

import com.kms.katalon.composer.webservice.viewmodel.HttpBodyEditorViewModel;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;

public class HttpBodyEditorCompositeViewModel {
    private WebServiceRequestEntity model;

    public void setModel(WebServiceRequestEntity model) {
        this.model = model;
    }

    public WebServiceRequestEntity getModel() {
        return this.model;
    }

    public void updateContentTypeByEditorViewModel(HttpBodyEditorViewModel httpBodyEditorViewModel) {
        if (httpBodyEditorViewModel.isContentTypeUpdated() && httpBodyEditorViewModel.doesUserAllowAutoUpdateContentType()) {
            WebElementPropertyEntity propertyEntity = this.findContentTypeProperty();
            String newContentType = httpBodyEditorViewModel.getContentType();
            if (propertyEntity != null) {
                propertyEntity.setValue(newContentType);
            } else {
                propertyEntity = new WebElementPropertyEntity("Content-Type", newContentType);
                this.model.getHttpHeaderProperties().add(0, propertyEntity);
            }
            httpBodyEditorViewModel.setContentTypeUpdated(false);
        }
    }

    private WebElementPropertyEntity findContentTypeProperty() {
        WebElementPropertyEntity propertyEntity = this.model.getHttpHeaderProperties().stream().filter(h -> "Content-Type".equals(h.getName())).findFirst().orElse(null);
        return propertyEntity;
    }

    public void removeContentTypeProperty() {
        WebElementPropertyEntity propertyEntity = this.findContentTypeProperty();
        if (propertyEntity != null) {
            this.model.getHttpHeaderProperties().remove(propertyEntity);
        }
    }
}

