/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.platform.internal.report;

import com.katalon.platform.api.report.LogRecord;
import com.katalon.platform.api.report.LogStatus;
import com.katalon.platform.api.report.TestStepRecord;
import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TestStepRecordImpl
implements TestStepRecord {
    private AbstractLogRecord source;
    private List<LogRecord> childRecords;

    public TestStepRecordImpl(AbstractLogRecord source) {
        this.source = source;
    }

    public String getName() {
        return this.source.getName();
    }

    public String getDescription() {
        return this.source.getDescription();
    }

    public String getMessage() {
        return this.source.getMessage();
    }

    public long getStartTime() {
        return this.source.getStartTime();
    }

    public long getEndTime() {
        return this.source.getEndTime();
    }

    public LogStatus getLogStatus() {
        return LogStatus.valueOf((String)this.source.getStatus().getStatusValue().name());
    }

    public String getStackTrace() {
        TestStatus sourceStatus = this.source.getStatus();
        return sourceStatus != null ? sourceStatus.getStackTrace() : "";
    }

    public List<LogRecord> getChildRecords() {
        if (this.source.getChildRecords() == null) {
            return Collections.emptyList();
        }
        if (this.childRecords == null) {
            this.childRecords = Arrays.asList(this.source.getChildRecords()).stream().filter(child -> child instanceof TestStepRecordImpl).map(child -> (TestStepRecordImpl)child).map(record -> record).collect(Collectors.toList());
        }
        return this.childRecords;
    }

    public List<String> getAttachments() {
        return Arrays.asList(this.source.getAttachments());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestStepRecordImpl)) {
            return false;
        }
        TestStepRecordImpl that = (TestStepRecordImpl)obj;
        return this.source.equals((Object)that.source);
    }
}

