/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.selfhealing.healers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AIService {
    private KeywordLogger logger = KeywordLogger.getInstance(this.getClass());

    private String getOpenAIAPIKey() {
        return System.getProperty("OPENAI_API_KEY");
    }

    public String ask(Question question) throws Exception {
        String model = question.model;
        RequestObject request = new RequestObject("openai-request");
        request.setRestUrl("https://api.openai.com/v1/chat/completions");
        request.setRestRequestMethod("POST");
        String apiKey = this.getOpenAIAPIKey();
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new Exception("OpenAI API key not set. Use `System.setProperty(\"OPENAI_API_KEY\", <your_api_key>)` to configure it.");
        }
        ArrayList<TestObjectProperty> headers = new ArrayList<TestObjectProperty>();
        headers.add(new TestObjectProperty("Content-Type", ConditionType.EQUALS, "application/json"));
        headers.add(new TestObjectProperty("Authorization", ConditionType.EQUALS, "Bearer " + apiKey));
        request.setHttpHeaderProperties(headers);
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", model != null ? model : "gpt-4-vision-preview");
        ArrayList messages = new ArrayList();
        question.messages.forEach(rawMessage -> {
            HashMap<String, Object> message = new HashMap<String, Object>();
            message.put("role", rawMessage.role.getValue());
            ArrayList contents = new ArrayList();
            rawMessage.contents.forEach(content -> {
                if (content.type == QuestionMessageContentType.TEXT) {
                    HashMap<String, String> textContent = new HashMap<String, String>();
                    textContent.put("type", "text");
                    textContent.put("text", content.content);
                    contents.add(textContent);
                }
                if (content.type == QuestionMessageContentType.IMAGE) {
                    if (StringUtils.isBlank((CharSequence)content.content)) {
                        return;
                    }
                    HashMap<String, Object> imageContent = new HashMap<String, Object>();
                    imageContent.put("type", "image_url");
                    HashMap<String, Object> imageUrl = new HashMap<String, Object>();
                    if (content.content.startsWith("data:image/")) {
                        imageUrl.put("url", content.content);
                    } else {
                        imageUrl.put("url", "data:image/jpeg;base64," + content.content);
                    }
                    imageContent.put("image_url", imageUrl);
                    contents.add(imageContent);
                }
            });
            message.put("content", contents);
            messages.add(message);
        });
        requestBody.put("messages", messages);
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonBody = objectMapper.writeValueAsString(requestBody);
        request.setBodyContent((HttpBodyContent)new HttpTextBodyContent(jsonBody, "UTF-8", "application/json"));
        Class<?> WebServiceCommonHelper = Class.forName("com.kms.katalon.core.webservice.helper.WebServiceCommonHelper");
        Method sendRequest = WebServiceCommonHelper.getMethod("sendRequest", RequestObject.class);
        ResponseObject response = (ResponseObject)sendRequest.invoke(null, request);
        if (response.getStatusCode() == 200) {
            JsonNode content_node;
            JsonNode firstChoice;
            JsonNode message_node;
            JsonNode choices;
            String responseText = response.getResponseText();
            JsonNode responseJson = objectMapper.readTree(responseText);
            JsonNode usage = responseJson.get("usage");
            if (usage != null) {
                int promptTokens = usage.has("prompt_tokens") ? usage.get("prompt_tokens").asInt() : 0;
                int completionTokens = usage.has("completion_tokens") ? usage.get("completion_tokens").asInt() : 0;
                int totalTokens = usage.has("total_tokens") ? usage.get("total_tokens").asInt() : 0;
                this.logger.logDebug("> Token Usage - Prompt: " + promptTokens + ", Completion: " + completionTokens + ", Total: " + totalTokens);
            }
            if ((choices = responseJson.get("choices")) != null && choices.isArray() && choices.size() > 0 && (message_node = (firstChoice = choices.get(0)).get("message")) != null && (content_node = message_node.get("content")) != null) {
                return content_node.asText();
            }
            throw new Exception("No response content found in OpenAI response");
        }
        throw new Exception("OpenAI API request failed with status: " + response.getStatusCode() + ", Response: " + response.getResponseText());
    }

    public static class Question {
        public List<QuestionMessage> messages;
        public String model;
        public Class<?> outputType;

        public Question(List<QuestionMessage> messages, String model, Class<?> outputType) {
            this.messages = messages;
            this.model = model;
            this.outputType = outputType;
        }

        public Question() {
        }

        public Question clone() {
            return new Question(new ArrayList<QuestionMessage>(this.messages), this.model, this.outputType);
        }
    }

    public static class QuestionBuilder {
        private List<QuestionMessage> messages = new ArrayList<QuestionMessage>();
        private String model;
        private Class<?> outputType;

        public static QuestionBuilder create() {
            return new QuestionBuilder();
        }

        public QuestionBuilder addMessage(QuestionMessage message) {
            this.messages.add(message);
            return this;
        }

        public QuestionBuilder model(String model) {
            this.model = model;
            return this;
        }

        public QuestionBuilder outputType(Class<?> outputType) {
            this.outputType = outputType;
            return this;
        }

        public Question build() {
            return new Question(new ArrayList<QuestionMessage>(this.messages), this.model, this.outputType);
        }
    }

    public static class QuestionMessage {
        public QuestionMessageRole role = QuestionMessageRole.USER;
        public List<QuestionMessageContent> contents = new ArrayList<QuestionMessageContent>();

        public QuestionMessage(QuestionMessageRole role, List<QuestionMessageContent> contents) {
            this.role = role;
            this.contents = contents;
        }
    }

    public static class QuestionMessageBuilder {
        private QuestionMessageRole role = QuestionMessageRole.USER;
        private List<QuestionMessageContent> contents = new ArrayList<QuestionMessageContent>();

        public static QuestionMessageBuilder create() {
            return new QuestionMessageBuilder();
        }

        public QuestionMessageBuilder role(QuestionMessageRole role) {
            this.role = role;
            return this;
        }

        public QuestionMessageBuilder user() {
            this.role = QuestionMessageRole.USER;
            return this;
        }

        public QuestionMessageBuilder system() {
            this.role = QuestionMessageRole.SYSTEM;
            return this;
        }

        public QuestionMessageBuilder addTextContent(String text) {
            return this.addContent(new QuestionMessageContent(QuestionMessageContentType.TEXT, text));
        }

        public QuestionMessageBuilder addImageContent(String imageBase64) {
            return this.addContent(new QuestionMessageContent(QuestionMessageContentType.IMAGE, imageBase64));
        }

        public QuestionMessageBuilder addContent(QuestionMessageContent content) {
            this.contents.add(content);
            return this;
        }

        public QuestionMessageBuilder addContents(Collection<QuestionMessageContent> contents) {
            this.contents.addAll(contents);
            return this;
        }

        public QuestionMessage build() {
            return new QuestionMessage(this.role, new ArrayList<QuestionMessageContent>(this.contents));
        }
    }

    public static class QuestionMessageContent {
        public QuestionMessageContentType type;
        public String content;

        public QuestionMessageContent(QuestionMessageContentType type, String content) {
            this.type = type;
            this.content = content;
        }
    }

    public static enum QuestionMessageContentType {
        TEXT("text"),
        IMAGE("image_url");

        private String value;

        public String getValue() {
            return this.value;
        }

        private QuestionMessageContentType(String value) {
            this.value = value;
        }
    }

    public static enum QuestionMessageRole {
        SYSTEM("system"),
        USER("user");

        private String value;

        public String getValue() {
            return this.value;
        }

        private QuestionMessageRole(String value) {
            this.value = value;
        }
    }
}

