/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.composer.dialogs;

import com.equo.chromium.swt.Browser;
import com.katalon.mobile.core.enums.MobileDevicePlatform;
import com.katalon.recorder.mobile.core.listeners.MobileRecorderNavigatorListener;
import com.katalon.recorder.mobile.core.presentation.IMobileRecorderDialog;
import com.katalon.recorder.mobile.core.presentation.IMobileRecorderNavigator;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.constants.ImageConstants;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class MobileRecorderDialog
implements IMobileRecorderDialog,
MobileRecorderNavigatorListener {
    private static boolean IS_MACOS = SWT.getPlatform().equals("cocoa");
    private static final String CONFIGURATION_PAGE_END_URL_PATTERN = "#/";
    private static int INITIAL_DIALOG_WIDTH = 590;
    private static int INITIAL_DIALOG_HEIGHT = 425;
    private static int INITIAL_DEVICE_DIALOG_WIDTH = 800;
    private static int INITIAL_DEVICE_DIALOG_HEIGHT = 1000;
    private static String DIALOG_TITLE = "Mobile Recorder";
    private static String DEVICE_DIALOG_TITLE = "Device";
    private static final String DATA_AUTOSCALE_DISABLED = "AUTOSCALE_DISABLED";
    private Shell blocker;
    private Shell mainViewShell;
    private Browser mainViewBrowser;
    private Composite mainViewContent;
    private Shell deviceViewShell;
    private Composite deviceViewContent;
    private Browser deviceViewBrowser;
    private int returnCode = 256;
    private boolean allowMainViewClose = false;
    private boolean allowDeviceViewClose = false;
    @Inject
    private IMobileRecorderNavigator navigator;

    @Inject
    public MobileRecorderDialog(Shell parent) {
        this.blocker = new Shell(parent, 65536);
        this.blocker.setSize(0, 0);
        this.blocker.open();
    }

    public void initNavigator(Browser browser) {
        this.navigator.init(browser);
        this.navigator.setRecorderDialogListener((MobileRecorderNavigatorListener)this);
    }

    public int open() {
        this.showMainView();
        Display display = this.blocker != null && !this.blocker.isDisposed() ? this.blocker.getDisplay() : Display.getDefault();
        try {
            while (!this.blocker.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            this.closeDeviceView();
            this.closeMainView();
            this.closeModalDialog();
        }
        return this.returnCode;
    }

    public void onLayoutResized(float devicePixelRatio, int width, int height) {
        if (this.mainViewShell != null && !this.mainViewShell.isDisposed()) {
            Monitor monitor = this.mainViewShell.getMonitor();
            Rectangle clientArea = monitor.getClientArea();
            int maxWidth = clientArea.width;
            int maxHeight = clientArea.height;
            Rectangle trim = this.mainViewShell.computeTrim(0, 0, width > 0 ? width : INITIAL_DIALOG_WIDTH, height > 0 ? height : INITIAL_DIALOG_HEIGHT);
            int finalWidth = Math.min(trim.width, maxWidth);
            int finalHeight = Math.min(trim.height, maxHeight);
            this.mainViewShell.setSize(finalWidth, finalHeight);
            if (IS_MACOS) {
                this.forceMainDialogRedraw();
            }
        }
    }

    public void onClose() {
        this.closeDeviceView();
        this.closeMainView();
        this.closeModalDialog();
    }

    public void onRecordingStarted(MobileDevicePlatform devicePlaform) {
        this.showDeviceView(devicePlaform);
    }

    public void onRecordingStopped() {
        this.closeDeviceView();
    }

    private void showMainView() {
        Display.getDefault().asyncExec(() -> {
            this.mainViewShell = new Shell(this.blocker, 1264);
            this.mainViewShell.setData(DATA_AUTOSCALE_DISABLED, (Object)false);
            this.mainViewShell.setText(DIALOG_TITLE);
            this.mainViewShell.setSize(INITIAL_DIALOG_WIDTH, INITIAL_DIALOG_HEIGHT);
            this.mainViewShell.setImage(this.getLogo());
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            this.mainViewShell.setLayout((Layout)layout);
            this.mainViewShell.addListener(21, this::onMainViewClose);
            this.mainViewContent = new Composite((Composite)this.mainViewShell, 0);
            this.mainViewContent.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout contentLayout = new GridLayout(1, false);
            contentLayout.marginWidth = 0;
            contentLayout.marginHeight = 0;
            contentLayout.horizontalSpacing = 0;
            contentLayout.verticalSpacing = 0;
            this.mainViewContent.setLayout((Layout)contentLayout);
            Monitor monitor = this.mainViewShell.getMonitor();
            Rectangle clientArea = monitor.getClientArea();
            Point currentSize = this.mainViewShell.getSize();
            int dialogWidth = currentSize.x;
            int dialogHeight = currentSize.y;
            int x = clientArea.x + (clientArea.width - dialogWidth) / 2;
            int y = clientArea.y + (clientArea.height - dialogHeight) / 2;
            this.mainViewShell.setLocation(x, y);
            this.mainViewBrowser = (Browser)ComponentBuilder.browser((Composite)this.mainViewContent).defaultBrowserConfig().fill().build();
            this.initNavigator(this.mainViewBrowser);
            this.mainViewShell.open();
        });
    }

    private void showDeviceView(MobileDevicePlatform devicePlatform) {
        Display.getDefault().asyncExec(() -> {
            if (this.deviceViewShell == null || this.deviceViewShell.isDisposed()) {
                this.deviceViewShell = new Shell(this.blocker, 1264);
                this.deviceViewShell.setData(DATA_AUTOSCALE_DISABLED, (Object)false);
                this.deviceViewShell.setText(DEVICE_DIALOG_TITLE);
                this.deviceViewShell.setSize(INITIAL_DEVICE_DIALOG_WIDTH, INITIAL_DEVICE_DIALOG_HEIGHT);
                this.deviceViewShell.setImage(this.getLogo());
                GridLayout layout = new GridLayout(1, false);
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.horizontalSpacing = 0;
                layout.verticalSpacing = 0;
                this.deviceViewShell.setLayout((Layout)layout);
                int x = this.mainViewShell.getLocation().x + this.mainViewShell.getSize().x + 10;
                int y = this.mainViewShell.getLocation().y;
                this.deviceViewShell.setLocation(x, y);
                this.deviceViewShell.addListener(21, this::onDeviceViewClose);
                this.deviceViewContent = new Composite((Composite)this.deviceViewShell, 0);
                this.deviceViewContent.setLayoutData((Object)new GridData(4, 4, true, true));
                GridLayout contentLayout = new GridLayout(1, false);
                contentLayout.marginWidth = 0;
                contentLayout.marginHeight = 0;
                contentLayout.horizontalSpacing = 0;
                contentLayout.verticalSpacing = 0;
                this.deviceViewContent.setLayout((Layout)contentLayout);
                this.deviceViewBrowser = (Browser)ComponentBuilder.browser((Composite)this.deviceViewContent).defaultBrowserConfig().fill().build();
                this.navigator.initDeviceView(this.deviceViewBrowser, devicePlatform);
                this.deviceViewShell.open();
            } else {
                this.deviceViewShell.forceActive();
            }
        });
    }

    private void closeModalDialog() {
        Display.getDefault().syncExec(() -> {
            if (this.blocker != null && !this.blocker.isDisposed()) {
                this.blocker.dispose();
            }
        });
    }

    private void closeMainView() {
        Display.getDefault().syncExec(() -> {
            if (this.mainViewBrowser != null && !this.mainViewBrowser.isDisposed()) {
                this.mainViewBrowser.dispose();
            }
            if (this.mainViewContent != null && !this.mainViewContent.isDisposed()) {
                this.mainViewContent.dispose();
            }
            if (this.mainViewShell != null && !this.mainViewShell.isDisposed()) {
                this.allowMainViewClose = true;
                this.mainViewShell.removeListener(21, this::onMainViewClose);
                this.mainViewShell.dispose();
            }
        });
    }

    private void closeDeviceView() {
        Display.getDefault().syncExec(() -> {
            if (this.deviceViewBrowser != null && !this.deviceViewBrowser.isDisposed()) {
                this.deviceViewBrowser.dispose();
            }
            if (this.deviceViewContent != null && !this.deviceViewContent.isDisposed()) {
                this.deviceViewContent.dispose();
            }
            if (this.deviceViewShell != null && !this.deviceViewShell.isDisposed()) {
                this.allowDeviceViewClose = true;
                this.deviceViewShell.removeListener(21, this::onDeviceViewClose);
                this.deviceViewShell.dispose();
            }
        });
    }

    private void forceMainDialogRedraw() {
        Display.getDefault().asyncExec(() -> {
            if (this.mainViewShell == null || this.mainViewShell.isDisposed()) {
                return;
            }
            this.mainViewShell.setRedraw(false);
            if (this.mainViewContent != null && !this.mainViewContent.isDisposed()) {
                this.mainViewContent.setRedraw(false);
                this.mainViewContent.pack();
                this.mainViewContent.layout(true, true);
                this.mainViewContent.setRedraw(true);
            }
            this.mainViewShell.layout(true, true);
            this.mainViewShell.setRedraw(true);
            if (this.mainViewBrowser != null && !this.mainViewBrowser.isDisposed()) {
                this.mainViewBrowser.redraw();
                this.mainViewBrowser.update();
            }
            this.mainViewShell.redraw();
            this.mainViewShell.update();
        });
    }

    private void onMainViewClose(Event event) {
        event.doit = this.allowMainViewClose;
        if (this.mainViewBrowser != null && !this.mainViewBrowser.isDisposed() && !this.allowMainViewClose) {
            boolean isOnConfigurationPage;
            String currentUrl = this.mainViewBrowser.getUrl();
            boolean bl = isOnConfigurationPage = StringUtils.isNotEmpty((CharSequence)currentUrl) && currentUrl.endsWith(CONFIGURATION_PAGE_END_URL_PATTERN);
            if (isOnConfigurationPage) {
                this.navigator.retrieveConfigurationBeforeClosing();
                return;
            }
        }
        this.navigator.close();
    }

    private void onDeviceViewClose(Event event) {
        event.doit = this.allowDeviceViewClose;
    }

    private Image getLogo() {
        if (ColorUtil.isDarkTheme()) {
            return ImageConstants.RECORDER_NEW_LOGO_DARK_48;
        }
        return ImageConstants.RECORDER_NEW_LOGO_LIGHT_48;
    }
}

