/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.keyword.dialogs.DuplicatedImportDialog;
import com.kms.katalon.composer.keyword.logging.ChangeFile;
import com.kms.katalon.composer.keyword.logging.GitKeywordObject;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.FileHashUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImportFolderHandler {
    private final String TIMESTAMP_FORMAT = "hh:mm:ss - dd/MM/yyyy";
    @Inject
    IEventBroker eventBroker;

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            Shell shell = Display.getCurrent().getActiveShell();
            DirectoryDialog directoryDialog = new DirectoryDialog(shell, 131072);
            directoryDialog.setMessage("Select existing keyword folder to import to this keyword folder");
            String selectedFolder = directoryDialog.open();
            if (selectedFolder == null) {
                return;
            }
            File importedFolder = new File(selectedFolder);
            if (importedFolder != null && importedFolder.exists() && importedFolder.isDirectory()) {
                Trackings.trackImportKeywords((String)"folder");
                this.copyFilesToKeywordsDirectory(shell, importedFolder, "", "");
            }
            FolderTreeEntity keywordRootFolder = new FolderTreeEntity(FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject()), null);
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)keywordRootFolder);
            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)keywordRootFolder);
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)keywordRootFolder);
            MessageDialog.openInformation((Shell)shell, (String)StringConstants.INFO, (String)"Imported successfully !");
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="FOLDER/IMPORT") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
    }

    public void copyFilesToKeywordsDirectory(Shell shell, File importedFolder, String commitId, String repoUrl) throws Exception {
        FolderEntity keywordRootFolder = FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject());
        List<File> groovyFiles = this.listAllGroovyFiles(importedFolder.getAbsolutePath());
        int decisionAppliedToAll = -1;
        SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss - dd/MM/yyyy");
        GitKeywordObject keywordObject = new GitKeywordObject(repoUrl, commitId, dateFormat.format(System.currentTimeMillis()));
        keywordObject.setType(GitKeywordObject.ActionType.KEYWORD_IMPORT);
        for (File groovyFile : groovyFiles) {
            StringBuilder destinationKeywordFolder = new StringBuilder(keywordRootFolder.getLocation());
            destinationKeywordFolder.append(File.separator);
            String absolutePath = groovyFile.getAbsolutePath();
            if (StringUtils.isNotEmpty((CharSequence)repoUrl)) {
                destinationKeywordFolder.append(absolutePath.substring(absolutePath.indexOf(importedFolder.getName()) + importedFolder.getName().length() + 1, absolutePath.length()));
            } else {
                destinationKeywordFolder.append(absolutePath.substring(absolutePath.indexOf(importedFolder.getName()), absolutePath.length()));
            }
            String relativePath = PathUtil.absoluteToRelativePath((String)destinationKeywordFolder.toString(), (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
            if (new File(destinationKeywordFolder.toString()).exists()) {
                DuplicatedImportDialog duplicatedDialog = new DuplicatedImportDialog(shell, groovyFile.getName());
                int decision = decisionAppliedToAll;
                if (decisionAppliedToAll == -1) {
                    decision = duplicatedDialog.open();
                    if (duplicatedDialog.isApplyToAll()) {
                        decisionAppliedToAll = decision;
                    }
                }
                ChangeFile.FileStatus fileStatus = ChangeFile.FileStatus.SKIP_KEEP_OLD_FILE;
                if (decision == 0) {
                    fileStatus = ChangeFile.FileStatus.OVERWRITE;
                    FileUtils.copyFile((File)groovyFile, (File)new File(destinationKeywordFolder.toString()));
                }
                if (decision == 22) {
                    fileStatus = ChangeFile.FileStatus.CREATE_DUPLICATE;
                    destinationKeywordFolder.replace(destinationKeywordFolder.indexOf(groovyFile.getName()), destinationKeywordFolder.length(), this.findAvailableName(new File(destinationKeywordFolder.toString()), 0));
                    FileUtils.copyFile((File)groovyFile, (File)new File(destinationKeywordFolder.toString()));
                }
                keywordObject.addChangeFile(new ChangeFile(relativePath, FileHashUtil.hash((String)absolutePath, (String)"MD5"), fileStatus));
                if (decision == 5) {
                    fileStatus = ChangeFile.FileStatus.SKIP_KEEP_OLD_FILE;
                    continue;
                }
            } else {
                keywordObject.addChangeFile(new ChangeFile(relativePath, FileHashUtil.hash((String)absolutePath, (String)"MD5"), ChangeFile.FileStatus.NEW));
            }
            FileUtils.copyFile((File)groovyFile, (File)new File(destinationKeywordFolder.toString()));
        }
        if (StringUtils.isNotEmpty((CharSequence)repoUrl)) {
            this.writeActionToFile(keywordObject);
        }
    }

    private List<File> listAllGroovyFiles(String path) {
        ArrayList<File> absolutePathGroovyFiles = new ArrayList<File>();
        ArrayDeque<File> directories = new ArrayDeque<File>();
        directories.push(new File(path));
        while (!directories.isEmpty()) {
            File[] files;
            File dir = (File)directories.pop();
            if (!Objects.nonNull(dir)) continue;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    directories.push(file);
                }
                if (file.isFile() && file.getName().endsWith(".groovy")) {
                    absolutePathGroovyFiles.add(file);
                }
                ++n2;
            }
        }
        return absolutePathGroovyFiles;
    }

    private String findAvailableName(File file, int timesOfDuplicate) {
        if (!file.exists()) {
            return file.getName();
        }
        String testName = FilenameUtils.removeExtension((String)FilenameUtils.removeExtension((String)file.getName())) + "_" + ++timesOfDuplicate;
        StringBuilder path = new StringBuilder(file.getAbsolutePath());
        path.replace(path.indexOf(file.getName()), path.length(), testName + "." + FilenameUtils.getExtension((String)file.getName()));
        return this.findAvailableName(new File(path.toString()), timesOfDuplicate);
    }

    private void writeActionToFile(GitKeywordObject updatedObj) {
        try {
            String internalSettingPath = ProjectController.getInstance().getCurrentProject().getFolderLocation() + File.separator + ProjectController.getInstance().getInternalSettingDir();
            File file = new File(internalSettingPath, "extraLib.properties");
            String output = "";
            if (file.exists()) {
                String currentContent = new String(Files.readAllBytes(file.toPath()));
                ArrayList<GitKeywordObject> currentContentLst = new ArrayList<GitKeywordObject>(Arrays.asList((GitKeywordObject[])JsonUtil.fromJson((String)currentContent, GitKeywordObject[].class)));
                Iterator currentObjIterator = currentContentLst.iterator();
                boolean foundCurrentFile = false;
                while (currentObjIterator.hasNext()) {
                    GitKeywordObject obj = (GitKeywordObject)currentObjIterator.next();
                    if (!Objects.equals(obj.getGitUrl(), updatedObj.getGitUrl())) continue;
                    obj.setListChangeFiles(updatedObj.getChangeFiles());
                    obj.setType(updatedObj.getType());
                    obj.setCommitId(updatedObj.getCommitId());
                    obj.setTimeStamp(updatedObj.getTimestamp());
                    foundCurrentFile = true;
                }
                if (!foundCurrentFile) {
                    currentContentLst.add(updatedObj);
                }
                output = JsonUtil.toJson(currentContentLst);
            } else {
                file.createNewFile();
                GitKeywordObject[] firstGitObj = new GitKeywordObject[]{updatedObj};
                output = JsonUtil.toJson((Object)firstGitObj);
            }
            FileUtils.writeStringToFile((File)file, (String)output);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

