/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.composer.keyword.dialogs.NewRenamePackageDialog;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyRefreshUtil;
import com.kms.katalon.groovy.util.GroovyUtil;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenamePackageHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object == null || !(object instanceof PackageTreeEntity)) {
                    return;
                }
                try {
                    PackageTreeEntity packageTreeEntity = (PackageTreeEntity)object;
                    IPackageFragment packageFragment = (IPackageFragment)packageTreeEntity.getObject();
                    if (packageFragment.isDefaultPackage()) {
                        return;
                    }
                    RenamePackageHandler.this.execute((PackageTreeEntity)object);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
    }

    private void execute(PackageTreeEntity packageTreeEntity) {
        try {
            String originalName;
            IPackageFragment packageFragment = (IPackageFragment)packageTreeEntity.getObject();
            ITreeEntity parentTreeEntity = packageTreeEntity.getParent();
            IFolder parentPackageFragmentFolder = (IFolder)packageFragment.getParent().getResource();
            ArrayList<String> childrenEntityPathBeforeRenaming = new ArrayList<String>();
            Object[] objectArray = parentTreeEntity.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (!packageTreeEntity.equals(object)) {
                    String treeEntityPath = "";
                    if (object instanceof PackageTreeEntity) {
                        IPackageFragment childPackageFragment = (IPackageFragment)((PackageTreeEntity)object).getObject();
                        treeEntityPath = childPackageFragment.getResource().getFullPath().toString();
                    }
                    childrenEntityPathBeforeRenaming.add(treeEntityPath);
                }
                ++n2;
            }
            String oldPackagePath = parentPackageFragmentFolder.getName() + "/" + packageFragment.getElementName();
            IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject());
            IPackageFragmentRoot root = JavaCore.create((IProject)groovyProject).getPackageFragmentRoot((IResource)groovyProject.getFolder(StringConstants.ROOT_FOLDER_NAME_KEYWORD));
            NewRenamePackageDialog dialog = new NewRenamePackageDialog(this.parentShell, root, false, originalName = packageFragment.getElementName());
            int returnCode = dialog.open();
            if (returnCode != 0) {
                return;
            }
            String newName = dialog.getName();
            if (newName.equals(originalName)) {
                return;
            }
            String oldScript = "CustomKeywords.'" + originalName + ".";
            NullProgressMonitor monitor = new NullProgressMonitor();
            packageFragment.rename(newName, true, (IProgressMonitor)monitor);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            KeywordController.getInstance().parseAllCustomKeywords(project, null);
            parentPackageFragmentFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            String newPkName = "";
            Object[] objectArray2 = parentTreeEntity.getChildren();
            int n3 = objectArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Object object = objectArray2[n4];
                String treeEntityPathAfterRenaming = "";
                String newPackageName = "";
                if (object instanceof PackageTreeEntity) {
                    IPackageFragment childPackageFragment = (IPackageFragment)((PackageTreeEntity)object).getObject();
                    treeEntityPathAfterRenaming = childPackageFragment.getResource().getFullPath().toString();
                    newPackageName = childPackageFragment.getElementName();
                }
                if (!childrenEntityPathBeforeRenaming.contains(treeEntityPathAfterRenaming)) {
                    newPkName = newPackageName;
                    String newScript = "CustomKeywords.'" + newPackageName + ".";
                    GroovyRefreshUtil.updateScriptReferencesInTestCaseAndCustomScripts((String)oldScript, (String)newScript, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
                    this.partService.saveAll(false);
                    break;
                }
                ++n4;
            }
            this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldPackagePath, parentPackageFragmentFolder.getName() + "/" + newPkName});
            this.refreshParentAndSelect(parentTreeEntity, newPkName);
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_RENAME_PACKAGE);
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void refreshParentAndSelect(ITreeEntity parentTreeEntity, String newName) throws Exception {
        if (parentTreeEntity == null || newName == null) {
            return;
        }
        this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
        Object[] objectArray = parentTreeEntity.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object sibling = objectArray[n2];
            ITreeEntity siblingTree = (ITreeEntity)sibling;
            if (newName.equals(siblingTree.getText())) {
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)siblingTree);
                return;
            }
            ++n2;
        }
    }
}

