/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.menu;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.menu.MenuFactory;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.keyword.handlers.NewJavaClassHandler;
import com.kms.katalon.composer.keyword.handlers.NewStepDefinitionHandler;
import com.kms.katalon.constants.helper.ConstantsHelper;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;

public class NewStepDefinitionPopupMenuContribution {
    private static final String NEW_KEYWORD_POPUP_MENUITEM_LABEL = "Step Definition";
    private static final String NEW_KEYWORD_COMMAND_ID = "com.kms.katalon.composer.keyword.command.addNewStepDefinition";
    private static final String JAVA_CLASS_CONTRIBUTION_URI = "bundleclass://com.kms.katalon.composer.keyword/" + NewJavaClassHandler.class.getName();
    @Inject
    private ECommandService commandService;
    @Inject
    private ESelectionService selectionService;

    @Inject
    public void init() {
        this.selectionService.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(MPart part, Object selection) {
                if (part.getElementId().equals("com.kms.katalon.composer.part.explorer")) {
                    NewStepDefinitionPopupMenuContribution.this.selectionService.setSelection(null);
                    NewStepDefinitionPopupMenuContribution.this.selectionService.setSelection(selection);
                }
            }
        });
    }

    @CanExecute
    public boolean canExecute() {
        return true;
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (!NewStepDefinitionHandler.isUnderSourceFolder(selectedObjects)) {
                return;
            }
            ITreeEntity treeEntity = NewStepDefinitionHandler.findParentTreeEntity(selectedObjects);
            if (treeEntity != null) {
                MHandledMenuItem newKeywordPopupMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)this.commandService.createCommand(NEW_KEYWORD_COMMAND_ID, null), (String)NEW_KEYWORD_POPUP_MENUITEM_LABEL, (String)ConstantsHelper.getApplicationURI());
                if (newKeywordPopupMenuItem != null) {
                    menuItems.add((MMenuElement)newKeywordPopupMenuItem);
                }
                MDirectMenuItem newJavaClassItem = MenuFactory.createDirectMenuItem((String)"Java Class", (String)ConstantsHelper.getApplicationURI());
                newJavaClassItem.setContributionURI(JAVA_CLASS_CONTRIBUTION_URI);
                menuItems.add((MMenuElement)newJavaClassItem);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

