/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.domain.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.ICapturedObjectAttribute;
import com.katalon.recorder.core.domain.model.ICapturedObjectXPath;
import com.katalon.recorder.core.domain.model.WebViewLocator;
import com.katalon.recorder.web.constant.WebCapturedObjectType;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class WebCapturedObject
implements IWebCapturedObject {
    protected static final String TAG_ATTRIBUTE = "tag";
    protected static final String TEXT_ATTRIBUTE = "text";
    protected static final String ID_ATTRIBUTE = "id";
    protected static final String SRC_ATTRIBUTE = "src";
    protected static final String HREF_ATTRIBUTE = "href";
    protected static final String PARENT_ATTRIBUTE = "parent";
    protected static final String SHADOWROOT_ATTRIBUTE = "shadowroot";
    protected final WebCapturedObjectType type;
    protected String id;
    protected String name;
    protected String description;
    protected Integer hashValue;
    protected String elementUid;
    @JsonIgnore
    protected transient ICapturedObject parent;
    protected List<ICapturedObject> children;
    protected List<ICapturedObjectAttribute> attributes;
    protected List<ICapturedObjectXPath> xPaths;
    protected LocatorType locatorType;
    protected Map<LocatorType, String> locators;
    protected transient String entityPath;
    protected transient String windowTitle;

    public WebCapturedObject(WebCapturedObjectType type, String id) {
        this.type = type;
        this.id = id;
        this.children = new ArrayList<ICapturedObject>();
        this.attributes = new ArrayList<ICapturedObjectAttribute>();
        this.xPaths = new ArrayList<ICapturedObjectXPath>();
        this.locators = new HashMap<LocatorType, String>();
    }

    public Integer getHashValue() {
        if (this.hashValue == null) {
            ArrayList<ICapturedObjectAttribute> clonedAttributes = new ArrayList<ICapturedObjectAttribute>(this.attributes);
            clonedAttributes.sort(Comparator.comparing(ICapturedObjectAttribute::getName));
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
            for (ICapturedObjectAttribute attribute : clonedAttributes) {
                String name = attribute.getName();
                if (!name.equals(TAG_ATTRIBUTE) && !name.equals(TEXT_ATTRIBUTE) && !name.equals(ID_ATTRIBUTE) && !name.equals(SRC_ATTRIBUTE) && !name.equals(HREF_ATTRIBUTE) && !name.equals(PARENT_ATTRIBUTE) && !name.equals(SHADOWROOT_ATTRIBUTE)) continue;
                hashCodeBuilder.append((Object)attribute.getValue());
            }
            String xpathValue = this.getLocator(LocatorType.XPATH);
            if (StringUtils.isNotBlank((CharSequence)xpathValue)) {
                hashCodeBuilder.append((Object)xpathValue);
            }
            this.hashValue = hashCodeBuilder.toHashCode();
        }
        return this.hashValue;
    }

    @Override
    public WebCapturedObjectType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getElementUid() {
        return this.elementUid;
    }

    @Override
    public void setElementUid(String elementUid) {
        this.elementUid = elementUid;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getEntityPath() {
        return this.entityPath;
    }

    @Override
    public void setEntityPath(String entityPath) {
        this.entityPath = entityPath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    public ICapturedObject getParent() {
        return this.parent;
    }

    @Override
    public String getParentId() {
        if (this.parent != null) {
            return this.parent.getId();
        }
        return null;
    }

    public void setParent(ICapturedObject parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild((ICapturedObject)this);
        }
    }

    public LocatorType getLocatorType() {
        return this.locatorType;
    }

    public void setLocatorType(LocatorType locatorType) {
        this.locatorType = locatorType;
    }

    public Map<LocatorType, String> getLocators() {
        return this.locators;
    }

    public List<WebViewLocator> getWebViewLocators() {
        return this.locators.entrySet().stream().map(e -> new WebViewLocator((LocatorType)e.getKey(), (String)e.getValue())).toList();
    }

    public String getLocator(LocatorType type) {
        return this.locators.get(type);
    }

    public void addLocator(LocatorType type, String locator) {
        this.locators.put(type, locator);
    }

    public Boolean hasChild() {
        return !this.children.isEmpty();
    }

    public List<ICapturedObject> getChildren() {
        return this.children;
    }

    public void addChild(ICapturedObject child) {
        this.children.add(child);
    }

    public List<ICapturedObjectAttribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(ICapturedObjectAttribute attribute) {
        this.attributes.add(attribute);
    }

    public void setXPaths(List<ICapturedObjectXPath> xPaths) {
        this.xPaths = xPaths;
    }

    public void addXPath(ICapturedObjectXPath xPath) {
        this.xPaths.add(xPath);
    }

    public void setChildren(List<ICapturedObject> children) {
        this.children = children;
    }

    public void setLocators(Map<LocatorType, String> locators) {
        this.locators = locators;
    }

    public void setAttributes(List<ICapturedObjectAttribute> attributes) {
        this.attributes = attributes;
    }

    public List<ICapturedObjectXPath> getXPaths() {
        return this.xPaths;
    }

    @Override
    public String getWindowTitle() {
        return this.windowTitle;
    }

    @Override
    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    @Override
    public String getTag() {
        return Optional.ofNullable(this.attributes).stream().flatMap(Collection::stream).filter(attribute -> attribute.getName().equals(TAG_ATTRIBUTE)).map(ICapturedObjectAttribute::getValue).findFirst().orElse(null);
    }

    public boolean equals(Object object) {
        if (object instanceof WebCapturedObject) {
            WebCapturedObject that = (WebCapturedObject)object;
            return new EqualsBuilder().append((Object)this.getName(), (Object)that.getName()).append((Object)this.getType(), (Object)that.getType()).append((Object)this.getTag(), (Object)that.getTag()).append((Object)this.getParent(), (Object)that.getParent()).append((Object)this.hasChild(), (Object)that.hasChild()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append((Object)this.getType()).append((Object)this.getTag()).append((Object)this.getParent()).toHashCode();
    }
}

