/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.testdata.constants.ComposerTestdataMessageConstants;
import com.kms.katalon.composer.testdata.constants.StringConstants;
import com.kms.katalon.composer.testdata.dialog.EditTestDataQueryDialog;
import com.kms.katalon.composer.testdata.parts.TestDataMainPart;
import com.kms.katalon.composer.testdata.parts.WarnLargeFileUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.core.db.DatabaseConnection;
import com.kms.katalon.core.testdata.DBData;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.testdata.DataFileEntity;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DBTestDataPart
extends TestDataMainPart {
    private static final int MAX_ROW_LIMIT = 500;
    @Inject
    private EPartService partService;
    @Inject
    private UISynchronize sync;
    @Inject
    private IEclipseContext context;
    private Composite compFileInfoHeader;
    private Composite compFileInfoDetails;
    private Composite compTable;
    private TableViewer tableViewer;
    private CLabel lblArrowIndicator;
    private Label lblFileInfo;
    private Label lblStatus;
    private Text txtQuery;
    private Button btnFetchData;
    private Button btnEdit;
    private Button ckcbReadAsString;

    @Override
    protected EPartService getPartService() {
        return this.partService;
    }

    @Override
    @PostConstruct
    public void createControls(Composite parent, MPart mpart) {
        new HelpToolBarForMPart(mpart, DocumentationMessageConstants.TEST_DATA_DATABASE);
        super.createControls(parent, mpart);
        this.addControlListeners();
        this.redrawArrowIndicator();
    }

    @Override
    protected Composite createFileInfoPart(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compFileInfoHeader = new Composite(parent, 0);
        this.compFileInfoHeader.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glCompositeFileInfoHeader = new GridLayout(3, false);
        glCompositeFileInfoHeader.marginWidth = 0;
        glCompositeFileInfoHeader.marginHeight = 0;
        this.compFileInfoHeader.setLayout((Layout)glCompositeFileInfoHeader);
        this.compFileInfoHeader.setCursor(this.compFileInfoHeader.getDisplay().getSystemCursor(21));
        this.lblArrowIndicator = new CLabel(this.compFileInfoHeader, 0);
        this.lblFileInfo = new Label(this.compFileInfoHeader, 0);
        this.lblFileInfo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblFileInfo.setText(ComposerTestdataMessageConstants.PA_LBL_FILE_INFO);
        ControlUtils.setFontToBeBold((Control)this.lblFileInfo);
        this.lblStatus = new Label(this.compFileInfoHeader, 0);
        GridData gd_lblFileInfoStatus = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_lblFileInfoStatus.horizontalIndent = 5;
        this.lblStatus.setLayoutData((Object)gd_lblFileInfoStatus);
        this.compFileInfoDetails = new Composite(parent, 0);
        GridLayout glCompositeFileInfoDetails = new GridLayout(2, false);
        glCompositeFileInfoDetails.marginWidth = 0;
        glCompositeFileInfoDetails.marginHeight = 0;
        this.compFileInfoDetails.setLayout((Layout)glCompositeFileInfoDetails);
        this.compFileInfoDetails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.ckcbReadAsString = new Button(this.compFileInfoDetails, 32);
        this.ckcbReadAsString.setText(ComposerTestdataMessageConstants.VIEW_LBL_READ_AS_STRING);
        Label lblQuery = new Label(this.compFileInfoDetails, 1);
        lblQuery.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblQuery.setText(ComposerTestdataMessageConstants.DIA_LBL_SQL_QUERY);
        this.txtQuery = new Text(this.compFileInfoDetails, 2634);
        GridData gd = new GridData(4, 0x1000000, true, false, 1, 2);
        gd.heightHint = 50;
        this.txtQuery.setLayoutData((Object)gd);
        this.btnEdit = new Button(this.compFileInfoDetails, 0x800088);
        this.btnEdit.setText(ComposerTestdataMessageConstants.DIA_BTN_EDIT_QUERY);
        this.btnEdit.setImage(ImageConstants.IMG_16_EDIT);
        this.btnEdit.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.btnFetchData = new Button(this.compFileInfoDetails, 0x800088);
        this.btnFetchData.setText(ComposerTestdataMessageConstants.DIA_BTN_FETCH_DATA);
        this.btnFetchData.setImage(ImageConstants.IMG_16_REFRESH);
        this.btnFetchData.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        return parent;
    }

    @Override
    protected void initValues() {
        String strReadAsString = this.getDataFile().getProperty("readAsString");
        this.ckcbReadAsString.setSelection(strReadAsString == null || strReadAsString.isEmpty() ? true : Boolean.valueOf(strReadAsString));
    }

    @Override
    protected Composite createDataTablePart(Composite parent) {
        this.compTable = new Composite(parent, 2048);
        GridLayout glCompTable = new GridLayout();
        glCompTable.marginHeight = 0;
        glCompTable.marginWidth = 0;
        this.compTable.setLayout((Layout)glCompTable);
        this.compTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = new TableViewer(this.compTable, 0x10010000);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.getTable().setLinesVisible(ControlUtils.shouldLineVisble((Display)this.tableViewer.getTable().getDisplay()));
        TableViewerColumn tableViewerColumnNo = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tableColumnNo = tableViewerColumnNo.getColumn();
        tableColumnNo.setText(StringConstants.NO_);
        tableColumnNo.setWidth(40);
        tableViewerColumnNo.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                int order = DBTestDataPart.this.tableViewer.getTable().indexOf((TableItem)cell.getItem()) + 1;
                cell.setText(Integer.toString(order));
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        return parent;
    }

    private void redrawArrowIndicator() {
        this.lblArrowIndicator.getParent().setRedraw(false);
        this.lblArrowIndicator.setImage(this.compFileInfoDetails.isVisible() ? com.kms.katalon.composer.testdata.constants.ImageConstants.IMG_16_ARROW_DOWN : com.kms.katalon.composer.testdata.constants.ImageConstants.IMG_16_ARROW);
        this.lblArrowIndicator.getParent().setRedraw(true);
    }

    private void resizeTableOnElasticFileInfo() {
        Display.getDefault().timerExec(10, new Runnable(){

            @Override
            public void run() {
                DBTestDataPart.this.compFileInfoDetails.setVisible(!DBTestDataPart.this.compFileInfoDetails.isVisible());
                GridData fileInfoGridData = (GridData)DBTestDataPart.this.compFileInfoDetails.getLayoutData();
                fileInfoGridData.exclude = !DBTestDataPart.this.compFileInfoDetails.isVisible();
                DBTestDataPart.this.compTable.layout(true, true);
                DBTestDataPart.this.compTable.getParent().layout();
                DBTestDataPart.this.redrawArrowIndicator();
            }
        });
    }

    private void addControlListeners() {
        MouseAdapter fileInfoClickListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DBTestDataPart.this.resizeTableOnElasticFileInfo();
            }
        };
        this.lblArrowIndicator.addMouseListener((MouseListener)fileInfoClickListener);
        this.lblFileInfo.addMouseListener((MouseListener)fileInfoClickListener);
        this.compFileInfoHeader.addMouseListener((MouseListener)fileInfoClickListener);
        this.btnFetchData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBTestDataPart.this.updateChildInfo(DBTestDataPart.this.getDataFile());
            }
        });
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBTestDataPart.this.executeOperation((IUndoableOperation)new ChangeQueryOperation());
            }
        });
        this.ckcbReadAsString.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBTestDataPart.this.getDataFile().setProperty("readAsString", String.valueOf(DBTestDataPart.this.ckcbReadAsString.getSelection()));
                DBTestDataPart.this.dirtyable.setDirty(true);
            }
        });
    }

    @Override
    protected void updateChildInfo(final DataFileEntity dataFile) {
        this.btnFetchData.setEnabled(false);
        this.txtQuery.setText(dataFile.getQuery());
        this.clearTable();
        if (!this.canFetchData(dataFile)) {
            return;
        }
        Display.getCurrent().timerExec(1000, new Runnable(){

            @Override
            public void run() {
                ClassLoader oldClassLoader = null;
                DatabaseConnection dbConnection = null;
                try {
                    try {
                        oldClassLoader = Thread.currentThread().getContextClassLoader();
                        URLClassLoader projectClassLoader = ProjectController.getInstance().getProjectClassLoader(ProjectController.getInstance().getCurrentProject());
                        Thread.currentThread().setContextClassLoader(projectClassLoader);
                        dbConnection = TestDataController.getInstance().getDatabaseConnection(dataFile);
                        if (dbConnection == null) {
                            throw new Exception(ComposerTestdataMessageConstants.DIA_MSG_CONNECTION_EMPTY);
                        }
                        dbConnection.getConnection();
                        DBData dbData = new DBData(dbConnection, dataFile.getQuery());
                        DBTestDataPart.this.loadDataIntoTable(dbData);
                        DBTestDataPart.this.setStatusLabel(MessageFormat.format(ComposerTestdataMessageConstants.DIA_LBL_STATUS_LOADED_ON, dbData.getRetrievedDate().toString()), ColorUtil.getTextSuccessfulColor());
                    }
                    catch (Exception e) {
                        DBTestDataPart.this.setStatusLabel(ComposerTestdataMessageConstants.DIA_MSG_CANNOT_FETCH_DATA, ColorUtil.getTextErrorColor());
                        MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerTestdataMessageConstants.DIA_MSG_CANNOT_FETCH_DATA, (String)e.getMessage());
                        DBTestDataPart.this.btnFetchData.setEnabled(true);
                        if (dbConnection != null) {
                            dbConnection.close();
                        }
                        if (oldClassLoader != null) {
                            Thread.currentThread().setContextClassLoader(oldClassLoader);
                        }
                    }
                }
                finally {
                    DBTestDataPart.this.btnFetchData.setEnabled(true);
                    if (dbConnection != null) {
                        dbConnection.close();
                    }
                    if (oldClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                }
            }
        });
    }

    private boolean canFetchData(DataFileEntity dataFile) {
        boolean isNotBlankQuery = StringUtils.isNotBlank((String)dataFile.getQuery());
        boolean useGlobalDBSetting = dataFile.isUsingGlobalDBSetting();
        if (useGlobalDBSetting) {
            return isNotBlankQuery;
        }
        return isNotBlankQuery && StringUtils.startsWithIgnoreCase((String)dataFile.getDataSourceUrl(), (String)"jdbc");
    }

    private void loadDataIntoTable(DBData dbData) {
        this.tableViewer.getTable().setRedraw(false);
        Object[] colNames = dbData.getColumnNames();
        if (dbData.getColumnNumbers() > 100) {
            colNames = (String[])ArrayUtils.subarray((Object[])colNames, (int)0, (int)100);
        }
        List<Object[]> data = this.limitDataForPreview(dbData);
        int i = 0;
        while (i < colNames.length) {
            final int columnIndex = i;
            TableViewerColumn columnViewer = new TableViewerColumn(this.tableViewer, 0);
            columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object rowElement) {
                    if (!rowElement.getClass().isArray() || ((Object[])rowElement).length <= columnIndex) {
                        return "";
                    }
                    return ObjectUtils.toString((Object)((Object[])rowElement)[columnIndex]);
                }
            });
            TableColumn column = columnViewer.getColumn();
            column.setWidth(200);
            column.setText((String)colNames[i]);
            ++i;
        }
        this.tableViewer.setInput(data);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setRedraw(true);
    }

    private void warningIfDataOverSize(final boolean isOverSize, final String retrievedDate) {
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!isOverSize) {
                    return;
                }
                DBTestDataPart.this.setStatusLabel(MessageFormat.format(ComposerTestdataMessageConstants.DIA_LBL_STATUS_PARTIALLY_LOADED_ON, retrievedDate), ColorUtil.getWarningForegroudColor());
                WarnLargeFileUtil.showDialog();
            }
        });
    }

    private void setStatusLabel(final String text, final Color color) {
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                DBTestDataPart.this.lblStatus.setForeground(color);
                DBTestDataPart.this.lblStatus.setText(text);
                DBTestDataPart.this.compFileInfoHeader.layout();
            }
        });
    }

    private void clearTable() {
        Table table = this.tableViewer.getTable();
        while (table.getColumnCount() > 1) {
            table.getColumns()[1].dispose();
        }
        this.tableViewer.setInput(Collections.emptyList());
    }

    private List<Object[]> limitDataForPreview(DBData dbData) {
        List fetchedData = dbData.getData();
        int rowCount = fetchedData.size();
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        int columnCount = dbData.getColumnNumbers();
        boolean isTooManyRows = rowCount > 500;
        boolean isTooManyColumns = columnCount > 100;
        this.warningIfDataOverSize(isTooManyRows || isTooManyColumns, dbData.getRetrievedDate().toString());
        if (rowCount == 0) {
            return Collections.emptyList();
        }
        if (isTooManyRows) {
            fetchedData = fetchedData.subList(0, 500);
        }
        if (isTooManyColumns) {
            for (List row : fetchedData) {
                data.add(row.subList(0, 100).toArray(new Object[100]));
            }
            return data;
        }
        for (List row : fetchedData) {
            data.add(row.toArray(new Object[columnCount]));
        }
        return data;
    }

    @Persist
    public void save() {
        try {
            TestDataController.getInstance().updateTestData(this.originalDataFile, this.originalDataFile.getParentFolder());
            this.dirtyable.setDirty(false);
            this.refreshTreeEntity();
            this.sendTestDataUpdatedEvent(this.originalDataFile.getId());
        }
        catch (FilePathTooLongException e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerTestdataMessageConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_TEST_DATA, (String)e.getClass().getSimpleName());
        }
    }

    private class ChangeQueryOperation
    extends AbstractOperation {
        private DataFileEntity oldDataFile;
        private DataFileEntity newDataFile;

        public ChangeQueryOperation() {
            super(ChangeQueryOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldDataFile = DBTestDataPart.this.originalDataFile.clone();
            this.newDataFile = DBTestDataPart.this.originalDataFile.clone();
            EditTestDataQueryDialog dialog = new EditTestDataQueryDialog(Display.getCurrent().getActiveShell(), this.newDataFile);
            ContextInjectionFactory.inject((Object)((Object)dialog), (IEclipseContext)DBTestDataPart.this.context);
            if (dialog.open() != 0 || !dialog.isChanged()) {
                return Status.CANCEL_STATUS;
            }
            return this.redo(monitor, info);
        }

        private void doChangeDataFile(DataFileEntity dataFile) {
            DBTestDataPart.this.dirtyable.setDirty(true);
            DBTestDataPart.this.originalDataFile = dataFile;
            DBTestDataPart.this.updateChildInfo(DBTestDataPart.this.originalDataFile);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doChangeDataFile(this.newDataFile);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doChangeDataFile(this.oldDataFile);
            return Status.OK_STATUS;
        }
    }
}

