/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.settings;

import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.dialogs.MessageDialogWithLink;
import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.components.ConnectionPropertyTable;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.testdata.constants.ComposerTestdataMessageConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.db.DatabaseConnection;
import com.kms.katalon.core.db.DatabaseSettings;
import com.kms.katalon.core.exception.DriverNotFoundException;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DatabasePreferencePage
extends PreferencePageWithHelp {
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private static final String SETTING_NAME = DatabaseSettings.class.getName();
    private Button chkSecureUserPassword;
    private Text txtUser;
    private Text txtPassword;
    private Text txtConnectionURL;
    private Composite compDriverInfo;
    private Text txtDriverClassName;
    private Button btnTestConnection;
    private Label lblStatus;
    private boolean isLoaded;
    private DatabaseSettings dbSettings;
    private Composite compContainer;
    private GridData gdLblOptionsDB;
    private GridData gdTxtDriverClassName;
    private Label lblOptionsDB;
    private ConnectionPropertyTable connectionPropertyTable;

    protected Control createContents(Composite parent) {
        this.compContainer = new Composite(parent, 0);
        this.compContainer.setLayout((Layout)new GridLayout());
        this.compContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite compDatabase = new Composite(this.compContainer, 0);
        compDatabase.setLayout((Layout)new GridLayout(2, false));
        compDatabase.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        new Label(compDatabase, 0);
        this.chkSecureUserPassword = new Button(compDatabase, 32);
        this.chkSecureUserPassword.setText(StringConstants.DIA_CHK_SECURE_USER_PASSWORD);
        this.chkSecureUserPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblUser = new Label(compDatabase, 0);
        lblUser.setText(StringConstants.DIA_LBL_USER);
        lblUser.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtUser = new Text(compDatabase, 2048);
        this.txtUser.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label(compDatabase, 0);
        lblPassword.setText(StringConstants.DIA_LBL_PASSWORD);
        lblPassword.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtPassword = new Text(compDatabase, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblOptionsDB = new Label(compDatabase, 0);
        this.lblOptionsDB.setText("JDBC driver");
        this.gdLblOptionsDB = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.lblOptionsDB.setLayoutData((Object)this.gdLblOptionsDB);
        this.txtDriverClassName = new Text(compDatabase, 2048);
        this.gdTxtDriverClassName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtDriverClassName.setLayoutData((Object)this.gdTxtDriverClassName);
        new Label(compDatabase, 0);
        this.compDriverInfo = new Composite(compDatabase, 0);
        GridLayout glDriverInfo = new GridLayout(2, false);
        glDriverInfo.marginHeight = 0;
        glDriverInfo.horizontalSpacing = 2;
        this.compDriverInfo.setLayout((Layout)glDriverInfo);
        Label lblDriverInfo = new Label(this.compDriverInfo, 0);
        lblDriverInfo.setText(StringConstants.DIA_LBL_DRIVER_INFO);
        ControlUtils.setFontStyle((Control)lblDriverInfo, (int)2, (int)-1);
        new HelpComposite(this.compDriverInfo, StringConstants.DIA_LINK_DRIVER_INFO);
        Label lblConnectionURL = new Label(compDatabase, 0);
        lblConnectionURL.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblConnectionURL.setText(StringConstants.DIA_LBL_CONNECTION_URL);
        this.txtConnectionURL = new Text(compDatabase, 2626);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        layoutData.heightHint = 80;
        this.txtConnectionURL.setLayoutData((Object)layoutData);
        this.createConnectionPropertiesTable(this.compContainer);
        this.createTestConnectionComposite(this.connectionPropertyTable.getTableComposite());
        this.createConnectionUrlSample(this.compContainer);
        this.registerControlModifyListeners();
        this.loadSettings();
        this.isLoaded = true;
        return parent;
    }

    private void createConnectionPropertiesTable(Composite parent) {
        this.connectionPropertyTable = new ConnectionPropertyTable(this.getShell());
        this.connectionPropertyTable.createContent(parent);
        this.connectionPropertyTable.setLabelBold();
    }

    private void initialInputConnectionProperies() {
        List props = this.dbSettings.getConnectionProperties();
        this.connectionPropertyTable.setTableInput(props);
        this.connectionPropertyTable.redrawTable();
    }

    private void createTestConnectionComposite(Composite composite) {
        Composite compTestConn = new Composite(composite, 0);
        GridLayout glTestConn = new GridLayout(2, false);
        glTestConn.marginHeight = 0;
        glTestConn.marginWidth = 0;
        compTestConn.setLayout((Layout)glTestConn);
        compTestConn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTestConnection = new Button(compTestConn, 0);
        this.btnTestConnection.setText(StringConstants.DIA_BTN_TEST_CONNECTION);
        this.lblStatus = new Label(compTestConn, 0);
        this.lblStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void createConnectionUrlSample(Composite parent) {
        Composite compSample = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        compSample.setLayout((Layout)layout);
        compSample.setLayoutData((Object)new GridData(4, 128, true, false));
        Label lblSampleURL = new Label(compSample, 0);
        lblSampleURL.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblSampleURL.setText(StringConstants.DIA_LBL_CONNECTION_URL_SAMPLE);
        ControlUtils.setFontToBeBold((Control)lblSampleURL);
        Label separator = new Label(compSample, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.addLink(compSample, StringConstants.DIA_LNK_MYSQL, StringConstants.DIA_LINK_MYSQL_DOC);
        Text txtMySQLURL = new Text(compSample, 8);
        txtMySQLURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtMySQLURL.setText(StringConstants.DIA_TXT_MYSQL_SAMPLE_LINK);
        this.addLink(compSample, StringConstants.DIA_LNK_SQL_SERVER, StringConstants.DIA_LINK_DB_SETTINGS_DOC);
        Text txtSQLServerURL = new Text(compSample, 8);
        txtSQLServerURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtSQLServerURL.setText(StringConstants.DIA_TXT_SQL_SERVER_SAMPLE_LINK);
        this.addLink(compSample, StringConstants.DIA_LNK_ORACLE_SQL, StringConstants.DIA_LINK_DB_SETTINGS_DOC);
        Text txtOracleSQLURL1 = new Text(compSample, 74);
        txtOracleSQLURL1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtOracleSQLURL1.setText(StringConstants.DIA_TXT_ORACLE_SQL_SAMPLE_THIN_LINK);
        new Label(compSample, 0);
        Text txtOracleSQLURL2 = new Text(compSample, 8);
        txtOracleSQLURL2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtOracleSQLURL2.setText(StringConstants.DIA_TXT_ORACLE_SQL_SAMPLE_OCI_LINK);
        this.addLink(compSample, StringConstants.DIA_LNK_POSTGRESQL, StringConstants.DIA_LINK_DB_SETTINGS_DOC);
        Text txtPostgreSQLURL = new Text(compSample, 8);
        txtPostgreSQLURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtPostgreSQLURL.setText(StringConstants.DIA_TXT_POSTGRESQL_SAMPLE_LINK);
    }

    private Link addLink(Composite parent, String label, final String hyperlink) {
        Link link = new Link(parent, 0);
        link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        link.setText(label + " (<a href=\"" + hyperlink + "\">Docs</a>)");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)hyperlink);
            }
        });
        return link;
    }

    protected void registerControlModifyListeners() {
        this.chkSecureUserPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabasePreferencePage.this.enableUserPassword(((Button)e.getSource()).getSelection());
            }
        });
        this.btnTestConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block12: {
                    ClassLoader oldClassLoader = null;
                    DatabaseConnection dbConn = DatabasePreferencePage.this.getDatabaseConnection();
                    try {
                        oldClassLoader = Thread.currentThread().getContextClassLoader();
                        URLClassLoader projectClassLoader = ProjectController.getInstance().getProjectClassLoader(ProjectController.getInstance().getCurrentProject());
                        Thread.currentThread().setContextClassLoader(projectClassLoader);
                        if (dbConn == null) {
                            DatabasePreferencePage.this.setStatusLabel(MessageFormat.format(StringConstants.DIA_LBL_TEST_STATUS_FAIL, StringConstants.DIA_MSG_CONNECTION_EMPTY), ColorUtil.getTextErrorColor());
                            return;
                        }
                        dbConn.getConnection();
                        if (!dbConn.isAlive()) {
                            DatabasePreferencePage.this.setStatusLabel(MessageFormat.format(StringConstants.DIA_LBL_TEST_STATUS_FAIL, StringConstants.DIA_LBL_CONNECTION_CLOSED), ColorUtil.getTextErrorColor());
                            return;
                        }
                        try {
                            DatabasePreferencePage.this.setStatusLabel(StringConstants.DIA_LBL_TEST_STATUS_SUCCESS, ColorUtil.getTextSuccessfulColor());
                        }
                        catch (DriverNotFoundException | MalformedURLException | SQLException | CoreException ex) {
                            if (StringUtils.contains((String)ex.getMessage(), (String)"jdbc:mysql")) {
                                DatabasePreferencePage.this.setStatusLabel(MessageFormat.format(StringConstants.DIA_LBL_MYSQL_WARNING, VersionUtil.getCurrentVersion().getVersion(), StringConstants.DIA_LBL_MYSQL_WARNING_HYPERLINK), ColorUtil.getTextErrorColor());
                                break block12;
                            }
                            DatabasePreferencePage.this.setStatusLabel(MessageFormat.format(StringConstants.DIA_LBL_TEST_STATUS_FAIL, ex.getMessage()), ColorUtil.getTextErrorColor());
                        }
                    }
                    finally {
                        if (dbConn != null) {
                            dbConn.close();
                        }
                        if (oldClassLoader != null) {
                            Thread.currentThread().setContextClassLoader(oldClassLoader);
                        }
                    }
                }
            }
        });
        this.lblStatus.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (DatabasePreferencePage.this.lblStatus.getText().isEmpty()) {
                    return;
                }
                MessageDialogWithLink.openInformation((Shell)DatabasePreferencePage.this.getShell(), (String)StringConstants.DIA_TITLE_STATUS_DETAILS, (String)DatabasePreferencePage.this.lblStatus.getToolTipText());
            }
        });
    }

    private DatabaseConnection getDatabaseConnection() {
        String user = null;
        String password = null;
        String driverClassName = this.txtDriverClassName.getText();
        if (this.chkSecureUserPassword.getSelection()) {
            user = this.txtUser.getText();
            password = this.txtPassword.getText();
        }
        if (!StringUtils.startsWithIgnoreCase((String)this.txtConnectionURL.getText(), (String)"jdbc")) {
            return null;
        }
        DatabaseConnection connection = new DatabaseConnection(this.txtConnectionURL.getText(), user, password, driverClassName);
        connection.setConnectionProperties(this.connectionPropertyTable.getConnectionProperties());
        return connection;
    }

    private void setStatusLabel(String msg, Color msgColor) {
        this.lblStatus.setCursor(Display.getCurrent().getSystemCursor(21));
        this.lblStatus.setForeground(msgColor);
        this.lblStatus.setText(StringUtils.abbreviate((String)msg, (int)80));
        this.lblStatus.setToolTipText(msg);
    }

    private void loadSettings() {
        try {
            this.dbSettings = new DatabaseSettings(this.getCurrentProjectDir());
            this.chkSecureUserPassword.setSelection(this.dbSettings.isSecureUserAccount());
            this.txtUser.setText(StringUtils.defaultString((String)this.dbSettings.getUser()));
            this.txtPassword.setText(StringUtils.defaultString((String)this.dbSettings.getPassword()));
            this.txtConnectionURL.setText(StringUtils.defaultString((String)this.dbSettings.getUrl()));
            this.txtDriverClassName.setText(StringUtils.defaultString((String)this.dbSettings.getDriverClassName()));
            this.enableUserPassword(this.chkSecureUserPassword.getSelection());
            this.initialInputConnectionProperies();
        }
        catch (IOException e) {
            this.setStatusLabel(e.getMessage(), ColorUtil.getTextErrorColor());
        }
    }

    private void enableUserPassword(boolean enabled) {
        this.txtUser.setEnabled(enabled);
        this.txtPassword.setEnabled(enabled);
    }

    protected void performDefaults() {
        this.chkSecureUserPassword.setSelection(false);
        this.txtUser.setText("");
        this.txtPassword.setText("");
        this.txtConnectionURL.setText("");
    }

    public boolean performOk() {
        if (!this.isLoaded) {
            return true;
        }
        this.dbSettings.setSecureUserAccount(this.chkSecureUserPassword.getSelection());
        this.dbSettings.setUser(this.txtUser.getText());
        this.dbSettings.setPassword(this.txtPassword.getText());
        String connectionUrl = this.txtConnectionURL.getText();
        this.dbSettings.setUrl(connectionUrl);
        this.dbSettings.setDriverClassName(this.txtDriverClassName.getText());
        this.dbSettings.setShowWarning(false);
        this.dbSettings.setConnectionProperties(this.connectionPropertyTable.getListConnectionPropeties());
        if (this.isOracleSql(connectionUrl) && !this.featureController.canUse(ProductFeature.ORACLE_EXTERNAL_DATA)) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.ORACLE_EXTERNAL_DATA);
            return false;
        }
        if (this.isMicrosoftSqlServer(connectionUrl) && !this.featureController.canUse(ProductFeature.SQL_SERVER_EXTERNAL_DATA)) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.SQL_SERVER_EXTERNAL_DATA);
            return false;
        }
        if (StringUtils.isNotBlank((String)this.txtDriverClassName.getText()) && !this.featureController.canUse(ProductFeature.ADDTIONAL_TEST_DATA_SOURCE)) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.ADDTIONAL_TEST_DATA_SOURCE);
            return false;
        }
        try {
            PropertySettingStoreUtil.saveExternalSettings((String)this.getCurrentProjectDir(), (String)SETTING_NAME, (Properties)this.dbSettings.getSettings(), (String)ComposerTestdataMessageConstants.DIA_DB_SETTING_COMMENT);
            return true;
        }
        catch (IOException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR, (String)ComposerTestdataMessageConstants.DIA_MSG_UNABLE_TO_SAVE_DB_SETTING_PAGE);
            return false;
        }
    }

    private String getCurrentProjectDir() {
        return ProjectController.getInstance().getCurrentProject().getFolderLocation();
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_DATABASE;
    }

    private boolean isOracleSql(String connectionUrl) {
        if (StringUtils.isEmpty((String)connectionUrl)) {
            return false;
        }
        return connectionUrl.startsWith("jdbc:oracle");
    }

    private boolean isMicrosoftSqlServer(String connectionUrl) {
        if (StringUtils.isEmpty((String)connectionUrl)) {
            return false;
        }
        return connectionUrl.startsWith("jdbc:sqlserver");
    }
}

