/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.jdt.groovy.integration.LanguageSupportFactory;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.core.util.Util;

public class ScriptFolderCompilationParticipant
extends CompilationParticipant {
    public boolean isActive(IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        return GroovyNature.hasGroovyNature(project) && ScriptFolderSelector.isEnabled(project) && LanguageSupportFactory.isGroovyLanguageSupportInstalled();
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        if (files == null || files.length < 1) {
            return;
        }
        IProject project = files[0].getFile().getProject();
        try {
            Map<IContainer, IContainer> sourceToOutput = null;
            ScriptFolderSelector selector = new ScriptFolderSelector(project);
            BuildContext[] buildContextArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                BuildContext file = buildContextArray[n2];
                if (selector.getFileKind((IResource)file.getFile()) == ScriptFolderSelector.FileKind.SCRIPT) {
                    IContainer sourceFolder;
                    IPath path = file.getFile().getFullPath();
                    if (sourceToOutput == null) {
                        sourceToOutput = ScriptFolderCompilationParticipant.createSourceToOutput(project);
                    }
                    if ((sourceFolder = ScriptFolderCompilationParticipant.findContainingSourceFolder(sourceToOutput, path)) != null) {
                        IPath packagePath = ScriptFolderCompilationParticipant.findPackagePath(path, sourceFolder);
                        IContainer outputFolder = sourceToOutput.get(sourceFolder);
                        ScriptFolderCompilationParticipant.copyFile(file.getFile(), packagePath, outputFolder);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Util.log((Throwable)e, (String)"Error when copying scripts to output folder");
        }
    }

    private static Map<IContainer, IContainer> createSourceToOutput(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IWorkspaceRoot root = (IWorkspaceRoot)project.getParent();
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        IPath defaultOutputLocation = javaProject.getOutputLocation();
        IProject defaultOutputFolder = defaultOutputLocation.segmentCount() > 1 ? root.getFolder(defaultOutputLocation) : project;
        TreeMap<IContainer, IContainer> sourceToOutput = new TreeMap<IContainer, IContainer>(Comparator.comparingInt(c -> c.getFullPath().segmentCount()).reversed().thenComparing(c -> c.toString()));
        IClasspathEntry[] iClasspathEntryArray = classpath;
        int n = classpath.length;
        int n2 = 0;
        while (n2 < n) {
            IPath outputPath;
            Object outputFolder;
            IPath sourcePath;
            Object sourceFolder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && !(sourceFolder = (sourcePath = entry.getPath()).segmentCount() > 1 ? root.getFolder(sourcePath) : project).equals(outputFolder = (outputPath = entry.getOutputLocation()) == null ? defaultOutputFolder : (outputPath.segmentCount() > 1 ? root.getFolder(outputPath) : project))) {
                sourceToOutput.put((IContainer)sourceFolder, (IContainer)outputFolder);
            }
            ++n2;
        }
        return sourceToOutput;
    }

    private static IContainer findContainingSourceFolder(Map<IContainer, IContainer> sourceToOutput, IPath filePath) {
        Set<IContainer> sourceFolders = sourceToOutput.keySet();
        for (IContainer sourceFolder : sourceFolders) {
            if (!sourceFolder.getFullPath().isPrefixOf(filePath)) continue;
            return sourceFolder;
        }
        return null;
    }

    private static IPath findPackagePath(IPath filePath, IContainer sourceFolder) {
        filePath = filePath.removeFirstSegments(sourceFolder.getFullPath().segmentCount());
        filePath = filePath.removeLastSegments(1);
        return filePath;
    }

    private static void copyFile(IFile file, IPath packagePath, IContainer outputFolder) throws CoreException {
        IContainer createdFolder = ScriptFolderCompilationParticipant.createFolder(packagePath, outputFolder, true);
        IFile toFile = createdFolder.getFile((IPath)new Path(file.getName()));
        if (toFile.exists()) {
            toFile.delete(true, null);
        }
        file.copy(toFile.getFullPath(), true, null);
        ResourceAttributes newAttrs = new ResourceAttributes();
        newAttrs.setReadOnly(false);
        newAttrs.setHidden(false);
        toFile.setResourceAttributes(newAttrs);
        toFile.setDerived(true, null);
        toFile.refreshLocal(0, null);
    }

    private static IContainer createFolder(IPath packagePath, IContainer outputFolder, boolean derived) throws CoreException {
        if (!outputFolder.exists() && outputFolder instanceof IFolder) {
            ((IFolder)outputFolder).create(true, true, null);
        }
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        folder.refreshLocal(0, null);
        if (!folder.exists()) {
            ScriptFolderCompilationParticipant.createFolder(packagePath.removeLastSegments(1), outputFolder, derived);
            folder.create(true, true, null);
            folder.setDerived(derived, null);
            folder.refreshLocal(0, null);
        }
        return folder;
    }
}

