/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.core.util.TimeUtil;
import java.util.Timer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class AnimationUtil {
    public static final int MAX_ALPHA = 255;
    public static final int MIN_ALPHA = 0;
    public static final int DEFAULT_FADE_IN_ALPHA = 255;
    public static final int DEFAULT_FADE_OUT_ALPHA = 0;
    public static final long DEFAULT_ANIMATION_DURATION = 500L;
    public static final long DEFAULT_ANIMATION_DELAY = 0L;
    private static final String ANIMATION_START_TIME_KEY = "FADE_IN_START_TIME";

    private AnimationUtil() {
    }

    public static void fadeOut(Shell shell) {
        AnimationUtil.fadeOut(shell, 500L);
    }

    public static void fadeOut(Shell shell, long duration) {
        AnimationUtil.fadeOut(shell, duration, shell.getAlpha());
    }

    public static void fadeOut(Shell shell, long duration, int fromAlpha) {
        AnimationUtil.fade(shell, duration, fromAlpha, 0);
    }

    public static void fadeIn(Shell shell) {
        AnimationUtil.fadeIn(shell, 255);
    }

    public static void fadeIn(Shell shell, long duration) {
        AnimationUtil.fadeIn(shell, duration, 255);
    }

    public static void fadeIn(Shell shell, int toAlpha) {
        AnimationUtil.fadeIn(shell, 500L, toAlpha);
    }

    public static void fadeIn(Shell shell, long duration, int toAlpha) {
        AnimationUtil.fade(shell, duration, 0, toAlpha);
    }

    public static void fade(Shell shell, int fromAlpha, int toAlpha) {
        AnimationUtil.fade(shell, 500L, fromAlpha, toAlpha, null);
    }

    public static void fade(Shell shell, long duration, int fromAlpha, int toAlpha) {
        AnimationUtil.fade(shell, duration, fromAlpha, toAlpha, null);
    }

    public static void fade(Shell shell, long duration, int fromAlpha, int toAlpha, Runnable onAnimationEnd) {
        AnimationUtil.fade(shell, duration, 0L, fromAlpha, toAlpha, onAnimationEnd);
    }

    public static void fade(Shell shell, long duration, long delay, int fromAlpha, int toAlpha, Runnable onAnimationEnd) {
        if (ControlUtil.isDisposed((Widget)shell)) {
            return;
        }
        shell.setAlpha(fromAlpha);
        ComponentDataUtil.set((Widget)shell, ANIMATION_START_TIME_KEY, 0L);
        if (ComponentDataUtil.getAnimationHandler((Widget)shell) != null) {
            TimeUtil.cancel((Timer)ComponentDataUtil.getAnimationHandler((Widget)shell));
        }
        Timer animationHandler = UITimeUtil.setIntervalSync(timer -> {
            boolean isFadeIn;
            if (shell.isDisposed()) {
                TimeUtil.cancel((Timer)ComponentDataUtil.getAnimationHandler((Widget)shell));
                ComponentDataUtil.setAnimationHandler((Widget)shell, null);
                return;
            }
            long start = ComponentDataUtil.getLong((Widget)shell, ANIMATION_START_TIME_KEY);
            if (start == 0L) {
                start = System.currentTimeMillis();
                ComponentDataUtil.set((Widget)shell, ANIMATION_START_TIME_KEY, start);
            }
            int alpha = AnimationUtil.calcAlpha(start, duration, fromAlpha, toAlpha);
            shell.setAlpha(alpha);
            boolean bl = isFadeIn = toAlpha > fromAlpha;
            if (isFadeIn ? alpha >= toAlpha : alpha <= toAlpha) {
                timer.cancel();
                ComponentDataUtil.setAnimationHandler((Widget)shell, null);
            }
        }, 15L);
        ComponentDataUtil.setAnimationHandler((Widget)shell, animationHandler);
    }

    private static int calcAlpha(long start, long duration, int fromAlpha, int toAlpha) {
        if (duration == 0L) {
            return toAlpha;
        }
        int range = Math.abs(toAlpha - fromAlpha) + 1;
        boolean isFadeIn = toAlpha > fromAlpha;
        double percent = (double)(System.currentTimeMillis() - start) / (double)duration;
        int offset = (int)Math.round(percent * (double)range);
        int curAlpha = isFadeIn ? fromAlpha + offset : fromAlpha - offset;
        int bigger = Math.max(fromAlpha, toAlpha);
        int smaller = Math.min(fromAlpha, toAlpha);
        return Math.min(Math.max(curAlpha, smaller), bigger);
    }
}

