/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AzureSearchIndexFieldMappingOptions
implements JsonSerializable<AzureSearchIndexFieldMappingOptions> {
    private String titleField;
    private String urlField;
    private String filepathField;
    private List<String> contentFields;
    private String contentFieldsSeparator;
    private List<String> vectorFields;
    private List<String> imageVectorFields;

    public String getTitleField() {
        return this.titleField;
    }

    public AzureSearchIndexFieldMappingOptions setTitleField(String titleField) {
        this.titleField = titleField;
        return this;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public AzureSearchIndexFieldMappingOptions setUrlField(String urlField) {
        this.urlField = urlField;
        return this;
    }

    public String getFilepathField() {
        return this.filepathField;
    }

    public AzureSearchIndexFieldMappingOptions setFilepathField(String filepathField) {
        this.filepathField = filepathField;
        return this;
    }

    public List<String> getContentFields() {
        return this.contentFields;
    }

    public AzureSearchIndexFieldMappingOptions setContentFields(List<String> contentFields) {
        this.contentFields = contentFields;
        return this;
    }

    public String getContentFieldsSeparator() {
        return this.contentFieldsSeparator;
    }

    public AzureSearchIndexFieldMappingOptions setContentFieldsSeparator(String contentFieldsSeparator) {
        this.contentFieldsSeparator = contentFieldsSeparator;
        return this;
    }

    public List<String> getVectorFields() {
        return this.vectorFields;
    }

    public AzureSearchIndexFieldMappingOptions setVectorFields(List<String> vectorFields) {
        this.vectorFields = vectorFields;
        return this;
    }

    public List<String> getImageVectorFields() {
        return this.imageVectorFields;
    }

    public AzureSearchIndexFieldMappingOptions setImageVectorFields(List<String> imageVectorFields) {
        this.imageVectorFields = imageVectorFields;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title_field", this.titleField);
        jsonWriter.writeStringField("url_field", this.urlField);
        jsonWriter.writeStringField("filepath_field", this.filepathField);
        jsonWriter.writeArrayField("content_fields", this.contentFields, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("content_fields_separator", this.contentFieldsSeparator);
        jsonWriter.writeArrayField("vector_fields", this.vectorFields, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("image_vector_fields", this.imageVectorFields, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AzureSearchIndexFieldMappingOptions fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSearchIndexFieldMappingOptions)jsonReader.readObject(reader -> {
            AzureSearchIndexFieldMappingOptions deserializedAzureSearchIndexFieldMappingOptions = new AzureSearchIndexFieldMappingOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("title_field".equals(fieldName)) {
                    deserializedAzureSearchIndexFieldMappingOptions.titleField = reader.getString();
                    continue;
                }
                if ("url_field".equals(fieldName)) {
                    deserializedAzureSearchIndexFieldMappingOptions.urlField = reader.getString();
                    continue;
                }
                if ("filepath_field".equals(fieldName)) {
                    deserializedAzureSearchIndexFieldMappingOptions.filepathField = reader.getString();
                    continue;
                }
                if ("content_fields".equals(fieldName)) {
                    List contentFields;
                    deserializedAzureSearchIndexFieldMappingOptions.contentFields = contentFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("content_fields_separator".equals(fieldName)) {
                    deserializedAzureSearchIndexFieldMappingOptions.contentFieldsSeparator = reader.getString();
                    continue;
                }
                if ("vector_fields".equals(fieldName)) {
                    List vectorFields;
                    deserializedAzureSearchIndexFieldMappingOptions.vectorFields = vectorFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("image_vector_fields".equals(fieldName)) {
                    List imageVectorFields;
                    deserializedAzureSearchIndexFieldMappingOptions.imageVectorFields = imageVectorFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureSearchIndexFieldMappingOptions;
        });
    }
}

