/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.cucumber.handler;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.IDeleteEntityHandler;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DeleteFeatureEntityHandler
implements IDeleteEntityHandler {
    public Class<? extends ITreeEntity> entityType() {
        return SystemFileTreeEntity.class;
    }

    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        if (!(treeEntity instanceof SystemFileTreeEntity)) {
            return false;
        }
        SystemFileEntity featureEntity = null;
        try {
            featureEntity = (SystemFileEntity)treeEntity.getObject();
        }
        catch (Exception exception) {}
        monitor.subTask(MessageFormat.format("Deleting Feature file: ", featureEntity.getIdForDisplay()));
        try {
            IFile iFile = GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject()).getFile(Path.fromOSString((String)featureEntity.getRelativePath()));
            iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            iFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            SystemFileController.getInstance().deleteFile(featureEntity);
            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)treeEntity.getParent());
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.done();
        }
    }
}

