/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.helper.screenrecorder;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.DurationFormatUtils;

public class VideoSubtitleWriter {
    private static final String SUB_TITLE_EXT = ".srt";
    private static final String SUB_DATE_TIME_FORMAT = "HH:mm:ss,SSS";
    private int counter = 0;
    private File subFile;

    public VideoSubtitleWriter(String fileName) {
        this.subFile = new File(fileName + SUB_TITLE_EXT);
    }

    public void writeSub(long start, long end, String sub) throws IOException {
        ++this.counter;
        StringBuilder subtitleBuilder = new StringBuilder();
        subtitleBuilder.append(this.counter).append("\n").append(String.format("%s --> %s", this.getTimeFormat(start), this.getTimeFormat(end))).append("\n").append(sub).append("\n\n");
        FileUtils.write((File)this.subFile, (CharSequence)subtitleBuilder.toString(), (boolean)true);
    }

    private String getTimeFormat(long time) {
        return DurationFormatUtils.formatDuration((long)time, (String)SUB_DATE_TIME_FORMAT);
    }

    public void delete() {
        if (this.subFile != null && this.subFile.exists()) {
            FileUtils.deleteQuietly((File)this.subFile);
        }
    }
}

