/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.network;

import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.network.core.model.config.ManualProxyConfig;
import com.kms.katalon.network.core.model.config.NoProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyAuthentication;
import com.kms.katalon.network.core.model.config.ProxyBasicAuthentication;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyProtocol;
import com.kms.katalon.network.core.model.config.SystemProxyConfig;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class ProxyInformation {
    private String proxyOption;
    private String proxyServerType;
    private String username;
    private String password;
    private String proxyServerAddress;
    private int proxyServerPort;
    private String exceptionList;
    private boolean applyToDesiredCapabilities;

    public String getExceptionList() {
        return this.exceptionList;
    }

    public void setExceptionList(String exceptionList) {
        this.exceptionList = StringUtils.isNotEmpty((String)exceptionList) ? exceptionList : "";
    }

    public String getProxyOption() {
        return this.proxyOption;
    }

    public void setProxyOption(String proxyOption) {
        if (StringUtils.isEmpty((String)proxyOption)) {
            proxyOption = ProxyOption.NO_PROXY.name();
        }
        this.proxyOption = proxyOption;
    }

    public String getProxyServerType() {
        return this.proxyServerType;
    }

    public void setProxyServerType(String proxyServerType) {
        this.proxyServerType = StringUtils.isNotEmpty((String)proxyServerType) ? proxyServerType : "";
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = StringUtils.isNotEmpty((String)username) ? username : "";
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StringUtils.isNotEmpty((String)password) ? password : "";
    }

    public String getProxyServerAddress() {
        return this.proxyServerAddress;
    }

    public void setProxyServerAddress(String proxyServerAddress) {
        this.proxyServerAddress = StringUtils.isNotEmpty((String)proxyServerAddress) ? proxyServerAddress : "";
    }

    public int getProxyServerPort() {
        return this.proxyServerPort;
    }

    public void setProxyServerPort(int proxyServerPort) {
        this.proxyServerPort = proxyServerPort;
    }

    public void setProxyServerPort(String proxyServerPort) {
        try {
            this.proxyServerPort = Integer.parseInt(StringUtils.isNotEmpty((String)proxyServerPort) ? proxyServerPort : "-1");
        }
        catch (NumberFormatException numberFormatException) {
            this.proxyServerPort = -1;
        }
    }

    public boolean isApplyToDesiredCapabilities() {
        return this.applyToDesiredCapabilities;
    }

    public void setApplyToDesiredCapabilities(boolean applyToDesiredCapabilities) {
        this.applyToDesiredCapabilities = applyToDesiredCapabilities;
    }

    public String toString() {
        return "ProxyInformation { proxyOption=" + this.proxyOption + ", proxyServerType=" + this.proxyServerType + ", username=" + this.username + ", password=********, proxyServerAddress=" + this.proxyServerAddress + ", proxyServerPort=" + this.proxyServerPort + ", executionList=\"" + this.exceptionList + "\", isApplyToDesiredCapabilities=" + this.applyToDesiredCapabilities + " }";
    }

    public ProxyConfig toNewProxyConfigModel() {
        if (ProxyOption.valueOf(this.proxyOption).equals((Object)ProxyOption.NO_PROXY)) {
            return new NoProxyConfig();
        }
        if (ProxyOption.valueOf(this.proxyOption).equals((Object)ProxyOption.USE_SYSTEM)) {
            return new SystemProxyConfig();
        }
        ManualProxyConfig.Builder manualProxyConfigBuilder = new ManualProxyConfig.Builder();
        ProxyProtocol proxyProtocol = ProxyProtocol.valueOf((String)this.proxyServerType);
        if (proxyProtocol != null) {
            manualProxyConfigBuilder.protocol(proxyProtocol);
        }
        if (StringUtils.isNotBlank((String)this.proxyServerAddress)) {
            manualProxyConfigBuilder.address(this.proxyServerAddress);
        }
        if (this.proxyServerPort > 0) {
            manualProxyConfigBuilder.port(this.proxyServerPort);
        }
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            manualProxyConfigBuilder.authentication((ProxyAuthentication)new ProxyBasicAuthentication(this.username, this.password));
        }
        if (StringUtils.isNotBlank((String)this.exceptionList)) {
            manualProxyConfigBuilder.bypassedHosts(Arrays.stream(this.exceptionList.split("[,;\n]")).map(String::trim).toList());
        }
        return manualProxyConfigBuilder.build();
    }
}

