/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.google.common.io.BaseEncoding;
import com.kms.katalon.core.configuration.RunConfiguration;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class FileUtil {
    private static final String ANY_EXTENSION = "*";

    public static String getFilePathNoExtension(File file) {
        if (file == null) {
            return "";
        }
        String filePath = file.getAbsolutePath();
        int dotIndex = filePath.lastIndexOf(46);
        if (dotIndex > 0) {
            filePath = filePath.substring(0, dotIndex);
        }
        return filePath;
    }

    public static File[] getFiles(File folder, String suffix, Date origin) throws IOException {
        final ArrayList filePaths = new ArrayList();
        FileUtil.enumFiles(folder, suffix, origin, new FileProcessor(){

            @Override
            public void process(File f) {
                filePaths.add(f);
            }
        });
        return filePaths.toArray(new File[0]);
    }

    public static void enumFiles(File folder, String suffix, Date origin, FileProcessor fileProcessor) throws IOException {
        if (!folder.isDirectory()) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(Arrays.asList(folder.listFiles()));
        int i = 0;
        while (i < files.size()) {
            File file = (File)files.get(i);
            if (file.isDirectory()) {
                files.addAll(Arrays.asList(file.listFiles()));
            } else if (FileUtil.isFileSatisfy(file, suffix, origin)) {
                fileProcessor.process(file);
            }
            ++i;
        }
    }

    private static boolean isFileSatisfy(File file, String suffix, Date origin) throws IOException {
        boolean satisfyName;
        String fileName = file.getName();
        boolean bl = satisfyName = suffix.equals(ANY_EXTENSION) ? true : fileName.endsWith(suffix);
        if (!satisfyName) {
            return false;
        }
        return FileUtil.isFileCreateAfter(file, origin);
    }

    public static boolean isFileCreateAfter(File file, Date time) throws IOException {
        if (time == null) {
            return true;
        }
        return time.getTime() < Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
    }

    public static int countAllFiles(File folder, String suffix, Date origin) throws IOException {
        final int[] count = new int[1];
        FileUtil.enumFiles(folder, suffix, origin, new FileProcessor(){

            @Override
            public void process(File f) {
                count[0] = count[0] + 1;
            }
        });
        return count[0];
    }

    public static boolean isValidPath(String path) {
        return path != null && new File(path).exists();
    }

    public static boolean fileExists(String root, String pattern) {
        return FileUtil.findFileByName(root, pattern) != null;
    }

    public static File findFileByName(String root, String pattern) {
        return FileUtil.findFile(root, file -> file.getName().matches(pattern));
    }

    public static File findFile(String root, FileFilter filter) {
        return FileUtil.find(root, filter, FileType.FILE);
    }

    public static List<File> findAllFiles(String root, FileFilter filter) {
        return FileUtil.findAll(root, filter, FileType.FILE);
    }

    public static File findFolderByName(String root, String pattern) {
        return FileUtil.findFolder(root, file -> file.getName().matches(pattern));
    }

    public static File findFolder(String root, FileFilter filter) {
        return FileUtil.find(root, filter, FileType.FOLDER);
    }

    public static List<File> findAllFolders(String root, FileFilter filter) {
        return FileUtil.findAll(root, filter, FileType.FOLDER);
    }

    public static File find(String root, FileFilter filter) {
        return FileUtil.find(root, filter, FileType.ANY);
    }

    public static File find(String root, FileFilter filter, FileType type) {
        List<File> matches = FileUtil.findAll(root, filter, type);
        return matches.isEmpty() ? null : matches.get(0);
    }

    public static List<File> findAll(String root, FileFilter filter) {
        return FileUtil.findAll(root, filter, FileType.ANY);
    }

    public static List<File> findAll(String root, final FileFilter filter, final FileType type) {
        if (StringUtils.isBlank((String)root) || !new File(root).exists()) {
            return Collections.emptyList();
        }
        File rootFile = new File(root);
        String[] directories = rootFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File parentFolder, String name) {
                boolean typeCheck;
                File file = new File(parentFolder, name);
                boolean bl = typeCheck = type == FileType.ANY || type == FileType.FILE && !file.isDirectory() || type == FileType.FOLDER && file.isDirectory();
                return filter.test(file) && typeCheck;
            }
        });
        return Arrays.asList(directories).stream().map(subDirectory -> new File(root, (String)subDirectory)).collect(Collectors.toList());
    }

    public static File getFile(String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        if (StringUtils.isNotBlank((String)RunConfiguration.getProjectDir())) {
            return new File(RunConfiguration.getProjectDir(), path);
        }
        return null;
    }

    public static Set<File> listFiles(String dir) throws IOException {
        if (StringUtils.isEmpty((String)dir)) {
            return Collections.emptySet();
        }
        if (!new File(dir).exists()) {
            return Collections.emptySet();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> stream = Files.list(Paths.get(dir, new String[0]));){
            return stream.map(Path::toFile).collect(Collectors.toSet());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String readFileToImageDataURL(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        return "data:image/png;base64," + FileUtil.readFileAsBase64(file);
    }

    public static String readFileAsBase64(File file) throws IOException {
        return BaseEncoding.base64().encode(Files.readAllBytes(file.toPath()));
    }

    public static void saveBase64ToFile(String base64Data, File outputFile) throws IOException {
        if (base64Data == null || base64Data.isEmpty()) {
            throw new IllegalArgumentException("Base64 data cannot be null or empty");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("Output file cannot be null");
        }
        String base64String = base64Data;
        if (base64Data.contains(",")) {
            base64String = base64Data.substring(base64Data.indexOf(",") + 1);
        }
        byte[] decodedBytes = BaseEncoding.base64().decode((CharSequence)base64String);
        Files.write(outputFile.toPath(), decodedBytes, new OpenOption[0]);
    }

    public static interface FileFilter {
        public boolean test(File var1);
    }

    public static interface FileProcessor {
        public void process(File var1);
    }

    public static enum FileType {
        FILE,
        FOLDER,
        ANY;

    }
}

