/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.FileUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.api.robot.desktop.DesktopKeyboard;
import org.sikuli.api.robot.desktop.DesktopMouse;

public class ScreenUtil {
    private ScreenRegion mainScreen = new DesktopScreenRegion();
    private double similarity = 0.75;

    public ScreenUtil() {
    }

    public ScreenUtil(double similarity) {
        this();
        this.similarity = similarity;
    }

    public void clickImage(String imagePath) throws Exception {
        ScreenRegion reg = this.findImage(imagePath);
        if (reg == null) {
            throw new Exception(StringConstants.COMM_EXC_CANNOT_RECOGNIZE_IMG_ON_SCREEN);
        }
        DesktopMouse mouse = new DesktopMouse();
        mouse.click(reg.getCenter());
    }

    public boolean isImageExist(String imagePath) throws Exception {
        ScreenRegion reg = this.findImage(imagePath);
        return reg != null;
    }

    public void type(String string) {
        DesktopKeyboard keyboard = new DesktopKeyboard();
        keyboard.type(string);
    }

    public void typeOnImage(String imagePath, String text) throws Exception {
        this.clickImage(imagePath);
        this.type(text);
    }

    public boolean waitForImagePresent(String imagePath, int seconds) throws Exception {
        File imgFile = new File(imagePath);
        if (imgFile.exists()) {
            ImageTarget imageTarget = new ImageTarget(imgFile);
            imageTarget.setMinScore(this.similarity);
            ScreenRegion reg = this.mainScreen.wait((Target)imageTarget, seconds * 1000);
            return reg != null;
        }
        throw new Exception(StringConstants.COMM_EXC_IMG_FILE_DOES_NOT_EXIST);
    }

    public double getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(double similarity) {
        this.similarity = similarity;
    }

    public void authenticate(String userName, String password) throws Exception {
        String usrImg = "";
        String passImg = "";
        String okImg = "";
        WebUIDriverType driver = (WebUIDriverType)DriverFactory.getExecutedBrowser();
        if (driver == null) {
            throw new StepFailedException(StringConstants.DRI_ERROR_MSG_NO_BROWSER_SET);
        }
        switch (driver) {
            case FIREFOX_DRIVER: {
                usrImg = "auth_dlg_usr_win7_ff.png";
                passImg = "auth_dlg_pass_win7_ff.png";
                okImg = "auth_dlg_ok_win7_ff.png";
                break;
            }
            case CHROME_DRIVER: {
                usrImg = "auth_dlg_usr_win7_chrome.png";
                passImg = "auth_dlg_pass_win7_chrome.png";
                okImg = "auth_dlg_ok_win7_chrome.png";
                break;
            }
            default: {
                throw new Exception(StringConstants.COMM_EXC_BROWSER_IS_NOT_SUPPORTED);
            }
        }
        File screenFolder = FileUtil.extractScreenFiles();
        this.typeOnImage(String.valueOf(screenFolder) + File.separator + usrImg, userName);
        this.typeOnImage(String.valueOf(screenFolder) + File.separator + passImg, password);
        this.clickImage(String.valueOf(screenFolder) + File.separator + okImg);
    }

    private ScreenRegion findImage(String imagePath) throws Exception {
        File imgFile = new File(imagePath);
        if (imgFile.exists()) {
            ImageTarget target = new ImageTarget(imgFile);
            target.setMinScore(this.similarity);
            ScreenRegion reg = this.mainScreen.find((Target)target);
            return reg;
        }
        throw new Exception(StringConstants.COMM_EXC_IMG_FILE_DOES_NOT_EXIST);
    }

    public BufferedImage getScreenRegionImage() {
        return this.mainScreen.capture();
    }

    public List<ScreenRegion> findImages(String imagePath) throws Exception {
        File imgFile = new File(imagePath);
        if (imgFile.exists()) {
            ImageTarget target = new ImageTarget(imgFile);
            target.setMinScore(this.similarity);
            List regions = this.mainScreen.findAll((Target)target);
            regions.sort(new Comparator<ScreenRegion>(){

                @Override
                public int compare(ScreenRegion o1, ScreenRegion o2) {
                    double reg2Score;
                    double reg1Score = o1.getScore();
                    if (reg1Score > (reg2Score = o2.getScore())) {
                        return -1;
                    }
                    if (reg1Score < reg2Score) {
                        return 1;
                    }
                    return 0;
                }
            });
            return regions;
        }
        throw new Exception(StringConstants.COMM_EXC_IMG_FILE_DOES_NOT_EXIST);
    }
}

