/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver.edge;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.util.FileExcutableUtil;
import com.kms.katalon.core.webui.util.OSUtil;
import java.io.File;
import java.io.IOException;

public class EdgeDriverUtil {
    protected static final KeywordLogger logger = KeywordLogger.getInstance(DriverFactory.class);

    public static String getEdgeChromiumDriverPath() {
        if (OSUtil.isWindows()) {
            if (OSUtil.is64Bit()) {
                File location = new File(RunConfiguration.getProjectDir(), "Include/drivers/edgechromiumdriver_win64/msedgedriver.exe");
                if (location.exists()) {
                    logger.logInfo("Custom Edge Chromium driver detected at location: " + location.getAbsolutePath());
                    return location.getAbsolutePath();
                }
            } else {
                File location = new File(RunConfiguration.getProjectDir(), "Include/drivers/edgechromiumdriver_win32/msedgedriver.exe");
                if (location.exists()) {
                    logger.logInfo("Custom Edge Chromium driver detected at location: " + location.getAbsolutePath());
                    return location.getAbsolutePath();
                }
            }
        } else if (OSUtil.isMac()) {
            File location = new File(RunConfiguration.getProjectDir(), "Include/drivers/edgechromiumdriver_mac/msedgedriver");
            if (location.exists()) {
                String customDriverPath = location.getAbsolutePath();
                try {
                    logger.logInfo("Custom Edge Chromium driver detected at location: " + location.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(customDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make Edge Chromium driver file : " + customDriverPath + " executable");
                }
                return customDriverPath;
            }
        } else {
            File location = new File(RunConfiguration.getProjectDir(), "Include/drivers/edgechromiumdriver_linux64/msedgedriver");
            if (location.exists()) {
                String customDriverPath = location.getAbsolutePath();
                try {
                    logger.logInfo("Custom Edge Chromium driver detected at location: " + location.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(customDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make Edge Chromium driver file : " + customDriverPath + " executable");
                }
                return location.getAbsolutePath();
            }
        }
        return RunConfiguration.getDriverSystemProperty((String)"WebUI", (String)"edgeChromiumDriverPath");
    }
}

