/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.helper.screenshot;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webui.common.ImageTextProperties;
import com.kms.katalon.core.webui.constants.CoreWebuiMessageConstants;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.util.FileUtil;
import com.kms.katalon.core.webui.util.ParseUtil;
import com.kms.katalon.core.webui.util.StringUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.openqa.selenium.WebDriver;

public class ScreenshotTextHelper {
    private static final KeywordLogger logger = KeywordLogger.getInstance(ScreenshotTextHelper.class);
    private static final int MAX_FONT_SIZE = 50;
    private static final int MAX_CHARACTERS = 100;
    private static final String UPDATED_TEXT_WIDTH = "newBufferedWidth";
    private static final String UPDATED_TEXT_HEIGHT = "newBufferedHeight";
    private static final String SPLITTED_TEXT = "splittedText";
    private static final String IMAGE_X = "imageX";
    private static final String IMAGE_Y = "imageY";
    private static final String TEXT_X = "textX";
    private static final String TEXT_Y = "textY";

    public static BufferedImage addTextToScreenShot(String pathToScreenshot, Map<String, Object> screenshotOptions) {
        ImageTextProperties options;
        BufferedImage image;
        block3: {
            try {
                image = ImageIO.read(new File(pathToScreenshot));
                options = ScreenshotTextHelper.parseMapToImageTextObject(screenshotOptions);
                if (options != null && ScreenshotTextHelper.checkValidImageTextProperties(options)) break block3;
                return null;
            }
            catch (Exception exception) {
                logger.logWarning(MessageFormat.format(CoreWebuiMessageConstants.KW_SCREENSHOT_EXCEPTION_WHILE_ADDING_TEXT, exception.getMessage()));
                return null;
            }
        }
        image = ScreenshotTextHelper.addTextToBufferedImage(image, options);
        FileUtil.saveImage(image, pathToScreenshot);
        return image;
    }

    private static BufferedImage addTextToBufferedImage(BufferedImage screenshot, ImageTextProperties screenshotOptions) {
        WebDriver driver = DriverFactory.getWebDriver();
        Objects.requireNonNull(screenshot);
        Objects.requireNonNull(driver);
        Graphics2D screenshotGrahics = (Graphics2D)screenshot.getGraphics();
        Font font = new Font(screenshotOptions.getFont(), screenshotOptions.getFontStyle(), screenshotOptions.getFontSize());
        FontMetrics fontMetrics = screenshotGrahics.getFontMetrics(font);
        Map<String, Object> bufferedMetrics = ScreenshotTextHelper.calculateMetricsForAddingText(screenshot, fontMetrics, screenshotOptions.getText(), screenshotOptions.getX(), screenshotOptions.getY());
        BufferedImage screenshotWithText = screenshot;
        try {
            screenshotWithText = new BufferedImage((Integer)bufferedMetrics.get(UPDATED_TEXT_WIDTH), (Integer)bufferedMetrics.get(UPDATED_TEXT_HEIGHT), 2);
        }
        catch (IllegalArgumentException | OutOfMemoryError throwable) {
            logger.logWarning(CoreWebuiMessageConstants.MSG_ERR_SCREENSHOT_EXCEPTION_IMAGE_TOO_LARGE);
            return screenshot;
        }
        Graphics2D screenshotWithTextGrahics = screenshotWithText.createGraphics();
        Color oldColor = screenshotWithTextGrahics.getColor();
        screenshotWithTextGrahics.setPaint(Color.WHITE);
        screenshotWithTextGrahics.fillRect(0, 0, (Integer)bufferedMetrics.get(UPDATED_TEXT_WIDTH), (Integer)bufferedMetrics.get(UPDATED_TEXT_HEIGHT));
        screenshotWithTextGrahics.setColor(oldColor);
        screenshotWithTextGrahics.drawImage(screenshot, null, (int)((Integer)bufferedMetrics.get(IMAGE_X)), (Integer)bufferedMetrics.get(IMAGE_Y));
        screenshotWithTextGrahics.setFont(font);
        screenshotWithTextGrahics.setColor(screenshotOptions.getFontColor());
        StringUtils.drawSplittedText((ArrayList)bufferedMetrics.get(SPLITTED_TEXT), fontMetrics, screenshotWithTextGrahics, (Integer)bufferedMetrics.get(TEXT_X), (Integer)bufferedMetrics.get(TEXT_Y));
        screenshotWithTextGrahics.dispose();
        return screenshotWithText;
    }

    private static Map<String, Object> calculateMetricsForAddingText(BufferedImage screenshot, FontMetrics fontMetrics, String text, int expectedTextX, int expectedTextY) {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        int screenshotWidth = screenshot.getWidth();
        int screenshotHeight = screenshot.getHeight();
        int imageX = expectedTextX >= 0 ? 0 : -expectedTextX;
        metrics.put(IMAGE_X, imageX);
        int imageY = expectedTextY >= 0 ? 0 : -expectedTextY;
        metrics.put(IMAGE_Y, imageY);
        metrics.put(TEXT_X, expectedTextX <= 0 ? 0 : expectedTextX);
        metrics.put(TEXT_Y, (expectedTextY <= 0 ? 0 : expectedTextY) + fontMetrics.getAscent());
        int textWidth = 0;
        textWidth = expectedTextX > 0 && fontMetrics.stringWidth("AAAAA") > screenshotWidth - expectedTextX ? (fontMetrics.stringWidth(text) < 1000 ? fontMetrics.stringWidth(text) : 1000) : screenshotWidth - expectedTextX;
        int textHeight = 0;
        List<String> splittedText = StringUtils.wrap(text, fontMetrics, textWidth);
        metrics.put(SPLITTED_TEXT, splittedText);
        textHeight = splittedText.size() * (fontMetrics.getHeight() + fontMetrics.getAscent());
        int newBufferedWidth = 0;
        int moduloBetweenTextAndScreenshotWidth = textWidth - screenshotWidth + expectedTextX;
        newBufferedWidth = expectedTextX >= 0 ? (moduloBetweenTextAndScreenshotWidth >= 0 ? expectedTextX + textWidth : screenshotWidth) : (moduloBetweenTextAndScreenshotWidth > 0 ? textWidth : screenshotWidth - expectedTextX);
        metrics.put(UPDATED_TEXT_WIDTH, newBufferedWidth);
        int newBufferedHeight = 0;
        int moduloBetweenTextAndScreenshotHeight = textHeight - screenshotHeight + expectedTextY;
        newBufferedHeight = expectedTextY >= 0 ? (moduloBetweenTextAndScreenshotHeight >= 0 ? expectedTextY + textHeight : screenshotHeight) : (moduloBetweenTextAndScreenshotHeight > 0 ? textHeight : screenshotHeight - expectedTextY);
        metrics.put(UPDATED_TEXT_HEIGHT, newBufferedHeight);
        return metrics;
    }

    private static boolean checkValidImageTextProperties(ImageTextProperties screenshotOptions) {
        String screenshotText = screenshotOptions.getText();
        if (screenshotText == null || screenshotText.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(CoreWebuiMessageConstants.MSG_ERR_PROPERTY_MUST_NOT_BE_NULL, "text"));
        }
        if (screenshotOptions.getFontSize() > 50) {
            throw new IllegalArgumentException(CoreWebuiMessageConstants.MSG_WARN_FONT_SIZE_TOO_LARGE);
        }
        if (screenshotText.length() > 100) {
            logger.logWarning(MessageFormat.format(CoreWebuiMessageConstants.MSG_ERR_IMAGE_TEXT_TOO_LONG, 100));
            screenshotOptions.setText(screenshotText.substring(0, 100));
        }
        return ScreenshotTextHelper.checkValidFont(screenshotOptions.getFont());
    }

    public static ImageTextProperties parseMapToImageTextObject(Map<String, Object> properties) {
        ImageTextProperties imageTextProperties = new ImageTextProperties();
        block23: for (String option : properties.keySet()) {
            Object value = properties.get(option);
            try {
                switch (option) {
                    case "text": {
                        imageTextProperties.setText(ParseUtil.parseString(value));
                        continue block23;
                    }
                    case "x": {
                        if (value == null) continue block23;
                        imageTextProperties.setX(ParseUtil.parseInt(value));
                        continue block23;
                    }
                    case "y": {
                        if (value == null) continue block23;
                        imageTextProperties.setY(ParseUtil.parseInt(value));
                        continue block23;
                    }
                    case "font": {
                        if (value == null) continue block23;
                        imageTextProperties.setFont((String)value);
                        continue block23;
                    }
                    case "fontSize": 
                    case "fontsize": {
                        if (value == null) continue block23;
                        imageTextProperties.setFontSize(ParseUtil.parseInt(value));
                        continue block23;
                    }
                    case "fontColor": 
                    case "fontcolor": {
                        if (value == null) continue block23;
                        imageTextProperties.setFontColor(ParseUtil.parseColor(value));
                        continue block23;
                    }
                    case "fontStyle": 
                    case "fontstyle": {
                        if (value == null) continue block23;
                        imageTextProperties.setFontStyle(ParseUtil.parseFontStyle(value));
                        continue block23;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageFormat.format(CoreWebuiMessageConstants.MSG_ERR_INVALID_PROPERTY, option));
                    }
                }
            }
            catch (ClassCastException | IllegalArgumentException exception) {
                logger.logWarning(MessageFormat.format(CoreWebuiMessageConstants.MSG_WARN_INVALID_OPTION, option, exception.getMessage()));
                return null;
            }
        }
        return imageTextProperties;
    }

    private static boolean checkValidFont(String font) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] allFontFamilyNames = graphicsEnvironment.getAvailableFontFamilyNames();
        List<String> fontList = Arrays.asList(allFontFamilyNames);
        if (font != null && fontList.contains(font)) {
            return true;
        }
        throw new IllegalArgumentException(MessageFormat.format(CoreWebuiMessageConstants.MSG_ERR_INVALID_FONT, font, org.apache.commons.lang3.StringUtils.join(fontList, (String)",")));
    }
}

