/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.report;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.console.entity.BooleanConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.LongConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.ReportFolder;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.launcher.result.ExecutionEntityResult;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.integration.analytics.AnalyticsComponent;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.report.AnalyticsReportService;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.OrganizationSetting;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.testops.core.model.AnalyticsTestRun;
import com.kms.katalon.testops.core.model.AnalyticsTracking;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AnalyticsReportIntegration
implements ReportIntegrationContribution,
AnalyticsComponent {
    @Inject
    private IFeatureController featureController;
    @Inject
    private ITestOpsController testOpsController;
    public static final String TESTOPS_RELEASE_ID_CONSOLE_OPTION_NAME = "testOpsReleaseId";
    public static final String TESTOPS_PROJECT_ID_CONSOLE_OPTION_NAME = "testOpsProjectId";
    public static final String TESTOPS_BUILD_ID_CONSOLE_OPTION_NAME = "testOpsBuildId";
    public static final String TESTOPS_SERVER_URL_CONSOLE_OPTION_NAME = "testOps.serverUrl";
    public static final String TESTOPS_ENABLED_CONSOLE_OPTION_NAME = "testOps.enabled";
    public static final String TESTOPS_TEST_RUN_NAME_CONSOLE_OPTION_NAME = "testOps.testRunName";
    public static final String TESTOPS_BASELINE_COLLECTION_ID_CONSOLE_OPTION_NAME = "testOps.baselineCollectionId";
    public static final String TESTOPS_TRACK_INTEGRATION_ENABLED = "testops_integration_enabled";
    public static final String TESTOPS_PREFIX = "testOps.";
    private static Long TESTOPS_RELEASE_ID = null;
    private static Long TESTOPS_PROJECT_ID = null;
    private static Long TESTOPS_BUILD_ID = null;
    private static String TESTOPS_SERVER_URL = null;
    private static Boolean TESTOPS_ENABLED = null;
    private static String TESTOPS_TEST_RUN_NAME = null;
    private static final Object lock = new Object();
    private boolean isTestOpsIntegrationEnabled = false;
    private List<ConsoleOption<?>> integrationCommandList;
    private Map<String, Object> testOpsGenericCommandMap = new LinkedHashMap<String, Object>();
    public static final LongConsoleOption TESTOPS_RELEASE_ID_CONSOLE_OPTION = new LongConsoleOption(){

        public String getOption() {
            return AnalyticsReportIntegration.TESTOPS_RELEASE_ID_CONSOLE_OPTION_NAME;
        }

        public Long getValue() {
            return TESTOPS_RELEASE_ID;
        }
    };
    public static final LongConsoleOption TESTOPS_PROJECT_ID_CONSOLE_OPTION = new LongConsoleOption(){

        public String getOption() {
            return AnalyticsReportIntegration.TESTOPS_PROJECT_ID_CONSOLE_OPTION_NAME;
        }

        public Long getValue() {
            return TESTOPS_PROJECT_ID;
        }
    };
    public static final LongConsoleOption TESTOPS_BUILD_ID_CONSOLE_OPTION = new LongConsoleOption(){

        public String getOption() {
            return AnalyticsReportIntegration.TESTOPS_BUILD_ID_CONSOLE_OPTION_NAME;
        }

        public Long getValue() {
            return TESTOPS_BUILD_ID;
        }
    };
    public static final StringConsoleOption TESTOPS_SERVER_URL_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return AnalyticsReportIntegration.TESTOPS_SERVER_URL_CONSOLE_OPTION_NAME;
        }

        public String getValue() {
            return TESTOPS_SERVER_URL;
        }
    };
    public static final BooleanConsoleOption TESTOPS_ENABLED_CONSOLE_OPTION = new BooleanConsoleOption(){

        public String getOption() {
            return AnalyticsReportIntegration.TESTOPS_ENABLED_CONSOLE_OPTION_NAME;
        }

        public Boolean getValue() {
            return TESTOPS_ENABLED;
        }
    };
    public static final StringConsoleOption TESTOPS_TEST_RUN_NAME_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return AnalyticsReportIntegration.TESTOPS_TEST_RUN_NAME_CONSOLE_OPTION_NAME;
        }

        public String getValue() {
            return TESTOPS_TEST_RUN_NAME;
        }
    };
    private AnalyticsReportService reportService = new AnalyticsReportService();

    public AnalyticsReportIntegration() {
        this.integrationCommandList = new ArrayList();
        this.integrationCommandList.add((ConsoleOption<?>)TESTOPS_ENABLED_CONSOLE_OPTION);
        this.integrationCommandList.add((ConsoleOption<?>)TESTOPS_RELEASE_ID_CONSOLE_OPTION);
        this.integrationCommandList.add((ConsoleOption<?>)TESTOPS_PROJECT_ID_CONSOLE_OPTION);
        this.integrationCommandList.add((ConsoleOption<?>)TESTOPS_BUILD_ID_CONSOLE_OPTION);
        this.integrationCommandList.add((ConsoleOption<?>)TESTOPS_SERVER_URL_CONSOLE_OPTION);
        this.integrationCommandList.add((ConsoleOption<?>)TESTOPS_TEST_RUN_NAME_CONSOLE_OPTION);
    }

    public void setConsoleOptionList(List<ConsoleOption<?>> list) {
        this.integrationCommandList = list;
    }

    public List<ConsoleOption<?>> getConsoleOptionList() {
        return this.integrationCommandList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        String param;
        String optionName;
        String[] split;
        boolean canNotUseTestOpsVisualTesting;
        if (StringUtils.isBlank((String)argumentValue)) {
            return;
        }
        boolean bl = canNotUseTestOpsVisualTesting = !this.featureController.canUse(ProductFeature.TESTOPS_VISUAL_TESTING) && consoleOption != null && consoleOption.getOption() != null && consoleOption.getOption().startsWith(TESTOPS_BASELINE_COLLECTION_ID_CONSOLE_OPTION_NAME);
        if (canNotUseTestOpsVisualTesting) {
            LogUtil.logError((String)String.format("WARNING: You are using \"%s\" argument which requires a Studio Enterprise license. To unlock advanced features, please upgrade to a Katalon Enterprise license.", TESTOPS_BASELINE_COLLECTION_ID_CONSOLE_OPTION_NAME));
            return;
        }
        if (consoleOption == TESTOPS_RELEASE_ID_CONSOLE_OPTION) {
            try {
                TESTOPS_RELEASE_ID = Long.parseLong(argumentValue.trim());
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
            return;
        }
        if (consoleOption == TESTOPS_PROJECT_ID_CONSOLE_OPTION) {
            try {
                TESTOPS_PROJECT_ID = Long.parseLong(argumentValue.trim());
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
            return;
        }
        if (consoleOption == TESTOPS_BUILD_ID_CONSOLE_OPTION) {
            try {
                Object e = lock;
                synchronized (e) {
                    TESTOPS_BUILD_ID = Long.parseLong(argumentValue.trim());
                }
            }
            catch (NumberFormatException e) {
                LogUtil.logError((Throwable)e);
            }
            return;
        }
        if (consoleOption == TESTOPS_SERVER_URL_CONSOLE_OPTION) {
            Object e = lock;
            synchronized (e) {
                TESTOPS_SERVER_URL = argumentValue.trim();
            }
            return;
        }
        if (consoleOption == TESTOPS_ENABLED_CONSOLE_OPTION) {
            Object e = lock;
            synchronized (e) {
                TESTOPS_ENABLED = Boolean.parseBoolean(argumentValue.trim());
            }
            return;
        }
        if (consoleOption == TESTOPS_TEST_RUN_NAME_CONSOLE_OPTION) {
            Object e = lock;
            synchronized (e) {
                TESTOPS_TEST_RUN_NAME = argumentValue.trim();
            }
            return;
        }
        if (consoleOption.getOption().startsWith(TESTOPS_PREFIX) && (split = (optionName = consoleOption.getOption()).split("\\.")).length == 2 && StringUtils.isNotBlank((String)(param = split[1])) && StringUtils.isNotBlank((String)argumentValue)) {
            this.testOpsGenericCommandMap.put(StringUtils.substring((String)param, (int)0, (int)50), StringUtils.substring((String)argumentValue, (int)0, (int)256));
        }
    }

    public void fetchRemoteSettings() {
        try {
            OrganizationSetting organizationSetting = this.testOpsController.getOrganizationSetting();
            this.isTestOpsIntegrationEnabled = organizationSetting.isTestOpsIntegrationEnabled();
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
    }

    public boolean isIntegrationActive(TestSuiteEntity testSuite) {
        try {
            return this.testOpsController.isIntegrated() && this.isTestOpsIntegrationEnabled;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public void uploadTestSuiteResult(TestSuiteLogRecord suiteLogRecord) throws Exception {
        String collectionId = suiteLogRecord.getTestSuiteCollectionId();
        if (StringUtils.isNotBlank((String)collectionId)) {
            return;
        }
        ReportFolder reportFolder = new ReportFolder(suiteLogRecord.getLogFolder());
        this.reportService.upload(reportFolder);
    }

    public void uploadTestSuiteCollectionResult(TestSuiteCollectionLogRecord collectionLogRecord) throws Exception {
        List suiteLogRecords = collectionLogRecord.getTestSuiteRecords();
        ArrayList<String> paths = new ArrayList<String>();
        for (TestSuiteLogRecord suiteLogRecord : suiteLogRecords) {
            paths.add(suiteLogRecord.getLogFolder());
        }
        paths.add(collectionLogRecord.getReportFolder());
        ReportFolder reportFolder = new ReportFolder(paths);
        this.reportService.upload(reportFolder);
    }

    public void printIntegrateMessage() {
        LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_INTEGRATE_WITH_KA);
    }

    public void notifyProccess(Object event, ExecutionEntityResult result) {
        try {
            IExecutedEntity executedEntity = result.getExecutedEntity();
            if (!(executedEntity instanceof TestSuiteExecutedEntity) && !(executedEntity instanceof TestSuiteCollectionExecutedEntity)) {
                return;
            }
            boolean integrationActive = this.testOpsController.isIntegrated();
            boolean isUploadReport = this.testOpsController.isAutoUploadReportEnabled();
            if (!(integrationActive && isUploadReport && this.isTestOpsIntegrationEnabled)) {
                return;
            }
            if (executedEntity instanceof TestSuiteExecutedEntity) {
                if (RunConfiguration.getInstance().isLaunchingDebugMode()) {
                    return;
                }
                AnalyticsTestRun testRun = new AnalyticsTestRun();
                testRun.setName(result.getName());
                testRun.setSessionId(result.getSessionId());
                if (result.getTestStatusValue() != null) {
                    testRun.setStatus(result.getTestStatusValue().name());
                }
                testRun.setTestSuiteId(executedEntity.getSourceId());
                testRun.setEnd(result.isEnd());
                if (event instanceof LauncherStatus) {
                    LauncherStatus status = (LauncherStatus)event;
                    switch (status) {
                        case WAITING: 
                        case TERMINATED: {
                            break;
                        }
                        default: {
                            this.reportService.updateExecutionProccess(testRun);
                            break;
                        }
                    }
                } else {
                    this.reportService.updateExecutionProccess(testRun);
                }
            } else if (executedEntity instanceof TestSuiteCollectionExecutedEntity) {
                AnalyticsTestRun testRun = new AnalyticsTestRun();
                testRun.setSessionId(result.getSessionId());
                testRun.setEnd(result.isEnd());
                this.reportService.updateExecutionProccess(testRun);
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
    }

    public void sendTrackingActivity(Long organizationId, String machineId, String sessionId, Date startTime, Date endTime, String ksVersion) {
        try {
            AnalyticsTracking trackingInfo = new AnalyticsTracking();
            trackingInfo.setMachineId(machineId);
            trackingInfo.setSessionId(sessionId);
            trackingInfo.setStartTime(startTime);
            trackingInfo.setEndTime(endTime);
            trackingInfo.setKsVersion(ksVersion);
            trackingInfo.setOrganizationId(organizationId);
            this.reportService.sendTrackingActivity(trackingInfo);
        }
        catch (Exception exception) {}
    }

    public boolean shouldUploadReportWhenIncomplete() {
        return true;
    }

    public boolean isNeededTrackingData() {
        return true;
    }

    public Map<String, Object> getTrackingProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        boolean isIntegrationEnabled = this.testOpsController.isIntegrated();
        properties.put(TESTOPS_TRACK_INTEGRATION_ENABLED, isIntegrationEnabled);
        return properties;
    }

    public Map<String, Object> getTestOpsGenericCommandMap() {
        return this.testOpsGenericCommandMap;
    }

    public boolean isIntegrationEnabled() {
        return this.isTestOpsIntegrationEnabled;
    }

    public boolean canUploadTestSuiteCollectionReport() {
        try {
            return this.testOpsController.isIntegrated() && this.isTestOpsIntegrationEnabled && this.testOpsController.isAutoUploadReportEnabled();
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public boolean isAllowedGenerateReport(TestSuiteEntity testSuite) {
        return this.isIntegrationActive(testSuite) && this.testOpsController.isAutoUploadReportEnabled();
    }
}

