/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.jd.decompiler;

import java.io.File;
import java.nio.file.Files;
import jd.ide.eclipse.editors.JDSourceMapper;
import org.apache.commons.lang3.time.StopWatch;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.BaseDecompiler;
import org.sf.feeling.decompiler.jd.JDCoreDecompilerPlugin;
import org.sf.feeling.decompiler.util.ClassUtil;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.UIUtil;

public class JDCoreDecompiler
extends BaseDecompiler {
    private String source = "";
    private long time;
    private String log = "";
    private JDSourceMapper mapper;

    public JDCoreDecompiler(JDSourceMapper mapper) {
        this.mapper = mapper;
    }

    public void decompile(String root, String classPackage, String className) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.log = "";
        this.source = "";
        Boolean displayNumber = null;
        File workingDir = new File(root);
        File zipFile = new File(System.getProperty("java.io.tmpdir"), className.replaceAll("(?i)\\.class", String.valueOf(System.currentTimeMillis()) + ".jar"));
        String zipFileName = zipFile.getAbsolutePath();
        try {
            if (classPackage.length() == 0) {
                File classFile = new File(root, className);
                String qualifiedName = ClassUtil.getClassQualifiedName((byte[])Files.readAllBytes(classFile.toPath()));
                classPackage = qualifiedName.replace("/" + className.replaceAll("(?i)\\.class", ""), "");
            }
            FileUtil.zipDir((File)workingDir, (String)classPackage, (String)zipFileName);
            if (UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
                displayNumber = JavaDecompilerPlugin.getDefault().isDisplayLineNumber();
                JavaDecompilerPlugin.getDefault().displayLineNumber(Boolean.TRUE);
            }
            this.source = this.mapper.decompile(zipFileName, String.valueOf(classPackage.length() > 0 ? String.valueOf(classPackage) + "/" : "") + className);
            if (!zipFile.delete()) {
                zipFile.deleteOnExit();
            }
        }
        catch (Exception e) {
            JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
        }
        if (displayNumber != null) {
            JavaDecompilerPlugin.getDefault().displayLineNumber(displayNumber);
        }
        this.time = stopWatch.getTime();
    }

    public void decompileFromArchive(String archivePath, String packege, String className) {
        long start = System.nanoTime();
        Boolean displayNumber = null;
        try {
            if (UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
                displayNumber = JavaDecompilerPlugin.getDefault().isDisplayLineNumber();
                JavaDecompilerPlugin.getDefault().displayLineNumber(Boolean.TRUE);
            }
            String decompileClassName = String.valueOf(packege) + "/" + className.replaceAll("(?i)\\.class$", "");
            this.source = this.mapper.decompile(archivePath, decompileClassName);
        }
        catch (Exception e) {
            JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
        }
        if (displayNumber != null) {
            JavaDecompilerPlugin.getDefault().displayLineNumber(displayNumber);
        }
        this.time = (System.nanoTime() - start) / 1000000L;
    }

    public long getDecompilationTime() {
        return this.time;
    }

    public String getLog() {
        return this.log;
    }

    public String getSource() {
        return this.source;
    }

    public String getDecompilerType() {
        return "JD-Core";
    }

    public String removeComment(String source) {
        return source;
    }

    public boolean supportLevel(int level) {
        return true;
    }

    public boolean supportDebugLevel(int level) {
        return true;
    }

    public String getDecompilerName() {
        return "JD-Core";
    }

    public String getDecompilerVersion() {
        return JDCoreDecompilerPlugin.decompilerVersion;
    }
}

