/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.parts;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.providers.HoveredImageColumnLabelProvider;
import com.kms.katalon.composer.components.impl.providers.HyperLinkColumnLabelProvider;
import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.analytics.constants.AnalyticsStringConstants;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.integration.analytics.utils.ColorUtil;
import com.kms.katalon.composer.integration.analytics.utils.ReportImporter;
import com.kms.katalon.composer.integration.analytics.utils.TestOpsUtil;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.TestOpsTimeFormatter;
import com.kms.katalon.testops.core.model.AnalyticsExecution;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsTestSuiteResource;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.Date;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ExecutionHistoryPart {
    private Composite parent;
    private MPart part;
    private CTableViewer viewer;
    private Composite executionPart;
    private Composite loadingPart;
    private StackLayout viewerLayout;
    private Composite errorPart;
    private Composite viewerPart;
    private Composite emptyPart;
    private Date now;
    @Inject
    private ITestOpsController testOpsController;

    @PostConstruct
    public void createPartControl(Composite parent, MCompositePart mpart) {
        this.parent = parent;
        this.part = mpart;
        GridLayout gridLayout = new GridLayout(1, false);
        parent.setLayout((Layout)gridLayout);
        this.createHeaderPart();
        this.viewerPart = new Composite(parent, 0);
        this.viewerLayout = new StackLayout();
        this.viewerPart.setLayout((Layout)this.viewerLayout);
        this.viewerPart.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createExecutionPart();
        this.createErrorPart();
        this.createLoadingPart();
        this.createEmptyPart();
        this.refresh();
    }

    private void refresh() {
        this.viewerLayout.topControl = this.loadingPart;
        this.viewerPart.layout();
        Thread getExecutionsThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    List<AnalyticsExecution> executions = ExecutionHistoryPart.this.getExecution();
                    UISynchronizeService.asyncExec(() -> ExecutionHistoryPart.this.updateDataViewer(executions));
                }
                catch (AnalyticsApiException e) {
                    LoggerSingleton.logError((Throwable)e);
                    UISynchronizeService.asyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).ExecutionHistoryPart.this.viewerLayout.topControl = (this).ExecutionHistoryPart.this.errorPart;
                            (this).ExecutionHistoryPart.this.viewerPart.layout();
                        }
                    });
                }
            }
        });
        getExecutionsThread.start();
    }

    private void updateDataViewer(List<AnalyticsExecution> executions) {
        if (executions == null) {
            return;
        }
        if (executions.isEmpty()) {
            this.viewerLayout.topControl = this.emptyPart;
            this.viewerPart.layout();
            return;
        }
        this.now = new Date();
        if (this.viewer == null) {
            this.createExecutionPart();
        } else {
            this.viewer.getTable().removeAll();
            this.viewer.setInput(executions);
            this.viewer.refresh();
        }
        this.viewerLayout.topControl = this.executionPart;
        this.viewerPart.layout();
    }

    private List<AnalyticsExecution> getExecution() throws AnalyticsApiException {
        AnalyticsSettingStore settingStore = AnalyticsSettingStore.getStore((String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        AnalyticsProject project = settingStore.getProject();
        return this.testOpsController.getExecutions(project.getId());
    }

    private void createEmptyPart() {
        this.emptyPart = new Composite(this.viewerPart, 0);
        RowLayout rowLayout = new RowLayout();
        this.emptyPart.setLayout((Layout)rowLayout);
        Link link = new Link(this.emptyPart, 0);
        this.setFontStyle(link, 14, 0);
        link.setLayoutData((Object)new RowData());
        link.setText(ComposerIntegrationAnalyticsMessageConstants.LNK_EXECUTION_EMPTY);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)ComposerIntegrationAnalyticsMessageConstants.LNK_ENABLE_INTEGRATION_GUIDE);
            }
        });
    }

    private void createErrorPart() {
        this.errorPart = new Composite(this.viewerPart, 0);
        RowLayout rowLayout = new RowLayout();
        this.errorPart.setLayout((Layout)rowLayout);
        Label lblError = new Label(this.errorPart, 0);
        lblError.setLayoutData((Object)new RowData());
        this.setFontStyle(lblError, 16, 0);
        lblError.setText(ComposerIntegrationAnalyticsMessageConstants.MSG_ANALYTICS_CONNECTION_ERROR);
        lblError.setForeground(ColorUtil.LIGHT_RED);
    }

    private void createLoadingPart() {
        this.loadingPart = new Composite(this.viewerPart, 0);
        RowLayout rowLayout = new RowLayout();
        this.loadingPart.setLayout((Layout)rowLayout);
        Label lblLoading = new Label(this.loadingPart, 0);
        lblLoading.setLayoutData((Object)new RowData());
        this.setFontStyle(lblLoading, 16, 0);
        lblLoading.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_LOADING);
        lblLoading.setForeground(ColorUtil.LIGHT_GREEN);
    }

    private void createExecutionPart() {
        this.executionPart = new Composite(this.viewerPart, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        this.executionPart.setLayout((Layout)gridLayout);
        TableLayout tableLayout = new TableLayout();
        this.viewer = new CTableViewer(this.executionPart, 67584);
        this.viewer.getTable().setLayout((Layout)tableLayout);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        final TestOpsTimeFormatter timeFormatter = new TestOpsTimeFormatter();
        TableViewerColumn colStatus = new TableViewerColumn((TableViewer)this.viewer, 0);
        colStatus.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.EXECUTION_STATUS);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        colStatus.setLabelProvider((CellLabelProvider)new TypeCheckedStyleCellLabelProvider<AnalyticsExecution>(0){

            protected Class<AnalyticsExecution> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsExecution element) {
                switch (element.getStatus()) {
                    case PASSED: {
                        return ImageConstants.IMG_16_TESTOPS_EXECUTION_PASSED;
                    }
                    case FAILED: {
                        return ImageConstants.IMG_16_TESTOPS_EXECUTION_FAILED;
                    }
                    case ERROR: {
                        return ImageConstants.IMG_16_TESTOPS_PLAN_ERROR;
                    }
                    case SKIPPED: {
                        return ImageConstants.IMG_16_TESTOPS_STATUS_SKIPPED;
                    }
                }
                return null;
            }

            protected String getText(AnalyticsExecution element) {
                return null;
            }

            public String getToolTipText(Object element) {
                switch (((AnalyticsExecution)element).getStatus()) {
                    case PASSED: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTION_STATUS_PASSED;
                    }
                    case FAILED: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTION_STATUS_FAILED;
                    }
                    case SKIPPED: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTION_STATUS_SKIPPED;
                    }
                    case ERROR: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTION_STATUS_ERROR;
                    }
                    case INCOMPLETE: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTION_STATUS_INCOMPLETE;
                    }
                    case NOT_RUN: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTION_STATUS_NOT_RUN;
                    }
                    case RUNNING: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTION_STATUS_RUNNING;
                    }
                }
                return null;
            }
        });
        TableViewerColumn colID = new TableViewerColumn((TableViewer)this.viewer, 0);
        colID.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.EXECUTION_ID);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        colID.setLabelProvider((CellLabelProvider)new HyperLinkColumnLabelProvider<AnalyticsExecution>(1){

            protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
                AnalyticsExecution execution = (AnalyticsExecution)cell.getElement();
                Program.launch((String)execution.getWebUrl());
            }

            protected Class<AnalyticsExecution> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsExecution element) {
                return null;
            }

            protected String getText(AnalyticsExecution element) {
                return String.valueOf(element.getOrder());
            }

            public String getToolTipText(Object element) {
                AnalyticsExecution execution = (AnalyticsExecution)element;
                if (execution.getStartTime() == null) {
                    return "";
                }
                return String.valueOf(execution.getOrder());
            }
        });
        TableViewerColumn colName = new TableViewerColumn((TableViewer)this.viewer, 0);
        colName.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.EXECUTION_NAME);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(450));
        colName.setLabelProvider((CellLabelProvider)new TypeCheckedStyleCellLabelProvider<AnalyticsExecution>(2){

            protected Class<AnalyticsExecution> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsExecution element) {
                return null;
            }

            protected String getText(AnalyticsExecution element) {
                return ExecutionHistoryPart.this.getTestSuiteName(element.getExecutionTestSuiteResources());
            }

            public String getToolTipText(Object element) {
                AnalyticsExecution execution = (AnalyticsExecution)element;
                if (execution.getStartTime() == null) {
                    return "";
                }
                return ExecutionHistoryPart.this.getTestSuiteName(execution.getExecutionTestSuiteResources());
            }
        });
        TableViewerColumn colDuration = new TableViewerColumn((TableViewer)this.viewer, 0);
        colDuration.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.EXECUTION_DURATION);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(150));
        colDuration.setLabelProvider((CellLabelProvider)new TypeCheckedStyleCellLabelProvider<AnalyticsExecution>(3){

            protected Class<AnalyticsExecution> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsExecution element) {
                return null;
            }

            protected String getText(AnalyticsExecution element) {
                return timeFormatter.formatDuration(element.getDuration());
            }

            public String getToolTipText(Object element) {
                AnalyticsExecution execution = (AnalyticsExecution)element;
                if (execution.getStartTime() == null) {
                    return "";
                }
                return timeFormatter.formatDuration(execution.getDuration());
            }
        });
        TableViewerColumn colStartDate = new TableViewerColumn((TableViewer)this.viewer, 0);
        colStartDate.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.EXECUTION_START_TIME);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(325));
        colStartDate.setLabelProvider((CellLabelProvider)new TypeCheckedStyleCellLabelProvider<AnalyticsExecution>(4){

            protected Class<AnalyticsExecution> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsExecution element) {
                return null;
            }

            protected String getText(AnalyticsExecution element) {
                if (element.getStartTime() == null) {
                    return "";
                }
                return timeFormatter.formatEvent(element.getStartTime(), ExecutionHistoryPart.this.now);
            }

            public String getToolTipText(Object element) {
                AnalyticsExecution execution = (AnalyticsExecution)element;
                if (execution.getStartTime() == null) {
                    return "";
                }
                return timeFormatter.formatDetail(execution.getStartTime());
            }
        });
        TableViewerColumn colEndDate = new TableViewerColumn((TableViewer)this.viewer, 0);
        colEndDate.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.EXECUTION_END_TIME);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(325));
        colEndDate.setLabelProvider((CellLabelProvider)new TypeCheckedStyleCellLabelProvider<AnalyticsExecution>(5){

            protected Class<AnalyticsExecution> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsExecution element) {
                return null;
            }

            protected String getText(AnalyticsExecution element) {
                if (element.getEndTime() == null) {
                    return "";
                }
                return timeFormatter.formatEvent(element.getEndTime(), ExecutionHistoryPart.this.now);
            }

            public String getToolTipText(Object element) {
                if (((AnalyticsExecution)element).getEndTime() == null) {
                    return "";
                }
                return timeFormatter.formatDetail(((AnalyticsExecution)element).getEndTime());
            }
        });
        TableViewerColumn colDownload = new TableViewerColumn((TableViewer)this.viewer, 0);
        colDownload.getColumn().setText("");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        colDownload.setLabelProvider((CellLabelProvider)new HoveredImageColumnLabelProvider<AnalyticsExecution>(6){

            protected Image getHoveredImage(AnalyticsExecution element) {
                return ImageConstants.IMG_16_TESTOPS_DOWNLOAD;
            }

            public String getToolTipText(Object element) {
                return ComposerIntegrationAnalyticsMessageConstants.LBL_DOWNLOAD_REPORT;
            }

            protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
                ReportImporter.beginImport((AnalyticsExecution)cell.getElement(), ProjectController.getInstance().getCurrentProject());
            }

            protected Class<AnalyticsExecution> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsExecution element) {
                return ImageConstants.IMG_16_TESTOPS_DOWNLOAD;
            }

            protected String getText(AnalyticsExecution element) {
                return null;
            }
        });
    }

    private void createHeaderPart() {
        Composite headerComposite = new Composite(this.parent, 0);
        GridLayout headerLayout = new GridLayout(2, true);
        headerComposite.setLayout((Layout)headerLayout);
        headerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblExecution = new Label(headerComposite, 0);
        lblExecution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        lblExecution.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTIONS);
        this.setFontStyle(lblExecution, 14, 1);
        Composite viewAllComposite = new Composite(headerComposite, 0);
        GridLayout viewAllLayout = new GridLayout(5, false);
        viewAllLayout.marginWidth = 0;
        viewAllLayout.marginHeight = 0;
        viewAllLayout.verticalSpacing = 0;
        viewAllLayout.horizontalSpacing = 0;
        viewAllComposite.setLayout((Layout)viewAllLayout);
        viewAllComposite.setLayoutData((Object)new GridData(3, 0x1000000, true, false));
        ToolBar toolBar = new ToolBar(viewAllComposite, 0x800000);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        ToolItem item = new ToolItem(toolBar, 8);
        item.setToolTipText(AnalyticsStringConstants.REFRESH);
        item.setImage(ImageConstants.IMG_16_TESTOPS_REFRESH_NEW);
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionHistoryPart.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label imgTestOps = new Label(viewAllComposite, 0);
        imgTestOps.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        imgTestOps.setImage(ImageConstants.IMG_16_KATALON_TESTOPS);
        Link lnkViewAll = new Link(viewAllComposite, 0);
        lnkViewAll.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setFontStyle(lnkViewAll, 11, 0);
        String testOpsUrl = TestOpsUtil.getExecutionsPageURL();
        lnkViewAll.setText(" <a href=\"" + testOpsUrl + "\">" + ComposerIntegrationAnalyticsMessageConstants.LNK_VIEW_ALL_EXECUTIONS + "</a>");
        lnkViewAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)TestOpsUtil.getExecutionsPageURL());
            }
        });
    }

    private void setFontStyle(Label label, int fontSize, int style) {
        FontData[] fontData = label.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(fontSize);
            fontData[i].setStyle(style);
            ++i;
        }
        final Font newFont = new Font((Device)label.getDisplay(), fontData);
        label.setFont(newFont);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    private void setFontStyle(Link link, int fontSize, int style) {
        FontData[] fontData = link.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(fontSize);
            fontData[i].setStyle(style);
            ++i;
        }
        final Font newFont = new Font((Device)link.getDisplay(), fontData);
        link.setFont(newFont);
        link.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    private String getTestSuiteName(AnalyticsTestSuiteResource[] resources) {
        StringBuilder name = new StringBuilder();
        String delemiter = " | ";
        AnalyticsTestSuiteResource[] analyticsTestSuiteResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            AnalyticsTestSuiteResource resource = analyticsTestSuiteResourceArray[n2];
            name.append(resource.getTestSuite().getName() + delemiter);
            ++n2;
        }
        if (name.length() != 0) {
            name.delete(name.length() - delemiter.length(), name.length() - 1);
        }
        return name.toString();
    }
}

