/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.parts;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.providers.HyperLinkColumnLabelProvider;
import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.analytics.constants.AnalyticsStringConstants;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.integration.analytics.utils.ColorUtil;
import com.kms.katalon.composer.integration.analytics.utils.TestOpsUtil;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsRelease;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ReleasePart {
    private Composite parent;
    private CTableViewer viewer;
    private Composite releaseCompositePart;
    private Composite loadingPart;
    private StackLayout viewerLayout;
    private Composite errorPart;
    private Composite viewerPart;
    private Composite emptyPart;
    private AnalyticsSettingStore settingStore;
    @Inject
    private ITestOpsController testOpsController;

    @PostConstruct
    public void createPartControl(Composite parent, MCompositePart mpart) {
        this.parent = parent;
        GridLayout gridLayout = new GridLayout(1, false);
        parent.setLayout((Layout)gridLayout);
        this.settingStore = AnalyticsSettingStore.getStore((String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        this.createHeaderPart();
        this.viewerPart = new Composite(parent, 0);
        this.viewerLayout = new StackLayout();
        this.viewerPart.setLayout((Layout)this.viewerLayout);
        this.viewerPart.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createReleasePart();
        this.createErrorPart();
        this.createLoadingPart();
        this.createEmptyPart();
        this.refresh();
    }

    private void refresh() {
        this.viewerLayout.topControl = this.loadingPart;
        this.viewerPart.layout();
        Thread getExecutionsThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    List<AnalyticsRelease> releases = ReleasePart.this.getReleases();
                    UISynchronizeService.asyncExec(() -> ReleasePart.this.updateDataViewer(releases));
                }
                catch (AnalyticsApiException e) {
                    LoggerSingleton.logError((Throwable)e);
                    UISynchronizeService.asyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).ReleasePart.this.viewerLayout.topControl = (this).ReleasePart.this.errorPart;
                            (this).ReleasePart.this.viewerPart.layout();
                        }
                    });
                }
            }
        });
        getExecutionsThread.start();
    }

    private void updateDataViewer(List<AnalyticsRelease> releases) {
        if (releases == null) {
            return;
        }
        if (releases.isEmpty()) {
            this.viewerLayout.topControl = this.emptyPart;
            this.viewerPart.layout();
            return;
        }
        if (this.viewer == null) {
            this.createReleasePart();
        } else {
            this.viewer.getTable().removeAll();
            this.viewer.setInput(releases);
            this.viewer.refresh();
        }
        this.viewerLayout.topControl = this.releaseCompositePart;
        this.viewerPart.layout();
    }

    private void createEmptyPart() {
        this.emptyPart = new Composite(this.viewerPart, 0);
        RowLayout rowLayout = new RowLayout();
        this.emptyPart.setLayout((Layout)rowLayout);
        Link link = new Link(this.emptyPart, 0);
        this.setFontStyle(link, 14, 0);
        link.setLayoutData((Object)new RowData());
        link.setText(ComposerIntegrationAnalyticsMessageConstants.LNK_RELEASE_EMPTY);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)ComposerIntegrationAnalyticsMessageConstants.LNK_CREATE_RELEASE_GUIDE);
            }
        });
    }

    private void createErrorPart() {
        this.errorPart = new Composite(this.viewerPart, 0);
        RowLayout rowLayout = new RowLayout();
        this.errorPart.setLayout((Layout)rowLayout);
        Label lblError = new Label(this.errorPart, 0);
        lblError.setLayoutData((Object)new RowData());
        this.setFontStyle(lblError, 16, 0);
        lblError.setText(ComposerIntegrationAnalyticsMessageConstants.MSG_ANALYTICS_CONNECTION_ERROR);
        lblError.setForeground(ColorUtil.LIGHT_RED);
    }

    private void createLoadingPart() {
        this.loadingPart = new Composite(this.viewerPart, 0);
        RowLayout rowLayout = new RowLayout();
        this.loadingPart.setLayout((Layout)rowLayout);
        Label lblLoading = new Label(this.loadingPart, 0);
        lblLoading.setLayoutData((Object)new RowData());
        this.setFontStyle(lblLoading, 16, 0);
        lblLoading.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_LOADING);
        lblLoading.setForeground(ColorUtil.LIGHT_GREEN);
    }

    private void createReleasePart() {
        this.releaseCompositePart = new Composite(this.viewerPart, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        this.releaseCompositePart.setLayout((Layout)gridLayout);
        TableLayout tableLayout = new TableLayout();
        this.viewer = new CTableViewer(this.releaseCompositePart, 67584);
        this.viewer.getTable().setLayout((Layout)tableLayout);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM/dd/yyyy");
        TableViewerColumn colStatus = new TableViewerColumn((TableViewer)this.viewer, 0);
        colStatus.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.RELEASE_STATUS);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        colStatus.setLabelProvider((CellLabelProvider)new TypeCheckedStyleCellLabelProvider<AnalyticsRelease>(0){

            protected Class<AnalyticsRelease> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsRelease element) {
                return null;
            }

            protected String getText(AnalyticsRelease element) {
                return element.isClosed() ? ComposerIntegrationAnalyticsMessageConstants.RELEASE_STATUS_CLOSED : ComposerIntegrationAnalyticsMessageConstants.RELEASE_STATUS_ACTIVE;
            }

            protected Color getForeground(Color foreground, AnalyticsRelease element) {
                Color active = Display.getCurrent().getSystemColor(6);
                Color closed = Display.getCurrent().getSystemColor(16);
                return element.isClosed() ? closed : active;
            }

            public String getToolTipText(Object element) {
                return ((AnalyticsRelease)element).isClosed() ? ComposerIntegrationAnalyticsMessageConstants.RELEASE_STATUS_CLOSED : ComposerIntegrationAnalyticsMessageConstants.RELEASE_STATUS_ACTIVE;
            }
        });
        TableViewerColumn colName = new TableViewerColumn((TableViewer)this.viewer, 0);
        colName.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.RELEASE_NAME);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(250));
        colName.setLabelProvider((CellLabelProvider)new HyperLinkColumnLabelProvider<AnalyticsRelease>(1){

            protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
                Program.launch((String)TestOpsUtil.getReleaseUrl((AnalyticsRelease)cell.getElement()));
            }

            protected Class<AnalyticsRelease> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsRelease element) {
                return null;
            }

            protected String getText(AnalyticsRelease element) {
                return element.getName();
            }

            public String getToolTipText(Object element) {
                return ((AnalyticsRelease)element).getName();
            }
        });
        TableViewerColumn colStartDate = new TableViewerColumn((TableViewer)this.viewer, 0);
        colStartDate.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.RELEASE_START_DATE);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        colStartDate.setLabelProvider((CellLabelProvider)new TypeCheckedStyleCellLabelProvider<AnalyticsRelease>(2){

            protected Class<AnalyticsRelease> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsRelease element) {
                return null;
            }

            protected String getText(AnalyticsRelease element) {
                if (element.getStartTime() == null) {
                    return "";
                }
                ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(element.getStartTime().toInstant(), ZoneId.systemDefault());
                return zonedDateTime.format(formatter);
            }

            public String getToolTipText(Object element) {
                AnalyticsRelease release = (AnalyticsRelease)element;
                if (release.getStartTime() == null) {
                    return "";
                }
                return ZonedDateTime.ofInstant(release.getStartTime().toInstant(), ZoneId.systemDefault()).format(formatter);
            }
        });
        TableViewerColumn colEndDate = new TableViewerColumn((TableViewer)this.viewer, 0);
        colEndDate.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.RELEASE_END_DATE);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        colEndDate.setLabelProvider((CellLabelProvider)new TypeCheckedStyleCellLabelProvider<AnalyticsRelease>(2){

            protected Class<AnalyticsRelease> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsRelease element) {
                return null;
            }

            protected String getText(AnalyticsRelease element) {
                if (element.getEndTime() == null) {
                    return "";
                }
                ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(element.getEndTime().toInstant(), ZoneId.systemDefault());
                return zonedDateTime.format(formatter);
            }

            public String getToolTipText(Object element) {
                AnalyticsRelease release = (AnalyticsRelease)element;
                if (release.getEndTime() == null) {
                    return "";
                }
                return ZonedDateTime.ofInstant(release.getEndTime().toInstant(), ZoneId.systemDefault()).format(formatter);
            }
        });
    }

    private void createHeaderPart() {
        Composite headerComposite = new Composite(this.parent, 0);
        GridLayout headerLayout = new GridLayout(2, true);
        headerComposite.setLayout((Layout)headerLayout);
        headerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblExecution = new Label(headerComposite, 0);
        lblExecution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        lblExecution.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_RELEASES);
        this.setFontStyle(lblExecution, 14, 1);
        Composite viewAllComposite = new Composite(headerComposite, 0);
        GridLayout viewAllLayout = new GridLayout(5, false);
        viewAllLayout.marginWidth = 0;
        viewAllLayout.marginHeight = 0;
        viewAllLayout.verticalSpacing = 0;
        viewAllLayout.horizontalSpacing = 0;
        viewAllComposite.setLayout((Layout)viewAllLayout);
        viewAllComposite.setLayoutData((Object)new GridData(3, 0x1000000, true, false));
        ToolBar toolBar = new ToolBar(viewAllComposite, 0x800000);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ToolItem item = new ToolItem(toolBar, 8);
        item.setToolTipText(AnalyticsStringConstants.REFRESH);
        item.setImage(ImageConstants.IMG_16_TESTOPS_REFRESH_NEW);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReleasePart.this.refresh();
            }
        });
        Label imgTestOps = new Label(viewAllComposite, 0);
        imgTestOps.setLayoutData((Object)new GridData(4, 4, true, true));
        imgTestOps.setImage(ImageConstants.IMG_16_KATALON_TESTOPS);
        Link lnkViewAll = new Link(viewAllComposite, 0);
        this.setFontStyle(lnkViewAll, 11, 0);
        String testOpsUrl = TestOpsUtil.getReleasesPageURL();
        lnkViewAll.setText(" <a href=\"" + testOpsUrl + "\">" + ComposerIntegrationAnalyticsMessageConstants.LNK_VIEW_ALL_RELEASES + "</a>");
        lnkViewAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)TestOpsUtil.getReleasesPageURL());
            }
        });
    }

    private List<AnalyticsRelease> getReleases() throws AnalyticsApiException {
        AnalyticsProject project = this.settingStore.getProject();
        return this.testOpsController.getFirstReleasesPage(project.getId());
    }

    private void setFontStyle(Label label, int fontSize, int style) {
        FontData[] fontData = label.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(fontSize);
            fontData[i].setStyle(style);
            ++i;
        }
        final Font newFont = new Font((Device)label.getDisplay(), fontData);
        label.setFont(newFont);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    private void setFontStyle(Link link, int fontSize, int style) {
        FontData[] fontData = link.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(fontSize);
            fontData[i].setStyle(style);
            ++i;
        }
        final Font newFont = new Font((Device)link.getDisplay(), fontData);
        link.setFont(newFont);
        link.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }
}

