/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.creators.AbstractProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.CategoryProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.FieldProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.IProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.MethodProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalFilter;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalProvider;
import org.codehaus.groovy.eclipse.codeassist.processors.ProposalProviderRegistry;
import org.codehaus.groovy.eclipse.codeassist.proposals.AbstractGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyFieldProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.trait.Traits;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class StatementAndExpressionCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    public static final Pattern FIELD_ACCESS_COMPLETION = Pattern.compile(".+\\.@\\s*(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)?", 32);
    public static final Pattern METHOD_POINTER_COMPLETION = Pattern.compile(".+(\\.&|::)\\s*(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)?", 32);
    private final ASTNode completionNode;
    private final ASTNode lhsNode;

    public StatementAndExpressionCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
        this.completionNode = context.getPerceivedCompletionNode();
        this.lhsNode = context.lhsNode;
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        ClassNode completionType;
        boolean isStatic;
        boolean isPrimary;
        ContentAssistContext context = this.getContext();
        TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(context.unit);
        ExpressionCompletionRequestor requestor = new ExpressionCompletionRequestor();
        AssistOptions options = new AssistOptions(this.getJavaContext().getProject().getOptions(true));
        if (this.completionNode != null) {
            visitor.visitCompilationUnit((ITypeRequestor)requestor);
        }
        List<IGroovyProposal> groovyProposals = new ArrayList<IGroovyProposal>(64);
        boolean bl = isPrimary = context.location == ContentAssistLocation.STATEMENT || context.location == ContentAssistLocation.METHOD_CONTEXT && StatementAndExpressionCompletionProcessor.isReceiverImplicit(context);
        if (requestor.visitSuccessful) {
            isStatic = requestor.isStatic;
            context.lhsType = requestor.lhsType;
            completionType = StatementAndExpressionCompletionProcessor.getCompletionType(this.completionNode, context, requestor);
            VariableScope currentScope = requestor.currentScope;
            List<IProposalCreator> creators = this.chooseProposalCreators(context, completionType);
            this.proposalCreatorOuterLoop(groovyProposals, creators, requestor, context, options, completionType, isStatic, isPrimary);
            requestor.currentScope = currentScope;
            if (isPrimary && context.lhsType != null && context.lhsType.isEnum() && !context.lhsType.equals((Object)completionType)) {
                List<IGroovyProposal> enumFields = new FieldProposalCreator().findAllProposals(context.lhsType, Collections.EMPTY_SET, context.getPerceivedCompletionExpression(), true, true);
                Iterator<IGroovyProposal> it = enumFields.iterator();
                while (it.hasNext()) {
                    GroovyFieldProposal proposal2 = (GroovyFieldProposal)it.next();
                    if (proposal2.getField().isEnum()) {
                        proposal2.setRequiredStaticImport(context.lhsType.getName() + "." + proposal2.getField().getName());
                        continue;
                    }
                    it.remove();
                }
                groovyProposals.addAll(enumFields);
            }
        } else {
            ImportNode importNode;
            isStatic = false;
            completionType = context.containingDeclaration instanceof ClassNode ? (ClassNode)context.containingDeclaration : context.unit.getModuleNode().getScriptClassDummy();
            AnnotatedNode node = context.containingDeclaration;
            Object containingClass = node instanceof ClassNode ? (ClassNode)node : (node instanceof MethodNode ? ((MethodNode)node).getDeclaringClass() : null);
            if (containingClass != null) {
                Set<IProposalCreator> creators = Collections.singleton(new CategoryProposalCreator());
                requestor.categories = new VariableScope(null, (ASTNode)context.unit.getModuleNode(), true).getCategoryNames();
                this.proposalCreatorInnerLoop(groovyProposals, creators, requestor, context, options, completionType, isStatic, isPrimary);
            } else if (node instanceof ImportNode && (importNode = (ImportNode)node).isStatic()) {
                containingClass = importNode.getType();
                groovyProposals.addAll(new FieldProposalCreator().findAllProposals((ClassNode)containingClass, Collections.EMPTY_SET, context.getPerceivedCompletionExpression(), true, isPrimary));
                groovyProposals.addAll(new MethodProposalCreator().findAllProposals((ClassNode)containingClass, Collections.EMPTY_SET, context.getPerceivedCompletionExpression(), true, isPrimary));
                groovyProposals.removeIf(proposal -> {
                    if (proposal instanceof AbstractGroovyProposal) {
                        int flags = ((AbstractGroovyProposal)proposal).getAssociatedNodeFlags();
                        return !Flags.isStatic((int)flags) || Flags.isPrivate((int)flags) || Flags.isSynthetic((int)flags);
                    }
                    return false;
                });
            }
        }
        try {
            context.currentScope = requestor.currentScope != null ? requestor.currentScope : StatementAndExpressionCompletionProcessor.createTopLevelScope(completionType);
            List<IProposalProvider> providers = ProposalProviderRegistry.getRegistry().getProvidersFor(context.unit);
            for (IProposalProvider provider : providers) {
                try {
                    List<IGroovyProposal> otherProposals = provider.getStatementAndExpressionProposals(context, completionType, isStatic, requestor.categories);
                    if (otherProposals == null || otherProposals.isEmpty()) continue;
                    groovyProposals.addAll(otherProposals);
                }
                catch (Exception e) {
                    GroovyContentAssist.logError("Exception when using third party proposal provider: " + provider.getClass().getCanonicalName(), e);
                }
            }
        }
        catch (CoreException e) {
            GroovyContentAssist.logError("Exception accessing proposal provider registry", e);
        }
        this.getContext().extend(this.getJavaContext().getCoreContext(), requestor.currentScope);
        try {
            List<IProposalFilter> filters = ProposalProviderRegistry.getRegistry().getFiltersFor(context.unit);
            for (IProposalFilter filter : filters) {
                try {
                    List<IGroovyProposal> newProposals = filter.filterProposals(groovyProposals, context, this.getJavaContext());
                    if (newProposals == null) continue;
                    groovyProposals = newProposals;
                }
                catch (Exception e) {
                    GroovyContentAssist.logError("Exception when using third party proposal filter: " + filter.getClass().getCanonicalName(), e);
                }
            }
        }
        catch (CoreException e) {
            GroovyContentAssist.logError("Exception accessing proposal provider registry", e);
        }
        return this.createJavaProposals(groovyProposals, options.checkDeprecation, monitor);
    }

    private List<IProposalCreator> chooseProposalCreators(ContentAssistContext context, ClassNode completionType) {
        if (FIELD_ACCESS_COMPLETION.matcher(context.fullCompletionExpression).matches() || context.containingCodeBlock instanceof AnnotationNode) {
            return Arrays.asList(new FieldProposalCreator());
        }
        if (METHOD_POINTER_COMPLETION.matcher(context.fullCompletionExpression).matches() || GeneralUtils.isOrImplements((ClassNode)completionType, (ClassNode)VariableScope.MAP_CLASS_NODE)) {
            return Arrays.asList(new MethodProposalCreator(), new CategoryProposalCreator());
        }
        return Arrays.asList(this.getProposalCreators());
    }

    private void proposalCreatorOuterLoop(Collection<IGroovyProposal> groovyProposals, Collection<IProposalCreator> creators, ExpressionCompletionRequestor requestor, ContentAssistContext context, AssistOptions options, ClassNode completionType, boolean isStatic, boolean isPrimary) {
        ClassNode enclosingType;
        boolean isStatic2;
        int closureStrategy = -1;
        if (isPrimary && requestor.currentScope.getEnclosingClosure() != null) {
            closureStrategy = requestor.currentScope.getEnclosingClosureResolveStrategy();
        }
        boolean isClass = StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType((ClassNode)completionType);
        boolean isStatic1 = isStatic && closureStrategy < 0;
        boolean bl = isStatic2 = !METHOD_POINTER_COMPLETION.matcher(context.fullCompletionExpression).matches();
        if (isClass) {
            ClassNode ofType = VariableScope.getFirstGenerics((ClassNode)completionType);
            if (!(context.completionNode instanceof ClassExpression) || !Traits.isTrait((ClassNode)ofType)) {
                this.proposalCreatorInnerLoop(groovyProposals, creators, requestor, context, options, ofType, isStatic2, isPrimary);
            }
        }
        if (!isClass || isStatic2 || !VariableScope.getFirstGenerics((ClassNode)completionType).equals((Object)VariableScope.CLASS_CLASS_NODE) && !VariableScope.getFirstGenerics((ClassNode)completionType).equals((Object)VariableScope.OBJECT_CLASS_NODE) && GroovyUtils.getGroovyVersion().getMajor() >= 4) {
            this.proposalCreatorInnerLoop(groovyProposals, creators, requestor, context, options, completionType, isStatic1, isPrimary);
        }
        if (closureStrategy >= 0 && (enclosingType = requestor.currentScope.getOwner()) != null) {
            ArrayList<IGroovyProposal> ownerProposals = new ArrayList<IGroovyProposal>();
            if (!enclosingType.equals((Object)completionType)) {
                this.proposalCreatorInnerLoop(ownerProposals, creators, requestor, context, options, enclosingType, isStatic, isPrimary);
            }
            if ((requestor.currentScope = (VariableScope)enclosingType.getNodeMetaData((Object)"outer.scope")) != null) {
                this.proposalCreatorOuterLoop(ownerProposals, creators, requestor, context, options, requestor.currentScope.getDelegate(), isStatic, isPrimary);
            }
            StatementAndExpressionCompletionProcessor.setClosureQualifiers(groovyProposals, ownerProposals, closureStrategy);
            groovyProposals.addAll(ownerProposals);
        }
    }

    private void proposalCreatorInnerLoop(Collection<IGroovyProposal> groovyProposals, Collection<IProposalCreator> creators, ExpressionCompletionRequestor requestor, ContentAssistContext context, AssistOptions options, ClassNode completionType, boolean isStatic, boolean isPrimary) {
        for (IProposalCreator creator : creators) {
            if (creator instanceof AbstractProposalCreator) {
                ((AbstractProposalCreator)creator).setCurrentScope(requestor.currentScope);
                ((AbstractProposalCreator)creator).setFavoriteStaticMembers(context.getFavoriteStaticMembers());
                ((AbstractProposalCreator)creator).setNameMatchingStrategy((pattern, candidate) -> ProposalUtils.matches(pattern, candidate, assistOptions.camelCaseMatch, assistOptions.subwordMatch));
            }
            String completionString = context.getPerceivedCompletionExpression();
            groovyProposals.addAll(creator.findAllProposals(completionType, requestor.categories, completionString, isStatic, isPrimary));
        }
    }

    private List<ICompletionProposal> createJavaProposals(Collection<IGroovyProposal> groovyProposals, boolean checkDeprecation, IProgressMonitor monitor) {
        ContentAssistContext context = this.getContext();
        JavaContentAssistInvocationContext javaContext = this.getJavaContext();
        CompletionRequestor completionRequestor = new CompletionRequestor(){

            public void accept(CompletionProposal proposal) {
            }
        };
        CompletionEngine engine = new CompletionEngine(this.getNameEnvironment(), completionRequestor, javaContext.getProject().getOptions(true), javaContext.getProject(), null, monitor);
        HashMap<String, List> javaProposals = new HashMap<String, List>(groovyProposals.size() * 3 / 2);
        for (IGroovyProposal groovyProposal : groovyProposals) {
            try {
                CompletionProposal proposal;
                IJavaCompletionProposal javaProposal = groovyProposal.createJavaProposal(engine, context, javaContext);
                if (javaProposal == null || checkDeprecation && (proposal = StatementAndExpressionCompletionProcessor.extractProposal((ICompletionProposal)javaProposal)) != null && Flags.isDeprecated((int)proposal.getFlags())) continue;
                String signature = StatementAndExpressionCompletionProcessor.getProposalSignature(javaProposal.getDisplayString());
                javaProposals.merge(signature, Collections.singletonList(javaProposal), (list, one) -> {
                    if (list.size() == 1) {
                        list = new ArrayList<IJavaCompletionProposal>((Collection<IJavaCompletionProposal>)list);
                    }
                    list.add((IJavaCompletionProposal)one.get(0));
                    return list;
                });
            }
            catch (Exception e) {
                GroovyContentAssist.logError("Exception when creating groovy completion proposal", e);
            }
        }
        ArrayList<ICompletionProposal> completionProposals = new ArrayList<ICompletionProposal>(javaProposals.size());
        for (List group : javaProposals.values()) {
            int n = group.size();
            if (n == 1) {
                completionProposals.add((ICompletionProposal)group.get(0));
                continue;
            }
            HashMap<String, IJavaCompletionProposal> map = new HashMap<String, IJavaCompletionProposal>();
            for (IJavaCompletionProposal jcp : group) {
                int i;
                String key = jcp.getDisplayString();
                int j = key.indexOf(32, i = key.indexOf(" - ") + 3);
                if (j < 0) {
                    j = key.length();
                }
                key = key.substring(i, j);
                map.merge(key, jcp, (one, two) -> one.getRelevance() > two.getRelevance() ? one : two);
            }
            if (map.size() > 1) {
                map.remove("DefaultGroovyMethods");
            }
            completionProposals.addAll(map.values());
        }
        return completionProposals;
    }

    private static void setClosureQualifiers(Collection<IGroovyProposal> delegateProposals, Collection<IGroovyProposal> ownerProposals, int resolveStrategy) {
        Set names;
        Function<IGroovyProposal, String> toName = p -> {
            AnnotatedNode node = ((AbstractGroovyProposal)p).getAssociatedNode();
            if (node instanceof FieldNode) {
                return ((FieldNode)node).getName();
            }
            if (node instanceof MethodNode) {
                return ((MethodNode)node).getName();
            }
            if (node instanceof PropertyNode) {
                return ((PropertyNode)node).getName();
            }
            throw new IllegalStateException("unexpected node type: " + String.valueOf(node.getClass()));
        };
        Predicate<IGroovyProposal> isQualified = p -> ((AbstractGroovyProposal)p).getRequiredQualifier() != null;
        BiConsumer<IGroovyProposal, String> addQualifier = (p, q) -> {
            if (isQualified.test((IGroovyProposal)p)) {
                q = (String)q + "." + ((AbstractGroovyProposal)p).getRequiredQualifier();
            }
            ((AbstractGroovyProposal)p).setRequiredQualifier((String)q);
        };
        Consumer<IGroovyProposal> reduceRelevance = p -> {
            AbstractGroovyProposal agp = (AbstractGroovyProposal)p;
            agp.setRelevanceMultiplier(agp.getRelevanceMultiplier() * 0.999f);
        };
        if (!delegateProposals.isEmpty()) {
            Consumer<IGroovyProposal> addDelegateQualifier = StatementAndExpressionCompletionProcessor.bind(addQualifier, "delegate");
            if (resolveStrategy == 0 && !ownerProposals.isEmpty()) {
                names = ownerProposals.stream().map(toName).collect(Collectors.toSet());
                delegateProposals.stream().filter(p -> names.contains(toName.apply((IGroovyProposal)p))).forEach(addDelegateQualifier.andThen(reduceRelevance));
            } else if (resolveStrategy == 4) {
                delegateProposals.forEach(addDelegateQualifier.andThen(reduceRelevance));
            }
        }
        if (!ownerProposals.isEmpty()) {
            Consumer<IGroovyProposal> addOwnerQualifier = StatementAndExpressionCompletionProcessor.bind(addQualifier, "owner");
            if (resolveStrategy == 1 && !delegateProposals.isEmpty()) {
                names = delegateProposals.stream().map(toName).collect(Collectors.toSet());
                ownerProposals.stream().filter(isQualified.or(p -> names.contains(toName.apply((IGroovyProposal)p)))).forEach(addOwnerQualifier.andThen(reduceRelevance));
            } else if (resolveStrategy == 4) {
                ownerProposals.forEach(addOwnerQualifier.andThen(reduceRelevance));
            } else {
                ownerProposals.stream().filter(isQualified).forEach(addOwnerQualifier);
            }
        }
    }

    private static ClassNode getCompletionType(ASTNode completionNode, ContentAssistContext context, ExpressionCompletionRequestor requestor) {
        ClassNode completionType;
        switch (context.location) {
            case EXPRESSION: {
                completionType = requestor.resultingType;
                break;
            }
            case METHOD_CONTEXT: {
                completionType = completionNode instanceof VariableExpression ? requestor.currentScope.getDelegateOrThis() : requestor.resultingType;
                break;
            }
            default: {
                completionType = requestor.currentScope.getDelegateOrThis();
                if (completionType != null) break;
                completionType = requestor.resultingType;
            }
        }
        if (completionType == null) {
            completionType = context.containingDeclaration instanceof ClassNode ? (ClassNode)context.containingDeclaration : context.unit.getModuleNode().getScriptClassDummy();
        }
        return completionType;
    }

    private static String getProposalSignature(String completionProposalDescription) {
        String sig = completionProposalDescription;
        int idx = sig.indexOf(" : ");
        if (idx != -1) {
            sig = sig.substring(0, idx);
        }
        if (sig.endsWith(")") && !sig.endsWith("()")) {
            String[] tokens = sig.split("[()]|, ");
            StringBuilder sb = new StringBuilder(tokens[0]).append('(');
            int i = 1;
            int n = tokens.length;
            while (i < n) {
                int j = tokens[i].indexOf(60);
                if (j < 0) {
                    j = tokens[i].lastIndexOf(32);
                    if (j < 0) {
                        j = tokens[i].length();
                    }
                    sb.append(tokens[i], 0, j);
                } else {
                    sb.append(tokens[i], 0, j);
                    j = tokens[i].lastIndexOf(62);
                    int k = tokens[i].indexOf(32, j);
                    if (k < 0) {
                        k = tokens[i].length();
                    }
                    sb.append(tokens[i], j + 1, k);
                }
                sb.append(',');
                ++i;
            }
            sb.setCharAt(sb.length() - 1, ')');
            sig = sb.toString();
        }
        return sig;
    }

    private static boolean isReceiverImplicit(ContentAssistContext methodContext) {
        if (methodContext.completionNode instanceof MethodCallExpression) {
            MethodCallExpression methodCall = (MethodCallExpression)methodContext.completionNode;
            return methodCall.isImplicitThis() && ExpressionUtils.isThisExpression((Expression)methodCall.getObjectExpression());
        }
        return methodContext.completionNode instanceof VariableExpression || methodContext.completionNode instanceof StaticMethodCallExpression;
    }

    private static VariableScope createTopLevelScope(ClassNode completionType) {
        return new VariableScope(null, (ASTNode)completionType, false);
    }

    private static <A, B> Consumer<A> bind(BiConsumer<A, B> consumer, B b) {
        return a -> consumer.accept(a, b);
    }

    private class ExpressionCompletionRequestor
    implements ITypeRequestor {
        private int derefCount;
        private boolean isStatic;
        private ClassNode lhsType;
        private ClassNode resultingType;
        private Set<ClassNode> categories;
        private Expression arrayAccessLHS;
        private VariableScope currentScope;
        private boolean visitSuccessful;

        private ExpressionCompletionRequestor() {
            ASTNode maybeLHS = StatementAndExpressionCompletionProcessor.this.getContext().getPerceivedCompletionNode();
            while (maybeLHS != null) {
                if (maybeLHS instanceof BinaryExpression) {
                    this.arrayAccessLHS = ((BinaryExpression)maybeLHS).getLeftExpression();
                    maybeLHS = this.arrayAccessLHS;
                    ++this.derefCount;
                    continue;
                }
                if (maybeLHS instanceof PropertyExpression) {
                    this.arrayAccessLHS = ((PropertyExpression)maybeLHS).getObjectExpression();
                    maybeLHS = ((PropertyExpression)maybeLHS).getProperty();
                    continue;
                }
                if (maybeLHS instanceof MethodCallExpression) {
                    this.arrayAccessLHS = ((MethodCallExpression)maybeLHS).getObjectExpression();
                    maybeLHS = ((MethodCallExpression)maybeLHS).getMethod();
                    continue;
                }
                if (maybeLHS instanceof Expression) {
                    this.arrayAccessLHS = (Expression)maybeLHS;
                }
                maybeLHS = null;
            }
        }

        public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
            if (!this.isInterestingElement(enclosingElement)) {
                return ITypeRequestor.VisitStatus.CANCEL_MEMBER;
            }
            if (node instanceof ClassNode) {
                if (GroovyUtils.isScript((ClassNode)((ClassNode)node))) {
                    return ITypeRequestor.VisitStatus.CONTINUE;
                }
            } else if (node instanceof MethodNode && !(node instanceof ConstructorNode)) {
                if (((MethodNode)node).isScriptBody()) {
                    return ITypeRequestor.VisitStatus.CONTINUE;
                }
            } else if (node == StatementAndExpressionCompletionProcessor.this.lhsNode && result.confidence != TypeLookupResult.TypeConfidence.UNKNOWN) {
                if (result.declaration instanceof MethodNode) {
                    MethodNode meth = (MethodNode)result.declaration;
                    if (AccessorSupport.SETTER.isAccessorKind(meth, false)) {
                        this.lhsType = meth.getParameters()[0].getType();
                    }
                } else {
                    this.lhsType = result.type;
                }
                if (VariableScope.OBJECT_CLASS_NODE.equals((Object)this.lhsType)) {
                    this.lhsType = null;
                }
            }
            boolean derefList = false;
            boolean success = this.doTest(node);
            if (!success) {
                success = derefList = this.doTestForAfterArrayAccess(node);
            }
            if (success) {
                this.visitSuccessful = true;
                this.currentScope = result.scope;
                this.maybeRememberTypeOfLHS(result);
                this.setResultingType(result, derefList);
                this.categories = result.scope.getCategoryNames();
                this.isStatic = StatementAndExpressionCompletionProcessor.this.getContext().containingCodeBlock instanceof AnnotationNode || node instanceof ClassExpression && !VariableScope.CLASS_CLASS_NODE.equals((Object)this.resultingType) || node instanceof StaticMethodCallExpression && StatementAndExpressionCompletionProcessor.this.getContext().location != ContentAssistLocation.EXPRESSION;
                return ITypeRequestor.VisitStatus.STOP_VISIT;
            }
            return ITypeRequestor.VisitStatus.CONTINUE;
        }

        private void setResultingType(TypeLookupResult result, boolean derefList) {
            ASTNode enclosing;
            ContentAssistContext context = StatementAndExpressionCompletionProcessor.this.getContext();
            this.resultingType = context.location == ContentAssistLocation.METHOD_CONTEXT ? (result.receiverType != null ? result.receiverType : result.declaringType) : (result.declaration == null && result.declaringType != null ? result.declaringType : result.type);
            if (derefList) {
                int i = 0;
                while (i < this.derefCount) {
                    boolean getAtFound = false;
                    List getAts = this.resultingType.getMethods("getAt");
                    for (MethodNode getAt : getAts) {
                        if (getAt.getParameters() == null || getAt.getParameters().length != 1) continue;
                        this.resultingType = getAt.getReturnType();
                        getAtFound = true;
                    }
                    if (!getAtFound) {
                        if (VariableScope.MAP_CLASS_NODE.equals((Object)this.resultingType)) {
                            this.resultingType = this.resultingType.getGenericsTypes()[1].getType();
                        } else {
                            int j = 0;
                            while (j < this.derefCount) {
                                this.resultingType = VariableScope.extractElementType((ClassNode)this.resultingType);
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
            if ((enclosing = result.scope.getEnclosingNode()) instanceof PropertyExpression) {
                if (((PropertyExpression)enclosing).getObjectExpression() instanceof MethodPointerExpression) {
                    this.resultingType = result.declaringType;
                } else if (((PropertyExpression)enclosing).isSpreadSafe()) {
                    this.resultingType = VariableScope.extractSpreadType((ClassNode)this.resultingType);
                }
            } else if (enclosing instanceof MethodCallExpression && ((MethodCallExpression)enclosing).isSpreadSafe()) {
                this.resultingType = VariableScope.extractSpreadType((ClassNode)this.resultingType);
            }
            this.resultingType = GroovyUtils.getWrapperTypeIfPrimitive((ClassNode)this.resultingType);
        }

        private boolean doTestForAfterArrayAccess(ASTNode node) {
            return node == this.arrayAccessLHS;
        }

        private void maybeRememberTypeOfLHS(TypeLookupResult result) {
            if (this.isAssignmentOfLHS(result.enclosingAssignment)) {
                if (StatementAndExpressionCompletionProcessor.this.lhsNode instanceof Variable) {
                    Variable variable = (Variable)StatementAndExpressionCompletionProcessor.this.lhsNode;
                    this.lhsType = Optional.ofNullable(result.scope.lookupName(variable.getName())).map(info -> info.type).orElse(variable.getType());
                } else if (StatementAndExpressionCompletionProcessor.this.lhsNode instanceof PropertyExpression) {
                    this.lhsType = ((PropertyExpression)StatementAndExpressionCompletionProcessor.this.lhsNode).getProperty().getType();
                }
            } else {
                ASTNode enclosingBlock;
                VariableScope.CallAndType cat = result.scope.getEnclosingMethodCallExpression();
                if (cat != null && cat.declaration instanceof MethodNode) {
                    Parameter[] params = ((MethodNode)cat.declaration).getParameters();
                    int paramIndex = this.getParameterPosition(result.declaration, cat.call);
                    if (paramIndex != -1 && params.length > 0) {
                        this.lhsType = params[Math.min(paramIndex, params.length - 1)].getType();
                        if (this.lhsType.isArray() && paramIndex >= params.length - 1) {
                            this.lhsType = this.lhsType.getComponentType();
                        }
                    }
                }
                if ((enclosingBlock = StatementAndExpressionCompletionProcessor.this.getContext().containingCodeBlock) instanceof AnnotationNode && StatementAndExpressionCompletionProcessor.this.lhsNode instanceof Variable) {
                    ClassNode annotation = ((AnnotationNode)enclosingBlock).getClassNode();
                    MethodNode attribute = annotation.getMethod(((Variable)StatementAndExpressionCompletionProcessor.this.lhsNode).getName(), Parameter.EMPTY_ARRAY);
                    this.lhsType = attribute.getReturnType();
                }
            }
            if (VariableScope.OBJECT_CLASS_NODE.equals((Object)this.lhsType)) {
                this.lhsType = null;
            }
        }

        private boolean isAssignmentOfLHS(BinaryExpression node) {
            if (node != null && StatementAndExpressionCompletionProcessor.this.lhsNode != null) {
                Expression expression = node.getLeftExpression();
                return expression == StatementAndExpressionCompletionProcessor.this.lhsNode || expression.getClass() == StatementAndExpressionCompletionProcessor.this.lhsNode.getClass() && expression.getStart() == StatementAndExpressionCompletionProcessor.this.lhsNode.getStart() && expression.getEnd() == StatementAndExpressionCompletionProcessor.this.lhsNode.getEnd();
            }
            return false;
        }

        private int getParameterPosition(ASTNode argumentCandidate, MethodCall methodCall) {
            if (methodCall != null && methodCall.getArguments() instanceof TupleExpression) {
                int paramIndex = -1;
                for (Expression argument : (TupleExpression)methodCall.getArguments()) {
                    ++paramIndex;
                    if (argument != argumentCandidate) continue;
                    return paramIndex;
                }
            }
            return -1;
        }

        private boolean doTest(ASTNode node) {
            if (node instanceof PropertyExpression || node instanceof TupleExpression) {
                return false;
            }
            if (node instanceof BinaryExpression && ((BinaryExpression)node).getLeftExpression() == this.arrayAccessLHS) {
                return false;
            }
            boolean rangeMatch = false;
            if (StatementAndExpressionCompletionProcessor.this.completionNode != null) {
                boolean bl = rangeMatch = StatementAndExpressionCompletionProcessor.this.completionNode.getStart() == node.getStart() && StatementAndExpressionCompletionProcessor.this.completionNode.getEnd() == node.getEnd();
            }
            return rangeMatch && this.isNotExpressionAndStatement(StatementAndExpressionCompletionProcessor.this.completionNode, node);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isInterestingElement(IJavaElement enclosingElement) {
            try {
                ISourceRange range;
                switch (enclosingElement.getElementType()) {
                    case 8: {
                        if (!"Qjava.lang.Object;".equals(((IField)enclosingElement).getTypeSignature())) break;
                        return true;
                    }
                    case 9: {
                        if (!this.isInitializerMethod((IMethod)enclosingElement)) break;
                        return true;
                    }
                    case 10: {
                        return true;
                    }
                }
                if (!(enclosingElement instanceof ISourceReference) || (range = ((ISourceReference)enclosingElement).getSourceRange()).getOffset() > StatementAndExpressionCompletionProcessor.this.completionNode.getStart() || range.getOffset() + range.getLength() < StatementAndExpressionCompletionProcessor.this.completionNode.getEnd()) return false;
                return true;
            }
            catch (JavaModelException e) {
                GroovyContentAssist.logError(e);
            }
            return false;
        }

        private boolean isInitializerMethod(IMethod method) throws JavaModelException {
            if (method.isConstructor()) {
                return true;
            }
            if (!Flags.isStatic((int)method.getFlags())) {
                IAnnotation[] iAnnotationArray = method.getAnnotations();
                int n = iAnnotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotation annotation = iAnnotationArray[n2];
                    String name = annotation.getElementName();
                    if (name.endsWith("PostConstruct")) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        private boolean isNotExpressionAndStatement(ASTNode thisNode, ASTNode thatNode) {
            if (thisNode instanceof Expression) {
                return !(thatNode instanceof Statement);
            }
            if (thisNode instanceof Statement) {
                return !(thatNode instanceof Expression);
            }
            return true;
        }
    }
}

