/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.WebDriverCleanerUtil;
import com.kms.katalon.execution.webui.configuration.WebDriverManagerRunConfiguration;
import com.kms.katalon.execution.webui.driver.SeleniumWebDriverProvider;
import java.io.File;
import java.io.IOException;

public class DriverDownloadManager {
    public static void downloadDriver(WebUIDriverType typeDriver) throws InterruptedException, IOException {
        DriverDownloadManager.downloadDriver(typeDriver, null, null);
    }

    public static void downloadDriver(WebUIDriverType typeDriver, File logFile, File errorLogFile) throws InterruptedException, IOException {
        switch (typeDriver) {
            case CHROME_DRIVER: {
                WebDriverCleanerUtil.cleanup();
                String chromeDriverPath = SeleniumWebDriverProvider.getChromeDriverPath();
                WebDriverManagerRunConfiguration webDriverManagerRunConfiguration = new WebDriverManagerRunConfiguration();
                webDriverManagerRunConfiguration.setLogFile(logFile);
                webDriverManagerRunConfiguration.setErrorLogFile(errorLogFile);
                webDriverManagerRunConfiguration.downloadDriver(WebUIDriverType.CHROME_DRIVER, new File(chromeDriverPath).getParentFile());
                break;
            }
            case FIREFOX_DRIVER: {
                WebDriverCleanerUtil.cleanup();
                String firefoxDriverPath = SeleniumWebDriverProvider.getGeckoDriverPath();
                WebDriverManagerRunConfiguration webDriverManagerRunConfiguration = new WebDriverManagerRunConfiguration();
                webDriverManagerRunConfiguration.setLogFile(logFile);
                webDriverManagerRunConfiguration.setErrorLogFile(errorLogFile);
                webDriverManagerRunConfiguration.downloadDriver(WebUIDriverType.FIREFOX_DRIVER, new File(firefoxDriverPath).getParentFile());
                break;
            }
            case EDGE_CHROMIUM_DRIVER: {
                WebDriverCleanerUtil.cleanup();
                String edgeChromiumDriverPath = SeleniumWebDriverProvider.getEdgeChromiumDriverPath();
                WebDriverManagerRunConfiguration webDriverManagerRunConfiguration = new WebDriverManagerRunConfiguration();
                webDriverManagerRunConfiguration.setLogFile(logFile);
                webDriverManagerRunConfiguration.setErrorLogFile(errorLogFile);
                webDriverManagerRunConfiguration.downloadDriver(WebUIDriverType.EDGE_CHROMIUM_DRIVER, new File(edgeChromiumDriverPath).getParentFile());
                break;
            }
        }
    }
}

