/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.ai.core.constant.StudioAssistErrorEnum;
import com.kms.katalon.ai.core.dto.StudioAssistChatAskQuestionRequest;
import com.kms.katalon.ai.core.dto.StudioAssistChatAskQuestionResponse;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistChatAskQuestionHandler
extends CustomHttpHandler {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatAskQuestionHandler.class);
    @Inject
    private IEventBroker eventBroker;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        try {
            StudioAssistChatAskQuestionRequest request = (StudioAssistChatAskQuestionRequest)JsonUtil.fromJson((String)"EEE MMM dd HH:mm:ss zzz yyyy", (String)req.getRequestDataAsString(), StudioAssistChatAskQuestionRequest.class);
            if (!this.validate(req, request)) {
                this.logger.debug("validate failed | request = %s".formatted(JsonUtil.toJson((Object)request)));
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)request.getQuestionId())) {
                request.setRetrying(true);
            } else {
                request.setQuestionId(UUID.randomUUID().toString());
            }
            this.eventBroker.post("ON_CHAT_ASK_QUESTION", (Object)request);
            StudioAssistChatAskQuestionResponse response = new StudioAssistChatAskQuestionResponse(request.getConversationId(), request.getQuestionId(), null, null, null);
            req.send(response);
        }
        catch (Exception e) {
            this.logger.error("%s | %s | %s".formatted("Exception while handle ask question", req.getRequestDataAsString(), e.getMessage()), (Throwable)e);
            StudioAssistChatAskQuestionResponse response = new StudioAssistChatAskQuestionResponse(null, null, null, StudioAssistErrorEnum.INLINE_GENERAL_ERROR.getCode(), StudioAssistErrorEnum.INLINE_GENERAL_ERROR.getMessage());
            req.send(response);
        }
    }

    private boolean validate(CustomRequest req, StudioAssistChatAskQuestionRequest request) throws IOException {
        if (request == null || StringUtils.isBlank((CharSequence)request.getConversationId()) || StringUtils.isBlank((CharSequence)request.getQuestionContent())) {
            req.sendResponseHeaders(400, -1);
            return false;
        }
        return true;
    }
}

