/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.agent;

import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.McpClient;
import com.kms.katalon.ai.core.model.agent.McpServerConnectionStatus;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatItem;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatQuestionMessage;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentSession {
    private static final Logger logger = LoggerFactory.getLogger(AgentSession.class);
    private static final int EXPAND_STEP_CHAT_HISTORY_QUEUE_CAPACITY = 20;
    private List<McpClient> mcpClients = new ArrayList<McpClient>();
    private AgentConversation conversation = new AgentConversation();

    public List<McpClient> getMcpClients() {
        return this.mcpClients;
    }

    public void addMcpClient(McpClient client) {
        this.mcpClients.add(client);
    }

    public void setMcpClients(List<McpClient> mcpClient) {
        this.mcpClients = mcpClient;
    }

    public AgentConversation getConversation() {
        return this.conversation;
    }

    public void setConversation(AgentConversation conversation) {
        this.conversation = conversation;
    }

    public McpClient getMcpClient(String server) {
        return this.mcpClients.stream().filter(s -> server.equals(s.getServer())).findFirst().orElse(null);
    }

    public McpClient getMcpClientByOAuthState(String oauthState) {
        return this.mcpClients.stream().filter(mcpClient -> mcpClient.getStatus() == McpServerConnectionStatus.UNAUTHORIZED).filter(mcpClient -> mcpClient.getAuthorization() != null).filter(mcpClient -> mcpClient.getAuthorization().getRequests().containsKey(oauthState)).findFirst().orElse(null);
    }

    public StudioAssistChatPair appendAgentChatItem(StudioAssistChatQuestionMessage question, boolean isGoodQuestion) {
        if (!StringUtils.equals((CharSequence)this.conversation.getConversationId(), (CharSequence)question.getConversationId())) {
            return null;
        }
        AgentMessage response = new AgentMessage(question.getQuestionMsgId(), question.getConversationId());
        StudioAssistChatPair chatItem = new StudioAssistChatPair(question, response, null, isGoodQuestion);
        ArrayBlockingQueue<StudioAssistChatItem> chatHistory = this.conversation.getChatHistory();
        if (chatHistory.remainingCapacity() == 0) {
            this.conversation.increaseQueueSize(20, true);
        }
        String currentQuestionId = chatItem.getQuestion().getQuestionMsgId();
        if (this.conversation.getChatHistory().stream().anyMatch(item -> {
            StudioAssistChatPair pair;
            return item instanceof StudioAssistChatPair && (pair = (StudioAssistChatPair)item).getQuestion().getQuestionMsgId().equals(currentQuestionId);
        })) {
            return null;
        }
        this.handleAttachments(chatItem);
        if (!this.conversation.addChatItemIntoHistory(chatItem)) {
            logger.error("The chat history capacity reached");
        }
        logger.trace("after appendToConversation -> " + JsonUtil.toJson((Object)this.conversation));
        return chatItem;
    }

    private void handleAttachments(StudioAssistChatPair pair) {
        StudioAssistChatQuestionMessage question = pair.getQuestion();
        if (question == null) {
            return;
        }
        List<StudioAssistChatAttachment> attachments = question.getAttachments();
        if (attachments == null || attachments.isEmpty()) {
            return;
        }
        ArrayList uploadedAttachments = this.conversation.getChatHistory().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> ((StudioAssistChatPair)item).getQuestion()).map(StudioAssistChatQuestionMessage::getAttachments).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
        if (uploadedAttachments.isEmpty()) {
            return;
        }
        attachments = attachments.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getFilePath())).filter(item -> uploadedAttachments.stream().filter(uploadedAttachment -> uploadedAttachment.getFilePath().equals(item.getFilePath()) && item.getDateModified().equals(uploadedAttachment.getDateModified())).findAny().isEmpty()).toList();
        pair.getQuestion().setAttachments(attachments);
    }
}

