/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.Time;

public class SimplePlayerApplet
extends Applet
implements ControllerListener {
    Player player = null;
    Component visualComponent = null;
    Component controlComponent = null;
    Component progressBar = null;
    boolean firstTime = true;
    long CachingSize = 0L;
    Panel panel = null;
    int controlPanelHeight = 0;
    int videoWidth = 0;
    int videoHeight = 0;

    public void init() {
        this.setLayout(null);
        this.panel = new Panel();
        this.panel.setLayout(null);
        this.add(this.panel);
        this.panel.setBounds(0, 0, 320, 240);
        String mediaFile = null;
        MediaLocator mrl = null;
        URL url = null;
        mediaFile = this.getParameter("FILE");
        if (mediaFile == null) {
            this.Fatal("Invalid media file parameter");
        }
        try {
            url = new URL(this.getDocumentBase(), mediaFile);
            mediaFile = url.toExternalForm();
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        try {
            mrl = new MediaLocator(mediaFile);
            if (mrl == null) {
                this.Fatal("Can't build URL for " + mediaFile);
            }
            try {
                this.player = Manager.createPlayer(mrl);
            }
            catch (NoPlayerException e2) {
                System.out.println(e2);
                this.Fatal("Could not create player for " + mrl);
            }
            this.player.addControllerListener(this);
        }
        catch (MalformedURLException e3) {
            this.Fatal("Invalid media file URL!");
        }
        catch (IOException e4) {
            this.Fatal("IO exception creating player for " + mrl);
        }
    }

    public void start() {
        if (this.player != null) {
            this.player.start();
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
            this.player.deallocate();
        }
    }

    public void destroy() {
        this.player.close();
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
        if (this.player == null) {
            return;
        }
        if (event instanceof RealizeCompleteEvent) {
            if (this.progressBar != null) {
                this.panel.remove(this.progressBar);
                this.progressBar = null;
            }
            int width = 320;
            int height = 0;
            if (this.controlComponent == null && (this.controlComponent = this.player.getControlPanelComponent()) != null) {
                this.controlPanelHeight = this.controlComponent.getPreferredSize().height;
                this.panel.add(this.controlComponent);
                height += this.controlPanelHeight;
            }
            if (this.visualComponent == null && (this.visualComponent = this.player.getVisualComponent()) != null) {
                this.panel.add(this.visualComponent);
                Dimension videoSize = this.visualComponent.getPreferredSize();
                this.videoWidth = videoSize.width;
                this.videoHeight = videoSize.height;
                width = this.videoWidth;
                height += this.videoHeight;
                this.visualComponent.setBounds(0, 0, this.videoWidth, this.videoHeight);
            }
            this.panel.setBounds(0, 0, width, height);
            if (this.controlComponent != null) {
                this.controlComponent.setBounds(0, this.videoHeight, width, this.controlPanelHeight);
                this.controlComponent.invalidate();
            }
        } else if (event instanceof CachingControlEvent) {
            if (this.player.getState() > 200) {
                return;
            }
            CachingControlEvent e2 = (CachingControlEvent)event;
            CachingControl cc = e2.getCachingControl();
            if (this.progressBar == null && (this.progressBar = cc.getControlComponent()) != null) {
                this.panel.add(this.progressBar);
                this.panel.setSize(this.progressBar.getPreferredSize());
                this.validate();
            }
        } else if (event instanceof EndOfMediaEvent) {
            this.player.setMediaTime(new Time(0L));
            this.player.start();
        } else if (event instanceof ControllerErrorEvent) {
            this.player = null;
            this.Fatal(((ControllerErrorEvent)event).getMessage());
        } else if (event instanceof ControllerClosedEvent) {
            this.panel.removeAll();
        }
    }

    void Fatal(String s2) {
        System.err.println("FATAL ERROR: " + s2);
        throw new Error(s2);
    }
}

