/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UDPPacketReceiver
implements PacketSource {
    private DatagramSocket sock;
    private int maxsize;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    byte[] dataBuf = new byte[1];

    public DatagramSocket getSocket() {
        return this.sock;
    }

    public UDPPacketReceiver(DatagramSocket sock, int maxsize) {
        this.sock = sock;
        this.maxsize = maxsize;
        try {
            sock.setSoTimeout(5000);
        }
        catch (SocketException e2) {
            System.out.println("could not set timeout on socket");
        }
    }

    public UDPPacketReceiver(int localPort, String localAddress, int remotePort, String remoteAddress, int maxsize, DatagramSocket localSocket) throws SocketException, UnknownHostException, IOException {
        InetAddress localInetAddr = InetAddress.getByName(localAddress);
        InetAddress remoteInetAddr = InetAddress.getByName(remoteAddress);
        if (remoteInetAddr.isMulticastAddress()) {
            MulticastSocket sock = new MulticastSocket(remotePort);
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 512);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable e2) {
                    jmfSecurity.permissionFailureNotification(512);
                }
            }
            sock.joinGroup(remoteInetAddr);
            this.sock = sock;
            this.maxsize = maxsize;
        } else {
            this.sock = localSocket != null ? localSocket : new DatagramSocket(localPort, localInetAddr);
            if (remoteAddress != null) {
                // empty if block
            }
            this.maxsize = maxsize;
        }
        try {
            this.sock.setSoTimeout(5000);
        }
        catch (SocketException e3) {
            System.out.println("could not set timeout on socket");
        }
    }

    public Packet receiveFrom() throws IOException {
        DatagramPacket dp;
        int len;
        do {
            if (this.dataBuf.length < this.maxsize) {
                this.dataBuf = new byte[this.maxsize];
            }
            dp = new DatagramPacket(this.dataBuf, this.maxsize);
            this.sock.receive(dp);
            len = dp.getLength();
            if (len <= this.maxsize >> 1) continue;
            this.maxsize = len << 1;
        } while (len >= dp.getData().length);
        UDPPacket p = new UDPPacket();
        p.receiptTime = System.currentTimeMillis();
        p.data = dp.getData();
        p.offset = 0;
        p.length = len;
        p.datagrampacket = dp;
        p.localPort = this.sock.getLocalPort();
        p.remotePort = dp.getPort();
        p.remoteAddress = dp.getAddress();
        return p;
    }

    public void closeSource() {
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    public String sourceString() {
        String s2 = "UDP Datagram Packet Receiver on port " + this.sock.getLocalPort() + "on local address " + this.sock.getLocalAddress();
        return s2;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

