/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.ASTNodeFinder;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTTools;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GroovyQuickAssistContext {
    private final IInvocationContext context;
    private ASTNodeFinder finder;
    private ASTNode coveredNode;

    public GroovyQuickAssistContext(IInvocationContext context) {
        Assert.isNotNull((Object)context);
        this.context = context;
    }

    public GroovyCompilationUnit getCompilationUnit() {
        return (GroovyCompilationUnit)this.context.getCompilationUnit();
    }

    public <T extends ITypeRequestor> T visitCompilationUnit(T requestor) {
        TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(this.getCompilationUnit());
        visitor.visitCompilationUnit(requestor);
        return requestor;
    }

    public ASTNode getCoveredNode() {
        if (this.finder == null) {
            Region region = new Region(this.getSelectionOffset(), this.getSelectionLength());
            this.finder = new ASTNodeFinder(region){

                public void visitGStringExpression(GStringExpression expr) {
                    this.visitExpressions(expr.getValues());
                    this.check((ASTNode)expr);
                }
            };
            this.coveredNode = this.finder.doVisit(this.getCompilationUnit().getModuleNode());
        }
        return this.coveredNode;
    }

    public String getLineDelimiter(IDocument document, int line) {
        if (document == null) {
            document = this.newTempDocument();
        }
        String ending = null;
        try {
            while ((ending = document.getLineDelimiter(line)) == null && line > 1) {
                --line;
            }
        }
        catch (BadLocationException badLocationException) {}
        return ending != null ? ending : ASTTools.getLineDelimeter((CompilationUnit)this.getCompilationUnit());
    }

    public String getNodeText(ASTNode node) {
        char[] contents;
        int offset = node.getStart();
        int length = node.getLength();
        if (offset >= 0 && length > 0 && (contents = this.getCompilationUnit().getContents()) != null && contents.length >= offset + length) {
            return String.valueOf(contents, offset, length);
        }
        return null;
    }

    public TypeLookupResult getNodeType(ASTNode node) {
        TypeLookupResult[] ref = new TypeLookupResult[]{new TypeLookupResult(null, null, node, TypeLookupResult.TypeConfidence.UNKNOWN, null)};
        this.visitCompilationUnit((n, r, e) -> {
            if (n == node) {
                typeLookupResultArray[0] = r;
                return ITypeRequestor.VisitStatus.STOP_VISIT;
            }
            return ITypeRequestor.VisitStatus.CONTINUE;
        });
        return ref[0];
    }

    public int getSelectionOffset() {
        return this.context.getSelectionOffset();
    }

    public int getSelectionLength() {
        return this.context.getSelectionLength();
    }

    public IProject getProject() {
        return this.context.getCompilationUnit().getResource().getProject();
    }

    public Shell getShell() {
        Shell shell = null;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null && ((shell = display.getActiveShell()) == null || shell.isDisposed())) {
            Shell[] shellArray = display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell sh = shellArray[n2];
                if (sh != null && !sh.isDisposed()) {
                    shell = sh;
                    break;
                }
                ++n2;
            }
        }
        return shell;
    }

    public IDocument newTempDocument() {
        return new Document(String.valueOf(this.getCompilationUnit().getContents()));
    }
}

