/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.driver;

import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class SeleniumWebDriverProvider {
    private static final String DRIVERS_FOLDER_NAME = "resources" + File.separator + "drivers";

    public static File getTempDriverDirectory() throws IOException {
        return new File(ClassPathResolver.getConfigurationFolder(), "resources/temp/webdriver");
    }

    public static File getDriverDirectory() throws IOException {
        block16: {
            Bundle bundleExec = Platform.getBundle((String)"com.kms.katalon.core.webui");
            File bundleFile = FileLocator.getBundleFile((Bundle)bundleExec);
            if (!bundleFile.isDirectory()) break block16;
            String osResourcesFolderName = "";
            switch (Platform.getOS()) {
                case "win32": {
                    if (Platform.getOSArch().equals("x86_64")) {
                        osResourcesFolderName = "win64";
                        break;
                    }
                    osResourcesFolderName = "win32";
                    break;
                }
                case "linux": {
                    if (Platform.getOSArch().equals("x86_64")) {
                        osResourcesFolderName = "linux64";
                        break;
                    }
                    if (Platform.getOSArch().equals("aarch64")) {
                        osResourcesFolderName = "linux_arm";
                        break;
                    }
                    osResourcesFolderName = "linux32";
                    break;
                }
                case "macosx": {
                    osResourcesFolderName = Platform.getOSArch().equals("aarch64") ? "macos_arm" : "macos_x86";
                }
            }
            return new File(String.valueOf(bundleFile) + File.separator + "os_resources" + File.separator + osResourcesFolderName + File.separator + DRIVERS_FOLDER_NAME);
        }
        return new File(String.valueOf(ClassPathResolver.getConfigurationFolder()) + File.separator + DRIVERS_FOLDER_NAME);
    }

    private static void makeFileExecutable(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists() && file.isFile()) {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                PosixFilePermission[] posixFilePermissionArray = PosixFilePermission.values();
                int n = posixFilePermissionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PosixFilePermission permission = posixFilePermissionArray[n2];
                    perms.add(permission);
                    ++n2;
                }
                Files.setPosixFilePermissions(file.toPath(), perms);
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    public static String getTempChromeDriverPath() throws IOException {
        File parentFolder = SeleniumWebDriverProvider.getTempDriverDirectory();
        switch (Platform.getOS()) {
            case "win32": {
                return new File(parentFolder, "chromedriver.exe").getAbsolutePath();
            }
        }
        return new File(parentFolder, "chromedriver").getAbsolutePath();
    }

    public static String getChromeDriverPath() {
        try {
            switch (Platform.getOS()) {
                case "win32": {
                    return SeleniumWebDriverProvider.getChromeDriverPathForWindows();
                }
                case "linux": {
                    return SeleniumWebDriverProvider.getChromeDriverPathForLinux();
                }
                case "macosx": {
                    return SeleniumWebDriverProvider.getChromeDriverPathForMac();
                }
            }
        }
        catch (IOException iOException) {}
        return "";
    }

    private static String getChromeDriverPathForLinux() throws IOException {
        String chromeDriverPath = SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath() + File.separator;
        chromeDriverPath = Platform.getOSArch().equals("x86_64") ? chromeDriverPath + "chromedriver_linux64" + File.separator + "chromedriver" : (Platform.getOSArch().equals("aarch64") ? chromeDriverPath + "chromedriver_linux_arm" + File.separator + "chromedriver" : chromeDriverPath + "chromedriver_linux32" + File.separator + "chromedriver");
        SeleniumWebDriverProvider.makeFileExecutable(chromeDriverPath);
        return chromeDriverPath;
    }

    private static String getChromeDriverPathForWindows() throws IOException {
        return SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath() + File.separator + "chromedriver_win32" + File.separator + "chromedriver.exe";
    }

    private static String getChromeDriverPathForMac() throws IOException {
        String chromeDriverPath = SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath() + File.separator + "chromedriver_mac" + File.separator + "chromedriver";
        SeleniumWebDriverProvider.makeFileExecutable(chromeDriverPath);
        return chromeDriverPath;
    }

    public static String getEdgeChromiumDriverPath() {
        try {
            switch (Platform.getOS()) {
                case "win32": {
                    return SeleniumWebDriverProvider.getEdgeChromiumDriverPathForWindows();
                }
                case "macosx": {
                    return SeleniumWebDriverProvider.getEdgeChromiumDriverPathForMac();
                }
                case "linux": {
                    return SeleniumWebDriverProvider.getEdgeChromiumDriverPathForLinux();
                }
            }
        }
        catch (IOException iOException) {}
        return "";
    }

    private static String getEdgeChromiumDriverPathForWindows() throws IOException {
        String driverPath = SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath() + File.separator;
        driverPath = Platform.getOSArch().equals("x86_64") ? driverPath + "edgechromium_win64" + File.separator + "msedgedriver.exe" : driverPath + "edgechromium_win32" + File.separator + "msedgedriver.exe";
        return driverPath;
    }

    private static String getEdgeChromiumDriverPathForMac() throws IOException {
        String driverPath = SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath() + File.separator + "edgechromium_mac" + File.separator + "msedgedriver";
        SeleniumWebDriverProvider.makeFileExecutable(driverPath);
        return driverPath;
    }

    private static String getEdgeChromiumDriverPathForLinux() throws IOException {
        String driverPath = SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath() + File.separator;
        driverPath = driverPath + "edgechromium_linux64" + File.separator + "msedgedriver";
        SeleniumWebDriverProvider.makeFileExecutable(driverPath);
        return driverPath;
    }

    public static String getTempEdgeChromiumDriverPath() throws IOException {
        File parentFolder = SeleniumWebDriverProvider.getTempDriverDirectory();
        switch (Platform.getOS()) {
            case "win32": {
                return new File(parentFolder, "msedgedriver.exe").getAbsolutePath();
            }
        }
        return new File(parentFolder, "msedgedriver").getAbsolutePath();
    }

    public static String getGeckoDriverPath() throws IOException {
        switch (Platform.getOS()) {
            case "win32": {
                return SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath() + File.separator + "firefox_win64" + File.separator + "geckodriver.exe";
            }
            case "linux": {
                if (Platform.getOSArch().equals("aarch64")) {
                    String geckoDriverPath = SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath() + File.separator + "firefox_linux_arm" + File.separator + "geckodriver";
                    SeleniumWebDriverProvider.makeFileExecutable(geckoDriverPath);
                    return geckoDriverPath;
                }
                String geckoDriverPath = SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath() + File.separator + "firefox_linux64" + File.separator + "geckodriver";
                SeleniumWebDriverProvider.makeFileExecutable(geckoDriverPath);
                return geckoDriverPath;
            }
            case "macosx": {
                String geckoDriverPath = SeleniumWebDriverProvider.getDriverDirectory().getAbsolutePath() + File.separator + "firefox_mac" + File.separator + "geckodriver";
                SeleniumWebDriverProvider.makeFileExecutable(geckoDriverPath);
                return geckoDriverPath;
            }
        }
        return "";
    }

    public static String getTempGeckoDriverPath() throws IOException {
        File parentFolder = SeleniumWebDriverProvider.getTempDriverDirectory();
        switch (Platform.getOS()) {
            case "win32": {
                return new File(parentFolder, "geckodriver.exe").getAbsolutePath();
            }
        }
        return new File(parentFolder, "geckodriver").getAbsolutePath();
    }
}

