/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.parts;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.parts.TestSuiteRetryUiAdapter;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TestSuiteRetryUiPart {
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private static final int MAX_RETRY = 1000000;
    private static final int MIN_RETRY = 0;
    private String RETRY_DOCS_URL = "https://docs.katalon.com/katalon-studio/execute-tests/execute-test-suites-in-katalon-studio";
    private static final int MINIMUM_COMPOSITE_SIZE = 300;
    private Text txtRetryAfterExecuteAll;
    private Text txtRetryImmediately;
    private Button radioBtnRetryAllExecutions;
    private Button radioBtnRetryFailedExecutionsOnly;
    private Button radioBtnRetryImmediately;
    private Button radioBtnRetryAfterExecuteAll;
    private Label linkToRetryDocs1;
    private Label linkToRetryDocs2;
    private TestSuiteRetryUiAdapter adapter;

    public TestSuiteRetryUiPart(TestSuiteRetryUiAdapter adapter) {
        this.adapter = adapter;
    }

    private TestSuiteEntity getTestSuite() {
        return this.adapter.getTestSuite();
    }

    public void registerRetryControlListeners() {
        this.addNumberVerification(this.txtRetryAfterExecuteAll, 0, 1000000);
        this.addNumberVerification(this.txtRetryImmediately, 0, 1000000);
        this.txtRetryAfterExecuteAll.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TestSuiteRetryUiPart.this.getTestSuite() != null) {
                    TestSuiteRetryUiPart.this.getTestSuite().setNumberOfRerun(Integer.parseInt(TestSuiteRetryUiPart.this.txtRetryAfterExecuteAll.getText()));
                }
            }
        });
        this.txtRetryImmediately.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TestSuiteRetryUiPart.this.getTestSuite() != null) {
                    TestSuiteRetryUiPart.this.getTestSuite().setNumberOfRerun(Integer.parseInt(TestSuiteRetryUiPart.this.txtRetryImmediately.getText()));
                }
            }
        });
        this.radioBtnRetryImmediately.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UISynchronizeService.syncExec(() -> {
                    boolean value;
                    if (!TestSuiteRetryUiPart.this.featureController.canUse(ProductFeature.RERUN_IMMEDIATELY)) {
                        TestSuiteRetryUiPart.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.RERUN_IMMEDIATELY);
                        TestSuiteRetryUiPart.this.radioBtnRetryImmediately.setSelection(false);
                    }
                    if (value = TestSuiteRetryUiPart.this.radioBtnRetryImmediately.getSelection()) {
                        TestSuiteRetryUiPart.this.radioBtnRetryAfterExecuteAll.setSelection(false);
                        TestSuiteRetryUiPart.this.radioBtnRetryAllExecutions.setSelection(false);
                        TestSuiteRetryUiPart.this.radioBtnRetryFailedExecutionsOnly.setSelection(false);
                        TestSuiteRetryUiPart.this.txtRetryImmediately.setEnabled(true);
                        if (TestSuiteRetryUiPart.this.getTestSuite() != null) {
                            TestSuiteRetryUiPart.this.getTestSuite().setRerunFailedTestCasesOnly(false);
                            TestSuiteRetryUiPart.this.getTestSuite().setRerunFailedTestCasesTestDataOnly(false);
                        }
                        TestSuiteRetryUiPart.this.enableRetryAfterExecuteAll(false);
                    }
                    if (TestSuiteRetryUiPart.this.getTestSuite() != null) {
                        TestSuiteRetryUiPart.this.getTestSuite().setRerunImmediately(value);
                    }
                    TestSuiteRetryUiPart.this.setDirty(true);
                });
            }
        });
        this.radioBtnRetryAfterExecuteAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UISynchronizeService.syncExec(() -> {
                    boolean value = TestSuiteRetryUiPart.this.radioBtnRetryAfterExecuteAll.getSelection();
                    if (value) {
                        TestSuiteRetryUiPart.this.radioBtnRetryImmediately.setSelection(false);
                        TestSuiteRetryUiPart.this.txtRetryImmediately.setEnabled(false);
                        if (TestSuiteRetryUiPart.this.getTestSuite() != null) {
                            TestSuiteRetryUiPart.this.getTestSuite().setRerunImmediately(false);
                        }
                        TestSuiteRetryUiPart.this.enableRetryAfterExecuteAll(true);
                        TestSuiteRetryUiPart.this.radioBtnRetryAllExecutions.setSelection(true);
                    }
                    TestSuiteRetryUiPart.this.setDirty(true);
                });
            }
        });
        this.radioBtnRetryAllExecutions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean val = TestSuiteRetryUiPart.this.radioBtnRetryAllExecutions.getSelection();
                if (val && TestSuiteRetryUiPart.this.getTestSuite() != null) {
                    TestSuiteRetryUiPart.this.getTestSuite().setRerunFailedTestCasesOnly(false);
                    TestSuiteRetryUiPart.this.getTestSuite().setRerunFailedTestCasesTestDataOnly(false);
                }
                TestSuiteRetryUiPart.this.setDirty(true);
            }
        });
        this.radioBtnRetryFailedExecutionsOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean val = TestSuiteRetryUiPart.this.radioBtnRetryFailedExecutionsOnly.getSelection();
                if (TestSuiteRetryUiPart.this.getTestSuite() != null) {
                    TestSuiteRetryUiPart.this.getTestSuite().setRerunFailedTestCasesOnly(val);
                    TestSuiteRetryUiPart.this.getTestSuite().setRerunFailedTestCasesTestDataOnly(val);
                }
                TestSuiteRetryUiPart.this.setDirty(true);
            }
        });
        MouseListener openDocsMouseHandler = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Program.launch((String)TestSuiteRetryUiPart.this.RETRY_DOCS_URL);
                Trackings.trackOpenHelp((String)TestSuiteRetryUiPart.this.RETRY_DOCS_URL);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.linkToRetryDocs1.addMouseListener(openDocsMouseHandler);
        this.linkToRetryDocs2.addMouseListener(openDocsMouseHandler);
    }

    public void enableRetryAfterExecuteAll(boolean val) {
        this.txtRetryAfterExecuteAll.setEnabled(val);
        this.radioBtnRetryAllExecutions.setEnabled(val);
        this.radioBtnRetryFailedExecutionsOnly.setEnabled(val);
    }

    public void createRetryComposite(Composite compositePageLoadTimeout) {
        Composite compositeLastRunAndReRun = new Composite(compositePageLoadTimeout, 0);
        GridData gdCompositeTestDataAndLastRun = new GridData(4, 4, true, true, 1, 1);
        gdCompositeTestDataAndLastRun.minimumWidth = 300;
        compositeLastRunAndReRun.setLayoutData((Object)gdCompositeTestDataAndLastRun);
        GridLayout glCompositeTestDataAndLastRun = new GridLayout(4, false);
        glCompositeTestDataAndLastRun.marginWidth = 0;
        compositeLastRunAndReRun.setLayout((Layout)glCompositeTestDataAndLastRun);
        Composite grpRetryExecution = new Composite(compositeLastRunAndReRun, 0);
        grpRetryExecution.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        GridLayout gl_grpRetryExecution = new GridLayout(3, false);
        gl_grpRetryExecution.marginWidth = 2;
        gl_grpRetryExecution.marginHeight = 5;
        grpRetryExecution.setLayout((Layout)gl_grpRetryExecution);
        this.radioBtnRetryImmediately = new Button(grpRetryExecution, 16);
        GridData gdLblStopImmediately = new GridData(16384, 0x1000000, true, false, 1, 1);
        this.radioBtnRetryImmediately.setLayoutData((Object)gdLblStopImmediately);
        this.radioBtnRetryImmediately.setText(ComposerTestsuiteMessageConstants.PA_LBL_RETRY_IMMEDIATELY);
        this.txtRetryImmediately = new Text(grpRetryExecution, 2048);
        GridData gdTxtStopImmediately = new GridData(131072, 4, true, false, 1, 1);
        gdTxtStopImmediately.widthHint = 20;
        this.txtRetryImmediately.setLayoutData((Object)gdTxtStopImmediately);
        this.txtRetryImmediately.setTextLimit(3);
        this.linkToRetryDocs1 = new Label(grpRetryExecution, 0);
        this.linkToRetryDocs1.setImage(ImageManager.getImage((String)"help_16.png"));
        this.linkToRetryDocs1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Composite grpRetryExecutions = new Composite(compositeLastRunAndReRun, 0);
        grpRetryExecutions.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        GridLayout gl_grpRetryExecutions = new GridLayout(3, false);
        gl_grpRetryExecutions.marginWidth = 2;
        gl_grpRetryExecutions.marginHeight = 5;
        grpRetryExecutions.setLayout((Layout)gl_grpRetryExecutions);
        this.radioBtnRetryAfterExecuteAll = new Button(grpRetryExecutions, 16);
        GridData gdLblReRun = new GridData(16384, 0x1000000, true, false, 1, 1);
        this.radioBtnRetryAfterExecuteAll.setLayoutData((Object)gdLblReRun);
        this.radioBtnRetryAfterExecuteAll.setText(ComposerTestsuiteMessageConstants.PA_LBL_RETRY_AFTER_EXECUTE_ALL);
        this.radioBtnRetryAfterExecuteAll.setToolTipText(ComposerTestsuiteMessageConstants.PA_LBL_TOOLTIP_RETRY);
        this.txtRetryAfterExecuteAll = new Text(grpRetryExecutions, 2048);
        GridData gdTxtRerun = new GridData(131072, 4, false, false, 1, 1);
        gdTxtRerun.widthHint = 20;
        this.txtRetryAfterExecuteAll.setLayoutData((Object)gdTxtRerun);
        this.txtRetryAfterExecuteAll.setTextLimit(3);
        this.linkToRetryDocs2 = new Label(grpRetryExecutions, 0);
        this.linkToRetryDocs2.setImage(ImageManager.getImage((String)"help_16.png"));
        this.linkToRetryDocs2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Composite grpRetryExecutionsChildComposite = new Composite(grpRetryExecutions, 0);
        grpRetryExecutionsChildComposite.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        GridLayout gl_grpRetryExecutionsChildComposite = new GridLayout(4, false);
        gl_grpRetryExecutionsChildComposite.marginWidth = 5;
        gl_grpRetryExecutionsChildComposite.marginHeight = 5;
        gl_grpRetryExecutionsChildComposite.marginLeft = 45;
        grpRetryExecutionsChildComposite.setLayout((Layout)gl_grpRetryExecutionsChildComposite);
        this.radioBtnRetryAllExecutions = new Button(grpRetryExecutionsChildComposite, 16);
        GridData gdRerunTestCase = new GridData(4, 0x1000000, true, false, 4, 1);
        this.radioBtnRetryAllExecutions.setLayoutData((Object)gdRerunTestCase);
        this.radioBtnRetryAllExecutions.setText(ComposerTestsuiteMessageConstants.PA_LBL_RETRY_ALL_EXECUTIONS);
        this.radioBtnRetryFailedExecutionsOnly = new Button(grpRetryExecutionsChildComposite, 16);
        GridData gdRerunTestCaseTestData = new GridData(4, 0x1000000, true, false, 4, 1);
        this.radioBtnRetryFailedExecutionsOnly.setLayoutData((Object)gdRerunTestCaseTestData);
        this.radioBtnRetryFailedExecutionsOnly.setText(ComposerTestsuiteMessageConstants.PA_LBL_RETRY_FAILED_EXECUTIONS);
    }

    public void syncRetryControlStatesWithTestSuiteInfo(TestSuiteEntity testSuite) {
        boolean shouldRetryFailedExecutions = testSuite.isRerunFailedTestCasesOnly() || testSuite.isRerunFailedTestCasesAndTestDataOnly();
        boolean shouldRetryImmediately = testSuite.isRerunImmediately();
        boolean shouldRetryAllExecutions = !testSuite.isRerunFailedTestCasesOnly() && !testSuite.isRerunFailedTestCasesAndTestDataOnly();
        boolean shouldRetryAfterExecuteAll = (shouldRetryAllExecutions || shouldRetryFailedExecutions) && !shouldRetryImmediately;
        shouldRetryImmediately = this.featureController.canUse(ProductFeature.RERUN_IMMEDIATELY) && shouldRetryImmediately;
        this.radioBtnRetryAfterExecuteAll.setSelection(shouldRetryAfterExecuteAll);
        this.radioBtnRetryImmediately.setSelection(shouldRetryImmediately);
        this.radioBtnRetryAllExecutions.setSelection(shouldRetryAllExecutions);
        this.radioBtnRetryFailedExecutionsOnly.setSelection(shouldRetryFailedExecutions);
        this.txtRetryImmediately.setEnabled(shouldRetryImmediately);
        this.enableRetryAfterExecuteAll(shouldRetryAfterExecuteAll);
        if (shouldRetryAfterExecuteAll) {
            this.txtRetryAfterExecuteAll.setText(String.valueOf(testSuite.getNumberOfRerun()));
        }
        if (shouldRetryImmediately) {
            this.txtRetryImmediately.setText(String.valueOf(testSuite.getNumberOfRerun()));
        }
    }

    public void synRetryControlStatesByDescription(RetryControlStateDescription description) {
        boolean shouldRetryImmediately = this.featureController.canUse(ProductFeature.RERUN_IMMEDIATELY) && description.getRetryStrategyValue().equals((Object)DefaultRerunSetting.RetryStrategyValue.IMMEDIATELY);
        boolean shouldRetryAfterExecuteAll = !shouldRetryImmediately;
        boolean shouldRetryAllExecutions = description.getRetryStrategyValue().equals((Object)DefaultRerunSetting.RetryStrategyValue.ALL_EXECUTIONS);
        boolean shouldRetryFailedExecutions = description.getRetryStrategyValue().equals((Object)DefaultRerunSetting.RetryStrategyValue.FAILED_EXECUTIONS);
        this.radioBtnRetryAfterExecuteAll.setSelection(shouldRetryAfterExecuteAll);
        this.radioBtnRetryImmediately.setSelection(shouldRetryImmediately);
        this.radioBtnRetryAllExecutions.setSelection(shouldRetryAllExecutions);
        this.radioBtnRetryFailedExecutionsOnly.setSelection(shouldRetryFailedExecutions);
        this.txtRetryImmediately.setEnabled(shouldRetryImmediately);
        this.enableRetryAfterExecuteAll(shouldRetryAfterExecuteAll);
        if (shouldRetryAfterExecuteAll) {
            this.txtRetryAfterExecuteAll.setText(String.valueOf(description.getRetryNumber()));
        }
        if (shouldRetryImmediately) {
            this.txtRetryImmediately.setText(String.valueOf(description.getRetryNumber()));
        }
    }

    public int getRetryNumber() {
        String immediately = this.txtRetryImmediately.getText();
        String afterExecuteAll = this.txtRetryAfterExecuteAll.getText();
        if (this.radioBtnRetryAfterExecuteAll.getSelection()) {
            return Integer.valueOf("".equals(afterExecuteAll) ? "0" : afterExecuteAll);
        }
        return Integer.valueOf("".equals(immediately) ? "0" : immediately);
    }

    public DefaultRerunSetting.RetryStrategyValue getRetryStrategy() {
        if (this.radioBtnRetryAllExecutions.getSelection()) {
            return DefaultRerunSetting.RetryStrategyValue.ALL_EXECUTIONS;
        }
        if (this.radioBtnRetryFailedExecutionsOnly.getSelection()) {
            return DefaultRerunSetting.RetryStrategyValue.FAILED_EXECUTIONS;
        }
        if (this.radioBtnRetryImmediately.getSelection()) {
            return DefaultRerunSetting.RetryStrategyValue.IMMEDIATELY;
        }
        return DefaultRerunSetting.RetryStrategyValue.FAILED_EXECUTIONS;
    }

    private void setDirty(boolean b) {
        this.adapter.setDirty(b);
    }

    private void addNumberVerification(Text txtInput, int min, int max) {
        if (txtInput == null || txtInput.isDisposed()) {
            return;
        }
        txtInput.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
                TestSuiteRetryUiPart.this.setDirty(true);
            }
        });
    }

    public static class RetryControlStateDescription {
        private int retryNumber;
        private DefaultRerunSetting.RetryStrategyValue retryStrategyValue;

        public RetryControlStateDescription(int retryNum, DefaultRerunSetting.RetryStrategyValue retryStrategyValue) {
            this.retryNumber = retryNum;
            this.retryStrategyValue = retryStrategyValue;
        }

        public int getRetryNumber() {
            return this.retryNumber;
        }

        public DefaultRerunSetting.RetryStrategyValue getRetryStrategyValue() {
            return this.retryStrategyValue;
        }
    }
}

