/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.providers;

import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.ImageConstants;
import com.kms.katalon.composer.testsuite.parts.TestSuitePartDataBindingView;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.variable.VariableEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Image;

public class VariableTableLabelProvider
extends TypeCheckedStyleCellLabelProvider<VariableLink> {
    public static final int COLUMN_NOTIFICATION_INDEX = 0;
    public static final int COLUMN_NO_INDEX = 1;
    public static final int COLUMN_NAME_INDEX = 2;
    public static final int COLUMN_DEFAULT_VALUE_INDEX = 3;
    public static final int COLUMN_TYPE_INDEX = 4;
    public static final int COLUMN_TEST_DATA_ID_INDEX = 5;
    public static final int COLUMN_VALUE_INDEX = 6;
    private static TestSuiteController testSuiteController = TestSuiteController.getInstance();
    private int columnIndex;
    private TestSuitePartDataBindingView testSuiteDataBindingView;

    public VariableTableLabelProvider(int columnIndex, TestSuitePartDataBindingView testDataTreeView) {
        super(columnIndex);
        this.columnIndex = columnIndex;
        this.testSuiteDataBindingView = testDataTreeView;
    }

    protected Class<VariableLink> getElementType() {
        return VariableLink.class;
    }

    protected Image getImage(VariableLink variableLink) {
        VariableLink.VariableType type = variableLink.getType();
        if (type == VariableLink.VariableType.DEFAULT || type == VariableLink.VariableType.SCRIPT_VARIABLE) {
            return null;
        }
        switch (this.columnIndex) {
            case 0: {
                if (StringUtils.isEmpty((String)variableLink.getTestDataLinkId()) || StringUtils.isEmpty((String)variableLink.getValue())) {
                    return ImageConstants.IMG_16_ERROR_TABLE_ITEM;
                }
                return null;
            }
            case 5: {
                if (StringUtils.isEmpty((String)variableLink.getTestDataLinkId())) {
                    return ImageConstants.IMG_16_WARN_TABLE_ITEM;
                }
                return null;
            }
            case 6: {
                if (StringUtils.isEmpty((String)variableLink.getValue())) {
                    return ImageConstants.IMG_16_WARN_TABLE_ITEM;
                }
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getText(VariableLink variableLink) {
        TestSuiteTestCaseLink testCaseLink = this.testSuiteDataBindingView.getSelectedTestCaseLink();
        if (testCaseLink == null) {
            return "";
        }
        try {
            VariableEntity variableEntity = testSuiteController.getVariable(testCaseLink, variableLink);
            if (variableEntity == null) {
                return "";
            }
            switch (this.columnIndex) {
                case 1: {
                    return Integer.toString(this.testSuiteDataBindingView.getSelectedTestCaseLink().getVariableLinks().indexOf(variableLink) + 1);
                }
                case 2: {
                    return variableEntity.getName();
                }
                case 3: {
                    return variableEntity.getDefaultValue();
                }
                case 4: {
                    return variableLink.getType().toString();
                }
                case 5: {
                    if (StringUtils.isEmpty((String)variableLink.getTestDataLinkId())) {
                        return "";
                    }
                    TestCaseTestDataLink testDataLink = testSuiteController.getTestDataLink(variableLink.getTestDataLinkId(), testCaseLink);
                    if (testDataLink == null) {
                        return "";
                    }
                    int order = this.testSuiteDataBindingView.getSelectedTestCaseLink().getTestDataLinks().indexOf(testDataLink) + 1;
                    return Integer.toString(order) + " - " + testDataLink.getTestDataId();
                }
                case 6: {
                    if (variableLink.getType() == VariableLink.VariableType.DEFAULT) {
                        return "";
                    }
                    String string = variableLink.getValue();
                    return string;
                }
            }
            return "";
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return "";
    }

    protected String getElementToolTipText(VariableLink variableLink) {
        VariableLink.VariableType type = variableLink.getType();
        if (type == VariableLink.VariableType.DEFAULT || type == VariableLink.VariableType.SCRIPT_VARIABLE) {
            return StringUtils.defaultIfEmpty((String)this.getText(variableLink), null);
        }
        switch (this.columnIndex) {
            case 0: {
                String variableType = variableLink.getType().toString();
                if (StringUtils.equals((String)VariableLink.VariableType.SCRIPT_VARIABLE.toString(), (String)variableType) || StringUtils.equals((String)VariableLink.VariableType.DEFAULT.toString(), (String)variableType)) {
                    return null;
                }
                StringBuilder tooltipText = new StringBuilder();
                if (StringUtils.isEmpty((String)variableLink.getTestDataLinkId())) {
                    tooltipText.append(ComposerTestsuiteMessageConstants.LP_WARN_MSG_SET_TEST_DATA_NOTIFY);
                }
                if (StringUtils.isEmpty((String)variableLink.getValue())) {
                    if (tooltipText.length() != 0) {
                        tooltipText.append("\n");
                    }
                    tooltipText.append(ComposerTestsuiteMessageConstants.LP_WARN_MSG_SET_TEST_DATA_COLUMN_NOTIFY);
                }
                return StringUtils.defaultIfEmpty((String)tooltipText.toString(), null);
            }
            case 5: {
                if (StringUtils.isEmpty((String)variableLink.getTestDataLinkId())) {
                    return ComposerTestsuiteMessageConstants.LP_WARN_MSG_SET_TEST_DATA;
                }
                return StringUtils.defaultIfEmpty((String)this.getText(variableLink), null);
            }
            case 6: {
                if (StringUtils.isEmpty((String)variableLink.getValue())) {
                    return ComposerTestsuiteMessageConstants.LP_WARN_MSG_SET_TEST_DATA_COLUMN;
                }
                return StringUtils.defaultIfEmpty((String)this.getText(variableLink), null);
            }
        }
        return StringUtils.defaultIfEmpty((String)this.getText(variableLink), null);
    }
}

