/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.ProfileTreeEntity;
import com.kms.katalon.composer.global.constants.ComposerGlobalMessageConstants;
import com.kms.katalon.composer.global.dialog.ExecutionProfileNameDialog;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameExecutionProfileHandler {
    @Inject
    private IEventBroker eventBroker;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof ProfileTreeEntity) {
                    RenameExecutionProfileHandler.this.execute((ProfileTreeEntity)object);
                }
            }
        });
    }

    private void execute(ProfileTreeEntity selectedTreeEntity) {
        ExecutionProfileEntity selectedProfile = null;
        try {
            selectedProfile = selectedTreeEntity.getObject();
        }
        catch (Exception exception) {}
        try {
            String profileName = selectedProfile.getName();
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            List<ExecutionProfileEntity> sibblingProfiles = GlobalVariableController.getInstance().getAllGlobalVariableCollections(project).stream().filter(p -> !p.getName().equals(profileName)).collect(Collectors.toList());
            ExecutionProfileNameDialog dialog = new ExecutionProfileNameDialog(this.parentShell, selectedProfile.getName(), sibblingProfiles, ComposerGlobalMessageConstants.DIA_TITLE_RENAME_EXECUTION_PROFILE);
            if (dialog.open() != 0) {
                return;
            }
            String newName = dialog.getNewName();
            ExecutionProfileEntity renamedProfile = GlobalVariableController.getInstance().renameExecutionProfile(newName, selectedProfile);
            List updatedTestSuiteCollections = TestSuiteCollectionController.getInstance().updateProfileNameInAllTestSuiteCollections(project, profileName, newName);
            selectedTreeEntity.setObject((Object)renamedProfile);
            this.eventBroker.post("EXECUTION_PROFILE/RENAMED", (Object)renamedProfile);
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)selectedTreeEntity.getParent());
            updatedTestSuiteCollections.forEach(tsc -> {
                boolean bl = this.eventBroker.post("TEST_SUITE_COLLECTION/UPDATED", (Object)new Object[]{tsc.getId(), tsc});
            });
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((String)MessageFormat.format("Unable to rename execution profile '{0}'", selectedProfile.getName()), (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }
}

