/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.filters.TestDataTreeViewerFilter;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.control.StyledTextMessage;
import com.kms.katalon.composer.components.impl.providers.TestDataIDColumnLabelProvider;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class TestDataLinkFinderDialog
extends Dialog {
    private StyledText textSearch;
    private List<TestCaseTestDataLink> testDataLinks;
    private TableViewer treeViewer;
    private TestCaseTestDataLink selectedTestCaseLink;
    private TestCaseTestDataLink initSelectedTestDataLink;
    private TestDataTreeViewerFilter treeViewerFilter;

    public TestDataLinkFinderDialog(Shell parentShell, TestCaseTestDataLink testDataLink, List<TestCaseTestDataLink> testDataLinks) {
        super(parentShell);
        this.testDataLinks = testDataLinks;
        this.initSelectedTestDataLink = testDataLink;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComposerComponentsImplMessageConstants.DIA_SHELL_TEST_DATA_LINK_BROWSER);
    }

    public void create() {
        super.create();
        this.treeViewer.setInput(this.testDataLinks);
        this.registerListeners();
        this.initSelection();
    }

    private void registerListeners() {
        this.textSearch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String searchString = ((Text)e.getSource()).getText();
                TestDataLinkFinderDialog.this.treeViewerFilter.setSearchText(searchString);
                TestDataLinkFinderDialog.this.treeViewer.refresh();
            }
        });
        this.treeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TestDataLinkFinderDialog.this.treeViewer.getSelection();
                TestDataLinkFinderDialog.this.selectedTestCaseLink = (TestCaseTestDataLink)selection.getFirstElement();
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TestDataLinkFinderDialog.this.treeViewer.getSelection();
                TestDataLinkFinderDialog.this.selectedTestCaseLink = (TestCaseTestDataLink)selection.getFirstElement();
                TestDataLinkFinderDialog.this.okPressed();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite compositeSearch = new Composite(container, 0);
        GridLayout gl_compositeSearch = new GridLayout(1, false);
        compositeSearch.setLayout((Layout)gl_compositeSearch);
        compositeSearch.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.textSearch = new StyledText(compositeSearch, 4);
        GridData gd_textSearch = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textSearch.heightHint = 25;
        this.textSearch.setLayoutData((Object)gd_textSearch);
        StyledTextMessage styledTextMessage = new StyledTextMessage(this.textSearch);
        styledTextMessage.setMessage(ComposerComponentsImplMessageConstants.DIA_TXT_ENTER_TEXT_TO_SEARCH);
        Composite compositeTree = new Composite(container, 0);
        compositeTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        compositeTree.setLayout((Layout)new GridLayout(1, false));
        Label lblTestDatasHierarachy = new Label(compositeTree, 0);
        lblTestDatasHierarachy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblTestDatasHierarachy.setText(ComposerComponentsImplMessageConstants.DIA_LBL_TEST_DATA_HIERARCHY);
        this.treeViewer = new TableViewer(compositeTree, 2048);
        Table tree = this.treeViewer.getTable();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn treeViewerColumn = new TableViewerColumn(this.treeViewer, 0);
        TableColumn trclmnTestDataID = treeViewerColumn.getColumn();
        trclmnTestDataID.setWidth(380);
        trclmnTestDataID.setText(StringConstants.DIA_TREE_VIEWER_COL_ID);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new TestDataIDColumnLabelProvider(this.textSearch));
        this.treeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.treeViewerFilter = new TestDataTreeViewerFilter();
        this.treeViewer.setFilters(new ViewerFilter[]{this.treeViewerFilter});
        return container;
    }

    private void initSelection() {
        if (this.initSelectedTestDataLink == null) {
            return;
        }
        this.treeViewer.getTable().forceFocus();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.initSelectedTestDataLink));
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    protected void setShellStyle(int arg) {
        super.setShellStyle(65648);
    }

    public TestCaseTestDataLink getSelectedTestDataLink() {
        return this.selectedTestCaseLink != null ? this.selectedTestCaseLink : null;
    }
}

