/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.tree;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.transfer.TreeEntityTransfer;
import com.kms.katalon.composer.components.impl.tree.AbstractTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.io.File;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;

public class TestSuiteTreeEntity
extends AbstractTreeEntity {
    private static final long serialVersionUID = -8388373715110244233L;
    private static final String TEST_SUITE_TYPE_NAME = StringConstants.TREE_TEST_SUITE_TYPE_NAME;
    public static final String KEY_WORD = "ts";
    public static final String[] SEARCH_TAGS = new String[]{"id", "name", "description"};
    private TestSuiteEntity testSuite;

    public TestSuiteTreeEntity(TestSuiteEntity testSuite, ITreeEntity parentTreeEntity) {
        super((FileEntity)testSuite, parentTreeEntity);
        this.testSuite = testSuite;
    }

    public TestSuiteEntity getObject() throws Exception {
        return TestSuiteController.getInstance().getTestSuite(this.entity.getId());
    }

    public Object[] getChildren() throws Exception {
        return null;
    }

    public boolean hasChildren() throws Exception {
        return false;
    }

    public Image getImage() throws Exception {
        if (this.entity instanceof FilteringTestSuiteEntity) {
            return ImageConstants.IMG_16_FILTERING_TEST_SUITE;
        }
        return ImageConstants.IMG_16_TEST_SUITE;
    }

    public String getTypeName() throws Exception {
        return TEST_SUITE_TYPE_NAME;
    }

    public boolean isRemoveable() throws Exception {
        return true;
    }

    public boolean isRenamable() throws Exception {
        return true;
    }

    public Transfer getEntityTransfer() throws Exception {
        return TreeEntityTransfer.getInstance();
    }

    public String getCopyTag() throws Exception {
        return FolderEntity.FolderType.TESTSUITE.toString();
    }

    @Override
    public void setObject(Object object) throws Exception {
        if (object instanceof TestSuiteEntity) {
            this.entity = (FileEntity)object;
            this.testSuite = (TestSuiteEntity)object;
        }
    }

    public String getKeyWord() throws Exception {
        return KEY_WORD;
    }

    public String[] getSearchTags() throws Exception {
        return SEARCH_TAGS;
    }

    public String getPropertyValue(String key) {
        if (key.equals("name")) {
            return this.testSuite.getName();
        }
        if (key.equals("id")) {
            return this.testSuite.getRelativePathForUI().replace(File.separator, "/");
        }
        if (key.equals("description")) {
            return this.testSuite.getDescription();
        }
        return "";
    }

    public Image getEntryImage() throws Exception {
        return this.getImage();
    }

    public void loadAllDescentdantEntities() throws Exception {
    }
}

