/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.sql.Blob;
import java.util.Collection;
import java.util.Map;
import org.eclipse.persistence.annotations.CacheIndex;
import org.eclipse.persistence.annotations.Index;
import org.eclipse.persistence.annotations.Mutable;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.annotations.ReturnUpdate;
import org.eclipse.persistence.annotations.UuidGenerator;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.cache.CacheIndexMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.LobMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.ReturnInsertMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.GeneratedValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.UuidGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.IndexMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class BasicAccessor
extends DirectAccessor {
    private Boolean m_mutable;
    private Boolean m_returnUpdate;
    private ColumnMetadata m_column;
    private DatabaseField m_databaseField;
    private GeneratedValueMetadata m_generatedValue;
    private ReturnInsertMetadata m_returnInsert;
    private SequenceGeneratorMetadata m_sequenceGenerator;
    private TableGeneratorMetadata m_tableGenerator;
    private UuidGeneratorMetadata m_uuidGenerator;
    private IndexMetadata m_index;
    private CacheIndexMetadata m_cacheIndex;

    public BasicAccessor() {
        super("<basic>");
    }

    public BasicAccessor(String xmlElement) {
        super(xmlElement);
    }

    public BasicAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        MetadataAnnotation basic = this.getAnnotation("javax.persistence.Basic");
        if (basic != null) {
            this.setFetch(basic.getAttributeString("fetch"));
            this.setOptional(basic.getAttributeBooleanDefaultTrue("optional"));
        }
        this.m_column = new ColumnMetadata(this.getAnnotation("javax.persistence.Column"), this);
        if (this.isAnnotationPresent(Mutable.class)) {
            this.m_mutable = this.getAnnotation(Mutable.class).getAttributeBooleanDefaultTrue("value");
        }
        if (this.isAnnotationPresent("javax.persistence.GeneratedValue")) {
            this.m_generatedValue = new GeneratedValueMetadata(this.getAnnotation("javax.persistence.GeneratedValue"), this);
        }
        if (this.isAnnotationPresent("javax.persistence.SequenceGenerator")) {
            this.m_sequenceGenerator = new SequenceGeneratorMetadata(this.getAnnotation("javax.persistence.SequenceGenerator"), this);
        }
        if (this.isAnnotationPresent("javax.persistence.TableGenerator")) {
            this.m_tableGenerator = new TableGeneratorMetadata(this.getAnnotation("javax.persistence.TableGenerator"), this);
        }
        if (this.isAnnotationPresent(UuidGenerator.class)) {
            this.m_uuidGenerator = new UuidGeneratorMetadata(this.getAnnotation(UuidGenerator.class), this);
        }
        if (this.isAnnotationPresent(ReturnInsert.class)) {
            this.m_returnInsert = new ReturnInsertMetadata(this.getAnnotation(ReturnInsert.class), this);
        }
        this.m_returnUpdate = this.isAnnotationPresent(ReturnUpdate.class);
        if (this.isAnnotationPresent(Index.class)) {
            this.m_index = new IndexMetadata(this.getAnnotation(Index.class), this);
        }
        if (this.isAnnotationPresent(CacheIndex.class)) {
            this.m_cacheIndex = new CacheIndexMetadata(this.getAnnotation(CacheIndex.class), this);
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof BasicAccessor) {
            BasicAccessor basicAccessor = (BasicAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_mutable, basicAccessor.getMutable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_returnUpdate, basicAccessor.getReturnUpdate())) {
                return false;
            }
            if (!this.valuesMatch(this.m_column, basicAccessor.getColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_generatedValue, basicAccessor.getGeneratedValue())) {
                return false;
            }
            if (!this.valuesMatch(this.m_returnInsert, basicAccessor.getReturnInsert())) {
                return false;
            }
            if (!this.valuesMatch(this.m_sequenceGenerator, basicAccessor.getSequenceGenerator())) {
                return false;
            }
            if (!this.valuesMatch(this.m_uuidGenerator, basicAccessor.getUuidGenerator())) {
                return false;
            }
            return this.valuesMatch(this.m_tableGenerator, basicAccessor.getTableGenerator());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_mutable != null ? this.m_mutable.hashCode() : 0);
        result = 31 * result + (this.m_returnUpdate != null ? this.m_returnUpdate.hashCode() : 0);
        result = 31 * result + (this.m_column != null ? this.m_column.hashCode() : 0);
        result = 31 * result + (this.m_generatedValue != null ? this.m_generatedValue.hashCode() : 0);
        result = 31 * result + (this.m_returnInsert != null ? this.m_returnInsert.hashCode() : 0);
        result = 31 * result + (this.m_sequenceGenerator != null ? this.m_sequenceGenerator.hashCode() : 0);
        result = 31 * result + (this.m_tableGenerator != null ? this.m_tableGenerator.hashCode() : 0);
        result = 31 * result + (this.m_uuidGenerator != null ? this.m_uuidGenerator.hashCode() : 0);
        return result;
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    @Override
    protected ColumnMetadata getColumn(String loggingCtx) {
        return this.m_field == null ? (this.m_column == null ? super.getColumn(loggingCtx) : this.m_column) : this.m_field;
    }

    @Override
    public String getDefaultFetchType() {
        return "EAGER";
    }

    protected DatabaseField getDatabaseField() {
        return this.m_databaseField;
    }

    public GeneratedValueMetadata getGeneratedValue() {
        return this.m_generatedValue;
    }

    public Boolean getMutable() {
        return this.m_mutable;
    }

    public ReturnInsertMetadata getReturnInsert() {
        return this.m_returnInsert;
    }

    public Boolean getReturnUpdate() {
        return this.m_returnUpdate;
    }

    public SequenceGeneratorMetadata getSequenceGenerator() {
        return this.m_sequenceGenerator;
    }

    public TableGeneratorMetadata getTableGenerator() {
        return this.m_tableGenerator;
    }

    public UuidGeneratorMetadata getUuidGenerator() {
        return this.m_uuidGenerator;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        if (this.m_column == null) {
            this.m_column = new ColumnMetadata(this);
        } else {
            this.initXMLObject(this.m_column, accessibleObject);
        }
        this.initXMLObject(this.m_generatedValue, accessibleObject);
        this.initXMLObject(this.m_returnInsert, accessibleObject);
        this.initXMLObject(this.m_sequenceGenerator, accessibleObject);
        this.initXMLObject(this.m_tableGenerator, accessibleObject);
        this.initXMLObject(this.m_uuidGenerator, accessibleObject);
    }

    @Override
    public boolean isBasic() {
        return true;
    }

    protected boolean isCollectionClass(MetadataClass cls) {
        return cls.extendsInterface(Collection.class);
    }

    protected boolean isMapClass(MetadataClass cls) {
        return cls.extendsInterface(Map.class);
    }

    public Boolean isReturnUpdate() {
        if (this.m_returnUpdate != null && this.m_returnUpdate.booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public void process() {
        AbstractDirectMapping mapping = this.getOwningDescriptor().getClassDescriptor().newDirectMapping();
        this.setMapping(mapping);
        this.m_databaseField = this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column");
        if (this.hasAttributeType() || this.getAccessibleObject().isGenericType()) {
            mapping.setAttributeClassificationName(this.getReferenceClassName());
        }
        mapping.setField(this.m_databaseField);
        mapping.setIsReadOnly(this.m_databaseField.isReadOnly());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setIsOptional(this.isOptional());
        mapping.setIsLazy(this.usesIndirection());
        this.setAccessorMethods(mapping);
        this.processMappingValueConverter(mapping, this.getConvert(), this.getConverts(), this.getReferenceClass(), this.getReferenceClassWithGenerics());
        if (this.m_mutable != null) {
            mapping.setIsMutable(this.m_mutable);
        }
        this.processReturnInsertAndUpdate();
        this.processGeneratedValue();
        if (this.m_tableGenerator != null) {
            this.getProject().addTableGenerator(this.m_tableGenerator, this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema());
        }
        if (this.m_sequenceGenerator != null) {
            this.getProject().addSequenceGenerator(this.m_sequenceGenerator, this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema());
        }
        if (this.m_uuidGenerator != null) {
            this.getProject().addUuidGenerator(this.m_uuidGenerator);
        }
        this.processIndex();
        this.processCacheIndex();
    }

    @Override
    protected void processEnumerated(EnumeratedMetadata enumerated, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (this.isCollectionClass(referenceClass) || this.isMapClass(referenceClass)) {
            this.processSerialized(mapping, referenceClass, isForMapKey);
        } else {
            super.processEnumerated(enumerated, mapping, referenceClass, isForMapKey);
        }
    }

    protected void processGeneratedValue() {
        if (this.m_generatedValue != null) {
            for (MetadataDescriptor owningDescriptor : this.getOwningDescriptors()) {
                DatabaseField existingSequenceNumberField = owningDescriptor.getSequenceNumberField();
                if (existingSequenceNumberField == null) {
                    owningDescriptor.setSequenceNumberField(this.m_databaseField);
                    this.getProject().addGeneratedValue(this.m_generatedValue, owningDescriptor.getJavaClass());
                    continue;
                }
                throw ValidationException.onlyOneGeneratedValueIsAllowed(owningDescriptor.getJavaClass(), existingSequenceNumberField.getQualifiedName(), this.m_databaseField.getQualifiedName());
            }
        }
    }

    protected void processIndex() {
        if (this.m_index != null) {
            this.m_index.process(this.getDescriptor(), this.m_databaseField.getName());
        }
    }

    protected void processCacheIndex() {
        if (this.m_cacheIndex != null) {
            this.m_cacheIndex.process(this.getDescriptor(), this.m_databaseField.getName());
        }
    }

    @Override
    protected void processLob(LobMetadata lob, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (this.isCollectionClass(referenceClass) || this.isMapClass(referenceClass)) {
            this.processSerialized(mapping, referenceClass, this.getMetadataClass(Blob.class), isForMapKey);
        } else {
            super.processLob(lob, mapping, referenceClass, isForMapKey);
        }
    }

    @Override
    protected void processReturnInsert() {
        if (this.m_returnInsert != null) {
            this.m_returnInsert.process(this.getDescriptor(), this.m_databaseField);
        }
    }

    @Override
    protected void processReturnUpdate() {
        if (this.isReturnUpdate().booleanValue()) {
            this.getDescriptor().addFieldForUpdate(this.m_databaseField);
        }
    }

    public IndexMetadata getIndex() {
        return this.m_index;
    }

    public void setIndex(IndexMetadata index) {
        this.m_index = index;
    }

    public CacheIndexMetadata getCacheIndex() {
        return this.m_cacheIndex;
    }

    public void setCacheIndex(CacheIndexMetadata index) {
        this.m_cacheIndex = index;
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public void setGeneratedValue(GeneratedValueMetadata value) {
        this.m_generatedValue = value;
    }

    public void setMutable(Boolean mutable) {
        this.m_mutable = mutable;
    }

    public void setReturnInsert(ReturnInsertMetadata returnInsert) {
        this.m_returnInsert = returnInsert;
    }

    public void setReturnUpdate(Boolean returnUpdate) {
        this.m_returnUpdate = returnUpdate;
    }

    public void setSequenceGenerator(SequenceGeneratorMetadata sequenceGenerator) {
        this.m_sequenceGenerator = sequenceGenerator;
    }

    public void setTableGenerator(TableGeneratorMetadata tableGenerator) {
        this.m_tableGenerator = tableGenerator;
    }

    public void setUuidGenerator(UuidGeneratorMetadata uuidGenerator) {
        this.m_uuidGenerator = uuidGenerator;
    }
}

