/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.menu;

import com.kms.katalon.composer.components.impl.tree.ReportCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.menu.MenuFactory;
import com.kms.katalon.composer.report.handlers.ExportTestSuiteCollectionReportHandler;
import com.kms.katalon.composer.report.handlers.ExportTestSuiteReportHandler;
import com.kms.katalon.composer.report.menu.ExportReportMenuItemObject;
import com.kms.katalon.constants.helper.ConstantsHelper;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.reporting.ExportReportProvider;
import com.kms.katalon.core.reporting.KatalonExportReportProvider;
import jakarta.inject.Inject;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.impl.DirectMenuItemImpl;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

public class ExportReportDynamicMenuContribution {
    public static final String REPORT_ITEM_TRANSIENT_DATA = "menuItemObject";
    private static final String BUNDLECLASS_URI = "bundleclass://com.kms.katalon.composer.report/";
    private static final String EXPORT_POPUPMENU_LABEL = "Export as";
    @Inject
    private ESelectionService selectionService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (this.canExecute(selectedObjects)) {
                String path = Paths.get(((ReportTreeEntity)selectedObjects[0]).getObject().getLocation(), ReportController.EXECUTION_SETTING_FILE_NAME).toString();
                RunConfiguration.setExecutionSettingFile((String)path);
                this.showMenuInTestSuiteReport(menuItems, RunConfiguration.isRunningDebugMode());
                return;
            }
            if (ExportReportDynamicMenuContribution.getFirstSelectedCollectionReport(selectedObjects) != null) {
                this.showMenuInTestSuiteCollectionReport(menuItems);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void showMenuInTestSuiteReport(List<MMenuElement> menuItems, boolean isItemHidden) {
        if (isItemHidden) {
            MDirectMenuItem item = MenuFactory.createDirectMenuItem((String)EXPORT_POPUPMENU_LABEL, (String)ConstantsHelper.getApplicationURI());
            item.setEnabled(false);
            menuItems.add((MMenuElement)item);
        } else {
            MMenu newMenu = MenuFactory.createPopupMenu((String)EXPORT_POPUPMENU_LABEL, (String)ConstantsHelper.getApplicationURI());
            if (newMenu == null) {
                return;
            }
            newMenu.setEnabled(false);
            KatalonExportReportProvider exportProvider = new KatalonExportReportProvider();
            String[] stringArray = exportProvider.getSupportedTypeForTestSuite();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String supportedType = stringArray[n2];
                String contributionUri = BUNDLECLASS_URI + ExportTestSuiteReportHandler.class.getName();
                DirectMenuItemImpl directMenu = (DirectMenuItemImpl)MenuFactory.createDirectMenuItem((String)supportedType, (String)ConstantsHelper.getApplicationURI());
                HashMap<String, ExportReportMenuItemObject> trasientData = new HashMap<String, ExportReportMenuItemObject>();
                trasientData.put(REPORT_ITEM_TRANSIENT_DATA, new ExportReportMenuItemObject(supportedType, (ExportReportProvider)exportProvider));
                directMenu.eSet(4, trasientData);
                directMenu.setContributionURI(contributionUri);
                newMenu.getChildren().add(directMenu);
                ++n2;
            }
            menuItems.add((MMenuElement)newMenu);
        }
    }

    public void showMenuInTestSuiteCollectionReport(List<MMenuElement> menuItems) {
        MMenu newMenu = MenuFactory.createPopupMenu((String)EXPORT_POPUPMENU_LABEL, (String)ConstantsHelper.getApplicationURI());
        if (newMenu == null) {
            return;
        }
        KatalonExportReportProvider exportProvider = new KatalonExportReportProvider();
        String[] stringArray = exportProvider.getSupportedTypeForTestSuiteCollection();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedType = stringArray[n2];
            String contributionUri = BUNDLECLASS_URI + ExportTestSuiteCollectionReportHandler.class.getName();
            DirectMenuItemImpl directMenu = (DirectMenuItemImpl)MenuFactory.createDirectMenuItem((String)supportedType, (String)ConstantsHelper.getApplicationURI());
            HashMap<String, ExportReportMenuItemObject> trasientData = new HashMap<String, ExportReportMenuItemObject>();
            trasientData.put(REPORT_ITEM_TRANSIENT_DATA, new ExportReportMenuItemObject(supportedType, (ExportReportProvider)exportProvider));
            directMenu.eSet(4, trasientData);
            directMenu.setContributionURI(contributionUri);
            newMenu.getChildren().add(directMenu);
            ++n2;
        }
        menuItems.add((MMenuElement)newMenu);
    }

    public boolean canExecute(Object[] selectedObjects) {
        if (selectedObjects == null || selectedObjects.length == 0) {
            return false;
        }
        boolean isHandled = true;
        Object[] objectArray = selectedObjects;
        int n = selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObject = objectArray[n2];
            if (!(selectedObject instanceof ReportTreeEntity)) {
                isHandled = false;
                break;
            }
            ++n2;
        }
        return isHandled;
    }

    public static ReportCollectionTreeEntity getFirstSelectedCollectionReport(Object[] selectedObjects) {
        if (selectedObjects.length == 0 || !(selectedObjects[0] instanceof ReportCollectionTreeEntity)) {
            return null;
        }
        return (ReportCollectionTreeEntity)selectedObjects[0];
    }
}

