/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.provider;

import com.kms.katalon.composer.report.preference.ReportPreferenceInitializer;
import com.kms.katalon.composer.report.provider.ReportTestCaseTreeViewerFilter;
import com.kms.katalon.composer.report.provider.ReportTestStepTreeViewer;
import com.kms.katalon.composer.report.provider.ReportTreeTableContentProvider;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.Viewer;

public class ReportTestStepTableViewerFilter
extends ReportTestCaseTreeViewerFilter {
    public static final int NOT_RUN = 64;
    private boolean showNotRun;

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (parentElement instanceof ILogRecord && ReportPreferenceInitializer.isChildLogForFirstMatchIncluded()) {
            return true;
        }
        return this.internallySelect(viewer, parentElement, element);
    }

    public boolean internallySelect(Viewer viewer, Object parentElement, Object element) {
        if (!this.isElementMatchFilter(element)) {
            return false;
        }
        ReportTestStepTreeViewer tablerView = (ReportTestStepTreeViewer)viewer;
        ILogRecord logRecord = (ILogRecord)element;
        String searchString = tablerView.getSearchedString();
        if (StringUtils.isEmpty((String)searchString)) {
            return true;
        }
        String queryTrimmed = searchString.toLowerCase().trim();
        boolean isMatched = false;
        if (logRecord instanceof MessageLogRecord) {
            if (logRecord.getMessage() != null && logRecord.getMessage().toLowerCase().contains(queryTrimmed)) {
                isMatched = true;
            }
        } else {
            if (logRecord.getName() != null && logRecord.getName().toLowerCase().contains(queryTrimmed)) {
                isMatched = true;
            }
            if (logRecord.getDescription() != null && logRecord.getDescription().toLowerCase().contains(queryTrimmed)) {
                isMatched = true;
            }
        }
        if (isMatched) {
            return true;
        }
        ReportTreeTableContentProvider treeContentProvider = (ReportTreeTableContentProvider)tablerView.getContentProvider();
        if (treeContentProvider.getChildren(element) != null) {
            Object[] objectArray = treeContentProvider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object childElement = objectArray[n2];
                isMatched |= this.internallySelect(viewer, element, childElement);
                ++n2;
            }
        }
        return isMatched;
    }

    @Override
    protected int getLogValue(ILogRecord logRecord) {
        if (logRecord.getStatus().getStatusValue() == TestStatus.TestStatusValue.NOT_RUN) {
            return 64;
        }
        return super.getLogValue(logRecord);
    }

    @Override
    protected int getFilterValue() {
        int filterNotRun = this.showNotRun ? 64 : 0;
        return super.getFilterValue() | filterNotRun & 0x40;
    }

    public boolean isNotRunShown() {
        return this.showNotRun;
    }

    public void showNotRun(boolean showNotRun) {
        this.showNotRun = showNotRun;
    }
}

