/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.services;

import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IFeatureManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Objects;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Creatable
@Singleton
public class FeatureController
implements IFeatureController {
    @Inject
    private IFeatureManager featureManager;
    private static IFeatureController instance;

    public static IFeatureController getInstance() {
        if (Objects.isNull(instance)) {
            BundleContext bundleContext = FrameworkUtil.getBundle(FeatureController.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (IFeatureController)ContextInjectionFactory.make(FeatureController.class, (IEclipseContext)context);
        }
        return instance;
    }

    public boolean canUse(ProductFeature productFeature) {
        return this.featureManager.canUse(productFeature);
    }

    public boolean isLimitReached(ProductFeature productFeature, int currentUsage) {
        return this.featureManager.isLimitReached(productFeature, currentUsage);
    }

    public boolean isQuotaUnlimited(ProductFeature feature) {
        return this.featureManager.isQuotaUnlimited(feature);
    }
}

