/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.application.controller;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.helpers.PerspectiveHelper;
import com.kms.katalon.onboarding.core.application.controller.IKnowledgeController;
import com.kms.katalon.onboarding.core.application.service.IKnowledgeManager;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.model.KnowledgeItem;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTour;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTourProgress;
import com.kms.katalon.onboarding.core.domain.repository.IOnboardingPreferencesRepository;
import com.kms.katalon.onboarding.core.domain.repository.entity.OnboardingPreferences;
import com.kms.katalon.onboarding.domain.event.OnboardingTourCompletedEvent;
import com.kms.katalon.onboarding.domain.event.OnboardingTourStartedEvent;
import com.kms.katalon.onboarding.domain.event.OnboardingTourTerminatedEvent;
import com.kms.katalon.onboarding.project.IOnboardingProjectManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.EventHandler;

@Creatable
@Singleton
public class KnowledgeController
implements IKnowledgeController {
    private static final int PERSPECTIVE_SWITCH_TIMEOUT_IN_MS = 500;
    private static final int PERSPECTIVE_RESET_TIMEOUT_IN_MS = 1000;
    @Inject
    private IKnowledgeManager knowledgeManager;
    @Inject
    private IOnboardingPreferencesRepository preferencesRepository;
    @Inject
    IEventBroker eventBroker;
    @Inject
    private IOnboardingProjectManager onboardingProjectManager;
    @Inject
    private EPartService partService;
    private final AtomicBoolean tourRunning = new AtomicBoolean(false);
    private EventHandler tourStartedHandler;
    private EventHandler tourCompletedHandler;
    private EventHandler tourTerminatedHandler;

    public void startTour(OnboardingTour tour) {
        this.prepareForStartTour(() -> {
            try {
                this.onboardingProjectManager.createOnboardingProject(tour.getId());
                this.knowledgeManager.startTour(tour);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                this.showErrorDialog(e, OnboardingMessageConstants.ERROR_FAILED_TO_START_ONBOARDING_TOUR);
            }
        });
    }

    private void prepareForStartTour(Runnable onComplete) {
        this.switchToKeywordPerspective(() -> UISynchronizeService.asyncExec(() -> {
            try {
                PerspectiveHelper.resetPerspective();
                UITimeUtil.setTimeout(() -> {
                    this.openKnowledgeHub();
                    if (onComplete != null) {
                        onComplete.run();
                    }
                }, (long)1000L);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                LoggerSingleton.logError((Throwable)e);
                this.showErrorDialog(e, OnboardingMessageConstants.ERROR_FAILED_TO_START_ONBOARDING_TOUR);
            }
        }));
    }

    private void switchToKeywordPerspective(Runnable onComplete) {
        PerspectiveHelper.switchToPerspective((String)"com.kms.katalon.composer.perspective.keyword");
        UITimeUtil.setTimeout(() -> {
            if (onComplete != null) {
                onComplete.run();
            }
        }, (long)500L);
    }

    public void rateTour(OnboardingTour tour, OnboardingTourProgress progress, String feedback) {
        try {
            this.knowledgeManager.rateTour(tour, progress, feedback);
        }
        catch (UnsupportedEncodingException e) {
            LoggerSingleton.logError((Throwable)e);
            this.showErrorDialog(e, OnboardingMessageConstants.ERROR_FAILED_TO_RATE_ONBOARDING_TOUR);
        }
    }

    public void startKnowledgeItem(KnowledgeItem item) {
        try {
            this.knowledgeManager.startKnowledgeItem(item);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            this.showErrorDialog(e, OnboardingMessageConstants.ERROR_FAILED_TO_START_KNOWLEDGE_ITEM);
        }
    }

    public void openKnowledgeHub() {
        try {
            this.openKnowledgeHubPart();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            this.showErrorDialog(e, OnboardingMessageConstants.ERROR_FAILED_TO_OPEN_KNOWLEDGE_HUB);
        }
    }

    public void showErrorDialog(Throwable e, String description) {
        MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)OnboardingMessageConstants.ERROR_DIALOG_TITLE_ONBOARDING_ERROR, (String)description);
    }

    public OnboardingPreferences getOnboardingPreferences() {
        return this.preferencesRepository.getPreferences();
    }

    public void updateOnboardingPreferences(OnboardingPreferences preferences) {
        this.preferencesRepository.savePreferences(preferences);
    }

    public boolean isTourRunning() {
        return this.tourRunning.get();
    }

    @PostConstruct
    private void subscribeOnboardingEvents() {
        this.tourStartedHandler = event -> {
            Object data = event.getProperty("org.eclipse.e4.data");
            if (data instanceof OnboardingTourStartedEvent) {
                this.tourRunning.set(true);
            }
        };
        this.tourCompletedHandler = event -> {
            Object data = event.getProperty("org.eclipse.e4.data");
            if (data instanceof OnboardingTourCompletedEvent) {
                this.tourRunning.set(false);
            }
        };
        this.tourTerminatedHandler = event -> {
            Object data = event.getProperty("org.eclipse.e4.data");
            if (data instanceof OnboardingTourTerminatedEvent) {
                this.tourRunning.set(false);
            }
        };
        this.eventBroker.subscribe("ONBOARDING/TOUR_STARTED", this.tourStartedHandler);
        this.eventBroker.subscribe("ONBOARDING/TOUR_COMPLETED", this.tourCompletedHandler);
        this.eventBroker.subscribe("ONBOARDING/TOUR_TERMINATED", this.tourTerminatedHandler);
    }

    @PreDestroy
    void cleanupOnboardingEventSubscriptions() {
        if (this.eventBroker != null) {
            if (this.tourStartedHandler != null) {
                this.eventBroker.unsubscribe(this.tourStartedHandler);
            }
            if (this.tourCompletedHandler != null) {
                this.eventBroker.unsubscribe(this.tourCompletedHandler);
            }
            if (this.tourTerminatedHandler != null) {
                this.eventBroker.unsubscribe(this.tourTerminatedHandler);
            }
        }
        this.tourRunning.set(false);
    }

    private void openKnowledgeHubPart() throws Exception {
        MApplication application = ApplicationSingleton.getInstance().getApplication();
        EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
        MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.partstack.rightsidebar", (MUIElement)application);
        if (stack == null) {
            throw new Exception(OnboardingMessageConstants.ERROR_RIGHT_SIDEBAR_PARTSTACK_NOT_FOUND);
        }
        stack.setToBeRendered(true);
        stack.getTags().remove("Minimized");
        MPart knowledgeHubPart = (MPart)modelService.find("com.kms.katalon.knowledgehub.part.knowledgehub", (MUIElement)stack);
        if (knowledgeHubPart == null) {
            throw new Exception(OnboardingMessageConstants.ERROR_KNOWLEDGE_HUB_NOT_FOUND);
        }
        knowledgeHubPart.setVisible(true);
        knowledgeHubPart.setToBeRendered(true);
        stack.setSelectedElement((MUIElement)knowledgeHubPart);
        MPart activePart = this.partService.getActivePart();
        if (activePart != null && activePart.getElementId().equals(knowledgeHubPart.getElementId())) {
            return;
        }
        this.partService.showPart(knowledgeHubPart, EPartService.PartState.ACTIVATE);
        MUIElement toolControl = modelService.find("com.kms.katalon.partstack.rightsidebar(com.kms.katalon.composer.window.main).(com.kms.katalon.composer.perspective.keyword)", (MUIElement)application);
        if (toolControl != null) {
            toolControl.setVisible(true);
        }
    }
}

