/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.domain.repository;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.model.BaseItem;
import com.kms.katalon.onboarding.core.domain.model.KnowledgeCategory;
import com.kms.katalon.onboarding.core.domain.model.KnowledgeHub;
import com.kms.katalon.onboarding.core.domain.model.KnowledgeItem;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTour;
import com.kms.katalon.onboarding.core.domain.repository.IKnowledgeRepository;
import com.kms.katalon.onboarding.core.domain.repository.entity.KnowledgeData;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.Bundle;

@Creatable
@Singleton
public class KnowledgeRepository
implements IKnowledgeRepository {
    private static final String BUNDLE_ID = "com.kms.katalon.onboarding";
    private static final String KNOWLEDGE_RESOURCE_PATH = "/resources/onboarding/knowledge.json";
    private final ObjectMapper objectMapper = this.createObjectMapper();
    private KnowledgeData cachedData;

    public KnowledgeHub loadHub() {
        return this.getKnowledgeData().map(this::buildKnowledgeHub).orElse(new KnowledgeHub());
    }

    public KnowledgeItem getKnowledgeItemById(String id) {
        if (this.isNullOrEmpty(id)) {
            return null;
        }
        return this.getKnowledgeData().map(data -> this.findKnowledgeItemById((KnowledgeData)data, id)).orElse(null);
    }

    public OnboardingTour getOnboardingItemById(String id) {
        if (this.isNullOrEmpty(id)) {
            return null;
        }
        return this.getKnowledgeData().map(data -> this.findOnboardingItemById((KnowledgeData)data, id)).orElse(null);
    }

    public BaseItem getItemById(String id) {
        if (this.isNullOrEmpty(id)) {
            return null;
        }
        KnowledgeItem knowledgeItem = this.getKnowledgeItemById(id);
        if (knowledgeItem != null) {
            return knowledgeItem;
        }
        OnboardingTour onboardingTour = this.getOnboardingItemById(id);
        return onboardingTour;
    }

    private Optional<KnowledgeData> getKnowledgeData() {
        if (this.cachedData == null) {
            this.cachedData = this.loadKnowledgeJson();
        }
        return Optional.ofNullable(this.cachedData);
    }

    private KnowledgeItem findKnowledgeItemById(KnowledgeData data, String id) {
        Map knowledgeItems = data.getKnowledgeItems();
        if (knowledgeItems == null) {
            return null;
        }
        return (KnowledgeItem)knowledgeItems.get(id);
    }

    private OnboardingTour findOnboardingItemById(KnowledgeData data, String id) {
        Map onboardingItems = data.getOnboardingItems();
        if (onboardingItems == null) {
            return null;
        }
        return (OnboardingTour)onboardingItems.get(id);
    }

    private KnowledgeHub buildKnowledgeHub(KnowledgeData data) {
        KnowledgeHub hub = data.getKnowledgeHub();
        if (hub == null) {
            return new KnowledgeHub();
        }
        Map knowledgeItemMap = data.getKnowledgeItems();
        Map tourMap = data.getOnboardingItems();
        this.resolveCategory(hub.getWeb(), knowledgeItemMap, tourMap);
        this.resolveCategory(hub.getApi(), knowledgeItemMap, tourMap);
        this.resolveCategory(hub.getMobile(), knowledgeItemMap, tourMap);
        this.resolveCategory(hub.getDesktop(), knowledgeItemMap, tourMap);
        this.resolveCategory(hub.getForYou(), knowledgeItemMap, tourMap);
        return hub;
    }

    private void resolveCategory(KnowledgeCategory category, Map<String, KnowledgeItem> knowledgeItemMap, Map<String, OnboardingTour> tourMap) {
        if (category == null) {
            return;
        }
        category.setVideoDemos(this.resolveKnowledgeItems(category.getVideoIds(), knowledgeItemMap));
        category.setOnlineCourses(this.resolveKnowledgeItems(category.getCourseIds(), knowledgeItemMap));
        category.setDocumentations(this.resolveKnowledgeItems(category.getDocumentationIds(), knowledgeItemMap));
        category.setOnboardingTours(this.resolveOnboardingTours(category.getOnboardingTourIds(), tourMap));
    }

    private List<KnowledgeItem> resolveKnowledgeItems(List<String> ids, Map<String, KnowledgeItem> itemMap) {
        if (ids == null || itemMap == null) {
            return new ArrayList<KnowledgeItem>();
        }
        return ids.stream().map(itemMap::get).filter(item -> item != null).collect(Collectors.toList());
    }

    private List<BaseItem> resolveOnboardingTours(List<String> ids, Map<String, OnboardingTour> tourMap) {
        if (ids == null || tourMap == null) {
            return new ArrayList<BaseItem>();
        }
        return ids.stream().map(tourMap::get).filter(tour -> tour != null).map(tour -> tour).collect(Collectors.toList());
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }

    /*
     * Loose catch block
     */
    private KnowledgeData loadKnowledgeJson() {
        URL resourceUrl;
        block20: {
            Bundle bundle;
            block19: {
                try {
                    bundle = Platform.getBundle((String)BUNDLE_ID);
                    if (bundle != null) break block19;
                    LoggerSingleton.logError((String)MessageFormat.format(OnboardingMessageConstants.ERROR_BUNDLE_NOT_FOUND, BUNDLE_ID));
                    return null;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((String)MessageFormat.format(OnboardingMessageConstants.ERROR_LOADING_KNOWLEDGE_JSON, e));
                    return null;
                }
            }
            resourceUrl = bundle.getEntry(KNOWLEDGE_RESOURCE_PATH);
            if (resourceUrl != null) break block20;
            LoggerSingleton.logError((String)MessageFormat.format(OnboardingMessageConstants.ERROR_RESOURCE_NOT_FOUND, KNOWLEDGE_RESOURCE_PATH));
            return null;
        }
        URL fileUrl = FileLocator.toFileURL((URL)resourceUrl);
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            KnowledgeData knowledgeData;
            InputStreamReader reader;
            InputStream inputStream;
            block22: {
                block21: {
                    inputStream = fileUrl.openStream();
                    reader = new InputStreamReader(inputStream);
                    knowledgeData = (KnowledgeData)this.objectMapper.readValue((Reader)reader, KnowledgeData.class);
                    if (reader == null) break block21;
                    ((Reader)reader).close();
                }
                if (inputStream == null) break block22;
                inputStream.close();
            }
            return knowledgeData;
            {
                catch (Throwable throwable2) {
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

