/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.domain.tour;

import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverlayManager {
    private static final Logger logger = LoggerFactory.getLogger(OverlayManager.class);
    private static final int DEFAULT_OVERLAY_ALPHA = 20;
    private static final int REQUIRED_CLICK_COUNT_FOR_CLEANUP = 5;
    private HighlightOverlay overlay;
    private final Runnable cleanupCallback;

    public OverlayManager(Runnable cleanupCallback) {
        this.cleanupCallback = cleanupCallback;
    }

    public HighlightOverlay getOrCreateOverlay() {
        return this.getOrCreateOverlay(20);
    }

    public HighlightOverlay getOrCreateOverlay(int alpha) {
        if (this.overlay != null && !this.overlay.isDisposed()) {
            return this.overlay;
        }
        Shell mainShell = ShellManager.getMainShell();
        if (mainShell == null || mainShell.isDisposed()) {
            logger.warn("Cannot create overlay: main shell is null or disposed");
            return null;
        }
        this.overlay = new HighlightOverlay((Control)mainShell);
        this.overlay.setAlpha(alpha);
        ComponentEventUtil.onClick((Widget)this.overlay, event -> {
            if (event.count == 5 && this.cleanupCallback != null) {
                this.cleanupCallback.run();
            }
        });
        return this.overlay;
    }

    public void openOverlay() {
        if (this.overlay != null && !this.overlay.isDisposed() && !this.overlay.isVisible()) {
            this.overlay.open();
        }
    }

    public boolean isOverlayDisposed() {
        return this.overlay == null || this.overlay.isDisposed();
    }

    public HighlightOverlay getCurrentOverlay() {
        return this.overlay;
    }

    public void dispose() {
        HighlightOverlay overlayToDispose = this.overlay;
        if (overlayToDispose == null) {
            return;
        }
        this.overlay = null;
        Display.getDefault().asyncExec(() -> this.disposeOverlaySafely(overlayToDispose));
    }

    private void disposeOverlaySafely(HighlightOverlay overlayToDispose) {
        if (overlayToDispose == null) {
            return;
        }
        try {
            if (!overlayToDispose.isDisposed()) {
                overlayToDispose.close();
                overlayToDispose.dispose();
            }
        }
        catch (Exception e) {
            logger.error("Failed to dispose overlay: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

