/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.domain.tour;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.onboarding.application.controller.KnowledgeController;
import com.kms.katalon.onboarding.core.application.controller.IKnowledgeController;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.repository.entity.OnboardingPreferences;
import com.kms.katalon.onboarding.domain.tour.IStepListener;
import com.kms.katalon.onboarding.domain.tour.StepGroupHandler;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class StepHandler {
    private String id;
    public boolean isDisposed = false;
    public StepGroupHandler stepgroup;
    public boolean needConfirmDialogWhenClose = true;
    protected List<IStepListener> stepListeners = new ArrayList<IStepListener>();

    public StepHandler(String id) {
        this.id = id;
        this.initialize();
    }

    public void addStepListener(IStepListener stepListener) {
        this.stepListeners.add(stepListener);
    }

    public StepGroupHandler getGroup() {
        return this.stepgroup;
    }

    public String getId() {
        return this.id;
    }

    public abstract void setUp();

    public abstract void cleanup();

    public void completeStep() {
        this.stepListeners.forEach(t -> {
            try {
                t.onActionCompleted();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LoggerSingleton.logError((String)OnboardingMessageConstants.ERROR_FAILED_TO_NOTIFY_LISTENER);
            }
        });
        this.cleanup();
    }

    public void exitStep() {
        this.stepListeners.forEach(IStepListener::onExit);
        this.cleanup();
    }

    public void resumeStep() {
        this.stepListeners.forEach(IStepListener::onResume);
    }

    public void error(Exception e) {
        this.stepListeners.forEach(listener -> {
            try {
                listener.onError(e);
            }
            catch (Exception listenerException) {
                LoggerSingleton.logError((String)MessageFormat.format(OnboardingMessageConstants.ERROR_NOTIFYING_STEP_LISTENER, listenerException.getMessage()));
            }
        });
    }

    private void initialize() {
        BundleContext bundleContext = FrameworkUtil.getBundle(StepHandler.class).getBundleContext();
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        IKnowledgeController knowledgeController = (IKnowledgeController)ContextInjectionFactory.make(KnowledgeController.class, (IEclipseContext)context);
        OnboardingPreferences preferences = knowledgeController.getOnboardingPreferences();
        this.needConfirmDialogWhenClose = !preferences.isSkipExitOnboardingConfirmation();
    }
}

