/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.presentation.dialog;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.quickstart.BaseQuickStartDialog;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTour;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTourProgress;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RatingOnboardingDialog
extends BaseQuickStartDialog {
    private final int DIALOG_WIDTH = 600;
    private final int MIN_DIALOG_HEIGHT = 370;
    private int rating;
    private OnboardingTour tour;
    private OnboardingTourProgress progress;
    private Text feedbackText;
    private String feedback = "";
    private Control sendButton;

    public RatingOnboardingDialog(Shell parentShell, OnboardingTour tour, OnboardingTourProgress progress) {
        super(parentShell);
        this.tour = tour;
        this.progress = progress;
        this.setShellStyle(67696);
        this.setReturnCode(1);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("");
        shell.setMinimumSize(600, 370);
        Rectangle displayBounds = Display.getCurrent().getPrimaryMonitor().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shell.setLocation((displayBounds.width - shellBounds.width) / 2, (displayBounds.height - shellBounds.height) / 2);
    }

    protected Point getInitialSize() {
        return new Point(600, 370);
    }

    public String getDialogTitle() {
        return "";
    }

    protected void createContent(Composite container) {
        ComponentBuilder.fromGrid((Composite)container).margin(30, 40, 30, 40).gridVerticalSpacing(20).fill().build();
        ComponentBuilder.label((Composite)container).text(OnboardingMessageConstants.RATING_DIALOG_TITLE).font(FontUtil.H2_BOLD).center().textCenter().fillHorizontal().build();
        ComponentBuilder.label((Composite)container).text(OnboardingMessageConstants.RATING_DIALOG_DESCRIPTION).center().fillHorizontal().textCenter().font(FontUtil.H4).build();
        this.feedbackText = (Text)ComponentBuilder.text((Composite)container, (int)2626).placeholder(OnboardingMessageConstants.RATING_DIALOG_FEEDBACK_PLACEHOLDER).fill().autoHeight(120).onChange(event -> {
            this.feedback = this.feedbackText.getText();
        }).build();
    }

    protected void createButtons(Composite parent) {
        Composite containerPanel = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1).fill().margin(0).build();
        Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)containerPanel, (int)2).margin(15, 0, 0, 0).fillHorizontal().build();
        ComponentBuilder.label((Composite)buttonBar).text("").fillHorizontal().build();
        this.sendButton = (Control)ComponentBuilder.canvas((Composite)buttonBar).text(OnboardingMessageConstants.RATING_DIALOG_SEND_BUTTON_TEXT).hoverBackground(ColorUtil.LILAC_BUTTON_COLOR_HOVER).background(ColorUtil.LILAC_BUTTON_COLOR).color(ColorUtil.WHITE_COLOR).borderRadius(8).autoSize(120, 40).onClick(event -> {
            this.setReturnCode(0);
            this.close();
        }).build();
    }

    public boolean close() {
        return super.close();
    }

    public int open() {
        int result = super.open();
        Display.getCurrent().asyncExec(() -> {
            if (this.sendButton != null && !this.sendButton.isDisposed()) {
                this.sendButton.setFocus();
            }
        });
        return result;
    }

    protected boolean isResizable() {
        return true;
    }

    protected boolean isClosable() {
        return true;
    }

    protected void initializeBounds() {
        Shell shell = this.getShell();
        shell.setSize(600, 370);
        shell.layout(true, true);
        Point computedSize = shell.computeSize(-1, -1);
        int width = Math.max(600, computedSize.x);
        int height = Math.max(370, computedSize.y);
        Rectangle displayBounds = Display.getCurrent().getPrimaryMonitor().getBounds();
        shell.setSize(width, height);
        Rectangle shellBounds = shell.getBounds();
        shell.setLocation(displayBounds.x + (displayBounds.width - shellBounds.width) / 2, displayBounds.y + (displayBounds.height - shellBounds.height) / 2);
    }

    public String getFeedback() {
        return this.feedback;
    }
}

